/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.loot.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.blocks.mob_head.PastelSkullBlock;
import earth.terrarium.pastel.blocks.mob_head.PastelSkullType;
import earth.terrarium.pastel.entity.PastelEntityTypes;
import earth.terrarium.pastel.entity.entity.LizardEntity;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.progression.PastelCriteria;
import earth.terrarium.pastel.registries.PastelEnchantments;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class TreasureHunterModifier
extends LootModifier {
    private static final Map<Holder<EntityType<?>>, HeadProvider> SPECIAL_CASES = new HashMap();
    public static final MapCodec<TreasureHunterModifier> CODEC = RecordCodecBuilder.mapCodec(i -> LootModifier.codecStart((RecordCodecBuilder.Instance)i).and(i.group((App)TagKey.codec((ResourceKey)Registries.ENTITY_TYPE).fieldOf("special").forGetter(m -> m.special), (App)TagKey.codec((ResourceKey)Registries.ENTITY_TYPE).optionalFieldOf("exempt").forGetter(m -> m.exempt), (App)Codec.FLOAT.fieldOf("chance").forGetter(m -> Float.valueOf(m.chance)), (App)Codec.FLOAT.fieldOf("special_chance").forGetter(m -> Float.valueOf(m.specialChance)))).apply((Applicative)i, TreasureHunterModifier::new));
    private final float chance;
    private final float specialChance;
    private final TagKey<EntityType<?>> special;
    private final Optional<TagKey<EntityType<?>>> exempt;

    protected TreasureHunterModifier(LootItemCondition[] conditionsIn, TagKey<EntityType<?>> special, Optional<TagKey<EntityType<?>>> exempt, float chance, float specialChance) {
        super(conditionsIn);
        this.chance = chance;
        this.specialChance = specialChance;
        this.special = special;
        this.exempt = exempt;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> original, LootContext lootContext) {
        DamageSource type;
        Entity target = (Entity)lootContext.getParamOrNull(LootContextParams.THIS_ENTITY);
        Player player = (Player)lootContext.getParamOrNull(LootContextParams.LAST_DAMAGE_PLAYER);
        float scalingChance = this.chance;
        if (target == null) {
            return original;
        }
        if (this.exempt.map(e -> target.getType().is(e)).orElse(false).booleanValue()) {
            return original;
        }
        if (target.getType().is(this.special)) {
            scalingChance = this.specialChance;
        }
        if ((type = (DamageSource)lootContext.getParamOrNull(LootContextParams.DAMAGE_SOURCE)) == null) {
            return original;
        }
        ItemStack weapon = type.getWeaponItem();
        if (weapon == null) {
            return original;
        }
        int level = Ench.getLevel((HolderLookup.Provider)lootContext.getLevel().registryAccess(), PastelEnchantments.TREASURE_HUNTER, weapon);
        Optional<Item> head = TreasureHunterModifier.tryGetHead(target);
        if (!this.shouldDrop(head, scalingChance, level, lootContext.getRandom())) {
            return original;
        }
        assert (head.isPresent());
        ItemStack headStack = new ItemStack((ItemLike)head.get());
        original.add((Object)headStack);
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            PastelCriteria.LOOT_FUNCTION_TRIGGER.trigger(sp, headStack);
        }
        return original;
    }

    public static Optional<Item> tryGetHead(Entity target) {
        Holder.Reference typeHolder = target.getType().builtInRegistryHolder();
        if (SPECIAL_CASES.containsKey(typeHolder)) {
            return Optional.of(SPECIAL_CASES.get(typeHolder).get(target).asItem());
        }
        for (int i = 0; i < 2; ++i) {
            Block head;
            Object rawId = typeHolder.key().location().toString();
            if (i == 1) {
                rawId = "pastel:" + typeHolder.key().location().getPath();
            }
            if ((head = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.tryParse((String)((String)rawId + "_head")))) instanceof AbstractSkullBlock) {
                return Optional.of(head.asItem());
            }
            head = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.tryParse((String)((String)rawId + "_skull")));
            if (!(head instanceof AbstractSkullBlock)) continue;
            return Optional.of(head.asItem());
        }
        return Optional.empty();
    }

    private boolean shouldDrop(Optional<Item> head, float chance, int level, RandomSource random) {
        if (head.isEmpty()) {
            return false;
        }
        return random.nextFloat() <= chance * (float)level;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    static {
        SPECIAL_CASES.put((Holder<EntityType<?>>)EntityType.FOX.builtInRegistryHolder(), entity -> switch (((Fox)entity).getVariant()) {
            default -> throw new MatchException(null, null);
            case Fox.Type.RED -> (Block)PastelSkullBlock.MOB_HEADS.get((Object)PastelSkullType.FOX);
            case Fox.Type.SNOW -> (Block)PastelSkullBlock.MOB_HEADS.get((Object)PastelSkullType.FOX_ARCTIC);
        });
        SPECIAL_CASES.put((Holder<EntityType<?>>)EntityType.MOOSHROOM.builtInRegistryHolder(), entity -> switch (((MushroomCow)entity).getVariant()) {
            default -> throw new MatchException(null, null);
            case MushroomCow.MushroomType.RED -> (Block)PastelSkullBlock.MOB_HEADS.get((Object)PastelSkullType.MOOSHROOM_RED);
            case MushroomCow.MushroomType.BROWN -> (Block)PastelSkullBlock.MOB_HEADS.get((Object)PastelSkullType.MOOSHROOM_BROWN);
        });
        SPECIAL_CASES.put((Holder<EntityType<?>>)EntityType.AXOLOTL.builtInRegistryHolder(), entity -> switch (((Axolotl)entity).getVariant()) {
            default -> throw new MatchException(null, null);
            case Axolotl.Variant.LUCY -> (Block)PastelSkullBlock.MOB_HEADS.get((Object)PastelSkullType.AXOLOTL_LEUCISTIC);
            case Axolotl.Variant.WILD -> (Block)PastelSkullBlock.MOB_HEADS.get((Object)PastelSkullType.AXOLOTL_WILD);
            case Axolotl.Variant.GOLD -> (Block)PastelSkullBlock.MOB_HEADS.get((Object)PastelSkullType.AXOLOTL_GOLD);
            case Axolotl.Variant.CYAN -> (Block)PastelSkullBlock.MOB_HEADS.get((Object)PastelSkullType.AXOLOTL_CYAN);
            case Axolotl.Variant.BLUE -> (Block)PastelSkullBlock.MOB_HEADS.get((Object)PastelSkullType.AXOLOTL_BLUE);
        });
        SPECIAL_CASES.put((Holder<EntityType<?>>)EntityType.ENDER_DRAGON.builtInRegistryHolder(), entity -> Blocks.DRAGON_HEAD);
        SPECIAL_CASES.put((Holder<EntityType<?>>)EntityType.PARROT.builtInRegistryHolder(), entity -> switch (((Parrot)entity).getVariant()) {
            default -> throw new MatchException(null, null);
            case Parrot.Variant.RED_BLUE -> (Block)PastelSkullBlock.MOB_HEADS.get((Object)PastelSkullType.PARROT_RED);
            case Parrot.Variant.BLUE -> (Block)PastelSkullBlock.MOB_HEADS.get((Object)PastelSkullType.PARROT_BLUE);
            case Parrot.Variant.GREEN -> (Block)PastelSkullBlock.MOB_HEADS.get((Object)PastelSkullType.PARROT_GREEN);
            case Parrot.Variant.YELLOW_BLUE -> (Block)PastelSkullBlock.MOB_HEADS.get((Object)PastelSkullType.PARROT_CYAN);
            case Parrot.Variant.GRAY -> (Block)PastelSkullBlock.MOB_HEADS.get((Object)PastelSkullType.PARROT_GRAY);
        });
        SPECIAL_CASES.put((Holder<EntityType<?>>)EntityType.FROG.builtInRegistryHolder(), entity -> {
            Holder variant = ((Frog)entity).getVariant();
            if (variant == FrogVariant.WARM) {
                return (Block)PastelSkullBlock.MOB_HEADS.get((Object)PastelSkullType.FROG_COLD);
            }
            if (variant == FrogVariant.COLD) {
                return (Block)PastelSkullBlock.MOB_HEADS.get((Object)PastelSkullType.FROG_WARM);
            }
            return (Block)PastelSkullBlock.MOB_HEADS.get((Object)PastelSkullType.FROG_TEMPERATE);
        });
        SPECIAL_CASES.put((Holder<EntityType<?>>)EntityType.SHULKER.builtInRegistryHolder(), entity -> {
            Optional color = ((Shulker)entity).getVariant();
            PastelSkullType type = PastelSkullType.SHULKER;
            if (color.isEmpty()) {
                return (Block)PastelSkullBlock.MOB_HEADS.get((Object)type);
            }
            type = switch ((DyeColor)color.get()) {
                default -> throw new MatchException(null, null);
                case DyeColor.WHITE -> PastelSkullType.SHULKER_WHITE;
                case DyeColor.ORANGE -> PastelSkullType.SHULKER_ORANGE;
                case DyeColor.MAGENTA -> PastelSkullType.SHULKER_MAGENTA;
                case DyeColor.LIGHT_BLUE -> PastelSkullType.SHULKER_LIGHT_BLUE;
                case DyeColor.YELLOW -> PastelSkullType.SHULKER_YELLOW;
                case DyeColor.LIME -> PastelSkullType.SHULKER_LIME;
                case DyeColor.PINK -> PastelSkullType.SHULKER_PINK;
                case DyeColor.GRAY -> PastelSkullType.SHULKER_GRAY;
                case DyeColor.LIGHT_GRAY -> PastelSkullType.SHULKER_LIGHT_GRAY;
                case DyeColor.CYAN -> PastelSkullType.SHULKER_CYAN;
                case DyeColor.PURPLE -> PastelSkullType.SHULKER_PURPLE;
                case DyeColor.BLUE -> PastelSkullType.SHULKER_BLUE;
                case DyeColor.BROWN -> PastelSkullType.SHULKER_BROWN;
                case DyeColor.GREEN -> PastelSkullType.SHULKER_GREEN;
                case DyeColor.RED -> PastelSkullType.SHULKER_RED;
                case DyeColor.BLACK -> PastelSkullType.SHULKER_BLACK;
            };
            return (Block)PastelSkullBlock.MOB_HEADS.get((Object)type);
        });
        SPECIAL_CASES.put((Holder<EntityType<?>>)PastelEntityTypes.LIZARD, entity -> {
            InkColor color = ((LizardEntity)entity).getColor();
            PastelSkullType type = PastelSkullType.LIZARD_WHITE;
            type = switch (color.getDyeColor().get()) {
                default -> throw new MatchException(null, null);
                case DyeColor.WHITE -> PastelSkullType.LIZARD_WHITE;
                case DyeColor.ORANGE -> PastelSkullType.LIZARD_ORANGE;
                case DyeColor.MAGENTA -> PastelSkullType.LIZARD_MAGENTA;
                case DyeColor.LIGHT_BLUE -> PastelSkullType.LIZARD_LIGHT_BLUE;
                case DyeColor.YELLOW -> PastelSkullType.LIZARD_YELLOW;
                case DyeColor.LIME -> PastelSkullType.LIZARD_LIME;
                case DyeColor.PINK -> PastelSkullType.LIZARD_PINK;
                case DyeColor.GRAY -> PastelSkullType.LIZARD_GRAY;
                case DyeColor.LIGHT_GRAY -> PastelSkullType.LIZARD_LIGHT_GRAY;
                case DyeColor.CYAN -> PastelSkullType.LIZARD_CYAN;
                case DyeColor.PURPLE -> PastelSkullType.LIZARD_PURPLE;
                case DyeColor.BLUE -> PastelSkullType.LIZARD_BLUE;
                case DyeColor.BROWN -> PastelSkullType.LIZARD_BROWN;
                case DyeColor.GREEN -> PastelSkullType.LIZARD_GREEN;
                case DyeColor.RED -> PastelSkullType.LIZARD_RED;
                case DyeColor.BLACK -> PastelSkullType.LIZARD_BLACK;
            };
            return (Block)PastelSkullBlock.MOB_HEADS.get((Object)type);
        });
    }

    @FunctionalInterface
    private static interface HeadProvider {
        public Block get(Entity var1);
    }
}

