/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.trinkets;

import com.google.common.collect.Multimap;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.items.trinkets.PastelTrinketItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import top.theillusivec4.curios.api.SlotContext;

public class SevenLeagueBootsItem
extends PastelTrinketItem {
    public static final ResourceLocation MOVEMENT_SPEED_ATTRIBUTE_ID = PastelCommon.locate("seven_league_boots_movement_speed");
    public static final ResourceLocation STEP_UP_ATTRIBUTE_ID = PastelCommon.locate("seven_league_boots_step_up");

    public SevenLeagueBootsItem(Item.Properties settings) {
        super(settings, PastelCommon.locate("unlocks/trinkets/seven_league_boots"));
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        AttributeInstance attribute = slotContext.entity().getAttribute(Attributes.STEP_HEIGHT);
        if (attribute == null) {
            return;
        }
        boolean hasMod = attribute.hasModifier(STEP_UP_ATTRIBUTE_ID);
        if (!slotContext.entity().isCrouching() && !hasMod) {
            attribute.addTransientModifier(new AttributeModifier(STEP_UP_ATTRIBUTE_ID, 0.75, AttributeModifier.Operation.ADD_VALUE));
        }
        if (slotContext.entity().isCrouching() && hasMod) {
            attribute.removeModifier(STEP_UP_ATTRIBUTE_ID);
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        AttributeInstance attribute = slotContext.entity().getAttribute(Attributes.STEP_HEIGHT);
        if (attribute != null && attribute.hasModifier(STEP_UP_ATTRIBUTE_ID)) {
            attribute.removeModifier(STEP_UP_ATTRIBUTE_ID);
        }
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, Item.TooltipContext context, ItemStack stack) {
        List result = super.getAttributesTooltip(tooltips, context, stack);
        result.add(Component.literal((String)"When not crouching:").withStyle(ChatFormatting.GOLD));
        result.add(Component.literal((String)"+0.75 Step Height").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)" [+0.75]").withStyle(ChatFormatting.GRAY)));
        return result;
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(slotContext, id, stack);
        int powerLevel = slotContext.entity() != null ? Ench.getLevel((HolderLookup.Provider)slotContext.entity().level().registryAccess(), (ResourceKey<Enchantment>)Enchantments.POWER, stack) : 0;
        double speedBoost = 0.05 * (double)(powerLevel + 1);
        modifiers.put((Object)Attributes.MOVEMENT_SPEED, (Object)new AttributeModifier(MOVEMENT_SPEED_ATTRIBUTE_ID, speedBoost, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        return modifiers;
    }

    public boolean isEnchantable(ItemStack stack) {
        return stack.getCount() == 1;
    }

    public int getEnchantmentValue() {
        return 8;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return super.supportsEnchantment(stack, enchantment) || enchantment.is(Enchantments.POWER);
    }
}

