/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.trinkets;

import com.google.common.collect.Multimap;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.storage.FixedSingleInkStorage;
import earth.terrarium.pastel.api.item.GravitableItem;
import earth.terrarium.pastel.items.trinkets.InkDrainTrinketItem;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;

public abstract class GravityRingItem
extends InkDrainTrinketItem
implements GravitableItem {
    public GravityRingItem(Item.Properties settings, ResourceLocation unlockIdentifier, InkColor inkColor) {
        super(settings, unlockIdentifier, inkColor);
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(slotContext, id, stack);
        FixedSingleInkStorage inkStorage = this.getEnergyStorage(stack);
        long storedInk = inkStorage.getEnergy(inkStorage.getStoredColor());
        double knockbackResistance = this.getBonus(storedInk) / 10.0;
        if (knockbackResistance != 0.0) {
            modifiers.put((Object)Attributes.KNOCKBACK_RESISTANCE, (Object)new AttributeModifier(this.getAttributeID(), this.negativeGravity() ? -knockbackResistance : knockbackResistance, AttributeModifier.Operation.ADD_VALUE));
        }
        return modifiers;
    }

    protected abstract ResourceLocation getAttributeID();

    protected abstract boolean negativeGravity();

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        this.applyGravity(stack, slotContext.entity().level(), (Entity)slotContext.entity());
    }

    public double getBonus(long storedInk) {
        if (storedInk < 100L) {
            return 0.0;
        }
        return 1 + (int)(Math.log((float)storedInk / 100.0f) / Math.log(8.0));
    }

    @Override
    public float getGravityMod(ItemStack stack) {
        FixedSingleInkStorage inkStorage = this.getEnergyStorage(stack);
        long storedInk = inkStorage.getEnergy(inkStorage.getStoredColor());
        float bonus = (float)this.getBonus(storedInk) / 100.0f;
        return this.negativeGravity() ? bonus : -bonus;
    }
}

