/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.trinkets;

import com.google.common.collect.Multimap;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.api.energy.storage.FixedSingleInkStorage;
import earth.terrarium.pastel.items.trinkets.InkDrainTrinketItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import top.theillusivec4.curios.api.SlotContext;

public class ExtraReachGlovesItem
extends InkDrainTrinketItem {
    public static ResourceLocation BLOCK_INTERACTION_ATTRIBUTE_ID = PastelCommon.locate("gloves_of_dawns_grasp_block_interaction");
    public static ResourceLocation ENTITY_INTERACTION_ATTRIBUTE_ID = PastelCommon.locate("gloves_of_dawns_grasp_entity_interaction");

    public ExtraReachGlovesItem(Item.Properties settings) {
        super(settings, PastelCommon.locate("unlocks/trinkets/gloves_of_dawns_grasp"), InkColors.LIGHT_BLUE);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.translatable((String)"item.pastel.gloves_of_dawns_grasp.tooltip").withStyle(ChatFormatting.GRAY));
        super.appendHoverText(stack, context, tooltip, type);
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(slotContext, id, stack);
        FixedSingleInkStorage inkStorage = this.getEnergyStorage(stack);
        long storedInk = inkStorage.getEnergy(inkStorage.getStoredColor());
        double extraReach = this.getExtraReach(storedInk);
        if (extraReach != 0.0) {
            modifiers.put((Object)Attributes.BLOCK_INTERACTION_RANGE, (Object)new AttributeModifier(BLOCK_INTERACTION_ATTRIBUTE_ID, extraReach, AttributeModifier.Operation.ADD_VALUE));
            modifiers.put((Object)Attributes.ENTITY_INTERACTION_RANGE, (Object)new AttributeModifier(ENTITY_INTERACTION_ATTRIBUTE_ID, extraReach / 6.0, AttributeModifier.Operation.ADD_VALUE));
        }
        return modifiers;
    }

    public double getExtraReach(long storedInk) {
        if (storedInk < 100L) {
            return 0.0;
        }
        return 0.5 + ExtraReachGlovesItem.roundHalf(Math.log((float)storedInk / 100.0f) / Math.log(64.0));
    }

    public static double roundHalf(double number) {
        return (double)((int)(number * 2.0)) / 2.0;
    }
}

