/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.trinkets;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.items.trinkets.PastelTrinketItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.SlotContext;

public class CottonCloudBootsItem
extends PastelTrinketItem {
    public CottonCloudBootsItem(Item.Properties settings) {
        super(settings, PastelCommon.locate("unlocks/trinkets/cotton_cloud_boots"));
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        LivingEntity entity = slotContext.entity();
        Level world = entity.level();
        if (entity.isSprinting() && !entity.onGround() && !entity.isShiftKeyDown()) {
            Vec3 velocity = entity.getDeltaMovement();
            if (velocity.y < 0.0) {
                entity.setDeltaMovement(entity.getDeltaMovement().multiply(1.0, 0.1, 1.0));
                if (world.isClientSide) {
                    RandomSource random = world.random;
                    world.addParticle((ParticleOptions)ParticleTypes.CLOUD, entity.getX(), entity.getY(), entity.getZ(), 0.125 - (double)random.nextFloat() * 0.25, 0.04 - (double)random.nextFloat() * 0.08, 0.125 - (double)random.nextFloat() * 0.25);
                }
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.pastel.cotton_cloud_boots.tooltip").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.pastel.cotton_cloud_boots.tooltip2").withStyle(ChatFormatting.GRAY));
    }
}

