/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.trinkets;

import com.google.common.collect.Multimap;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.render.SlotBackgroundEffect;
import earth.terrarium.pastel.attachments.data.azure_dike.AzureDikeProvider;
import earth.terrarium.pastel.items.trinkets.AzureDikeTrinketItem;
import earth.terrarium.pastel.registries.PastelEntityAttributes;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelMobEffectTags;
import earth.terrarium.pastel.registries.PastelMobEffects;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;

public class AetherGracedNectarGlovesItem
extends AzureDikeTrinketItem
implements SlotBackgroundEffect {
    public static final int HARMFUL_EFFECT_COST = 5;
    public static ResourceLocation MENTAL_PRESENCE_ATTRIBUTE_ID = PastelCommon.locate("nectar_gloves_sleep");

    public AetherGracedNectarGlovesItem(Item.Properties settings, ResourceLocation unlockIdentifier) {
        super(settings, unlockIdentifier);
    }

    @Override
    public int maxAzureDike(ItemStack stack) {
        return 10;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.pastel.aether_graced_nectar_gloves.tooltip"));
        tooltip.add((Component)Component.translatable((String)"item.pastel.aether_graced_nectar_gloves.tooltip2"));
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(slotContext, id, stack);
        modifiers.put(PastelEntityAttributes.MENTAL_PRESENCE, (Object)new AttributeModifier(MENTAL_PRESENCE_ATTRIBUTE_ID, -1.0, AttributeModifier.Operation.ADD_VALUE));
        return modifiers;
    }

    public static boolean testEffectFor(LivingEntity entity, Holder<MobEffect> effect) {
        if (((MobEffect)effect.value()).isBeneficial()) {
            return false;
        }
        if (effect.is(PastelMobEffectTags.BYPASSES_NECTAR_GLOVES)) {
            return false;
        }
        return AetherGracedNectarGlovesItem.hasEquipped(entity, (Item)PastelItems.AETHER_GRACED_NECTAR_GLOVES.get()) && (((MobEffect)effect.value()).getCategory() == MobEffectCategory.HARMFUL || effect == PastelMobEffects.FRENZY);
    }

    public static boolean tryBlockEffect(LivingEntity entity, int cost) {
        if (AzureDikeProvider.getAzureDikeCharges(entity) == 0.0f) {
            return false;
        }
        return AzureDikeProvider.absorbDamage(entity, cost) == 0.0f;
    }

    @Override
    public SlotBackgroundEffect.SlotEffect backgroundType(@Nullable Player player, ItemStack stack) {
        return SlotBackgroundEffect.SlotEffect.BORDER_FADE;
    }

    @Override
    public int getBackgroundColor(@Nullable Player player, ItemStack stack, float tickDelta) {
        return 12804078;
    }
}

