/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.tools;

import earth.terrarium.pastel.api.item.Stampable;
import earth.terrarium.pastel.api.item.TooltipExtensions;
import earth.terrarium.pastel.helpers.level.BlockReference;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TuningStampItem
extends Item
implements TooltipExtensions {
    public static final String DATA = "pastel:stamping_data";

    public TuningStampItem(Item.Properties settings) {
        super(settings);
    }

    public boolean canAttackBlock(BlockState state, Level world, BlockPos pos, Player miner) {
        return false;
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Optional<Player> player = Optional.ofNullable(context.getPlayer());
        BlockReference reference = BlockReference.of((LevelAccessor)world, pos);
        Optional<Object> potentialData = Optional.empty();
        CustomData nbtComp = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        if (nbtComp.contains(DATA)) {
            potentialData = Stampable.loadStampingData(world, nbtComp.copyTag().getCompound(DATA));
        }
        if (potentialData.isPresent()) {
            Stampable.StampData target;
            Optional<Stampable.StampData> potentialTarget = this.getData(player, reference, world);
            if (potentialTarget.isEmpty()) {
                return InteractionResult.PASS;
            }
            Stampable.StampData source = (Stampable.StampData)potentialData.get();
            if (!source.verifyStampData(target = potentialTarget.get()) || !target.canUserStamp(player)) {
                this.tryPlaySound(player, PastelSounds.SHATTER_LIGHT, 0.75f);
                return InteractionResult.FAIL;
            }
            Stampable interactable = target.source();
            boolean targetChanged = interactable.handleImpression(source.stamper(), player, source.reference(), world);
            source.notifySourceOfChange(target, targetChanged);
            if (!targetChanged) {
                this.tryPlaySound(player, PastelSounds.SHATTER_HEAVY, 0.45f);
                return InteractionResult.FAIL;
            }
            player.ifPresent(user -> {
                if (!user.isShiftKeyDown()) {
                    Stampable.StampData newSource = target.source().recordStampData(player, reference, world);
                    this.saveToNbt(stack, newSource);
                    this.tryPlaySound(player, SoundEvents.AMETHYST_BLOCK_CHIME, 0.825f);
                } else {
                    this.tryPlaySound(player, PastelSounds.BLOCK_ONYX_BLOCK_CHIME, 0.825f);
                }
            });
            return InteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        Optional<Stampable.StampData> candidate = this.getData(player, reference, world);
        if (player.map(Entity::isShiftKeyDown).orElse(false).booleanValue()) {
            if (candidate.map(d -> d.canUserStamp(player)).orElse(false).booleanValue()) {
                candidate.get().source().clearImpression();
                this.tryPlaySound(player, SoundEvents.AMETHYST_BLOCK_BREAK, 0.825f);
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        if (candidate.isPresent() && candidate.get().canUserStamp(player)) {
            this.saveToNbt(stack, candidate.get());
            this.tryPlaySound(player, PastelSounds.CRYSTAL_STRIKE, 0.75f);
            return InteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        return super.useOn(context);
    }

    public void clearData(Optional<Player> player, ItemStack stack) {
        stack.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, comp -> comp.update(nbt -> nbt.remove(DATA)));
        this.tryPlaySound(player, SoundEvents.BRUSH_GENERIC, 1.0f);
    }

    private void tryPlaySound(Optional<Player> player, SoundEvent sound, float volume) {
        player.ifPresent(p -> p.level().playSound(null, (Entity)p, sound, SoundSource.PLAYERS, volume, 0.9f + p.getRandom().nextFloat() / 5.0f));
    }

    private void saveToNbt(ItemStack stack, Stampable.StampData data) {
        stack.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, comp -> comp.update(nbt -> nbt.put(DATA, (Tag)Stampable.saveStampingData(data))));
    }

    private Optional<Stampable.StampData> getData(Optional<Player> player, BlockReference reference, Level world) {
        Optional<Stampable.StampData> data = Optional.empty();
        Block block = reference.getState().getBlock();
        if (block instanceof Stampable) {
            Stampable interactable = (Stampable)block;
            data = Optional.ofNullable(interactable.recordStampData(player, reference, world));
        }
        if (!data.isPresent()) {
            data = reference.tryGetBlockEntity().map(be -> {
                if (be instanceof Stampable) {
                    Stampable interactable = (Stampable)be;
                    return interactable.recordStampData(player, reference, world);
                }
                return null;
            });
        }
        return data;
    }

    @Override
    public void appendTooltipWithPlayer(ItemStack stack, @Nullable Player player, List<Component> tooltip, Item.TooltipContext context) {
        CustomData nbtComp = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        if (player != null && nbtComp.contains(DATA)) {
            Optional<Stampable.StampData> data = Stampable.loadStampingData(player.level(), nbtComp.copyTag().getCompound(DATA));
            if (data.isEmpty()) {
                tooltip.add((Component)Component.translatable((String)"item.pastel.tuning_stamp.tooltip.missing").withStyle(style -> style.withColor(16741754)));
                return;
            }
            Stampable.StampData stampData = data.get();
            BlockPos pos = stampData.reference().pos;
            tooltip.add((Component)Component.translatable((String)"item.pastel.tuning_stamp.tooltip.linked", (Object[])new Object[]{stampData.reference().getState().getBlock().getName()}).withStyle(style -> style.withColor(16763276)));
            tooltip.add((Component)Component.translatable((String)"item.pastel.tuning_stamp.tooltip2", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}).withStyle(style -> style.withColor(16358281).withItalic(Boolean.valueOf(true))));
            return;
        }
        tooltip.add((Component)Component.translatable((String)"item.pastel.tuning_stamp.tooltip").withStyle(ChatFormatting.GRAY));
    }

    @Override
    public void expandTooltipPostStats(ItemStack stack, @Nullable Player player, List<Component> tooltip, Item.TooltipContext context) {
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"item.pastel.tuning_stamp.controls").withStyle(style -> style.withColor(0x66FF99)));
            tooltip.add((Component)Component.translatable((String)"item.pastel.tuning_stamp.controls2").withStyle(style -> style.withColor(0x66FF99)));
            tooltip.add((Component)Component.translatable((String)"item.pastel.tuning_stamp.controls3").withStyle(style -> style.withColor(0x66FF99)));
        } else {
            tooltip.add((Component)Component.translatable((String)"pastel.tooltip.press_shift_for_controls").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        }
    }
}

