/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.tools;

import earth.terrarium.pastel.api.energy.InkCost;
import earth.terrarium.pastel.api.energy.InkPowered;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.api.item.SplitDamageHandler;
import earth.terrarium.pastel.api.render.ExtendedItemBar;
import earth.terrarium.pastel.api.render.SlotBackgroundEffect;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.items.tools.GreatswordItem;
import earth.terrarium.pastel.registries.PastelSounds;
import earth.terrarium.pastel.sound.GreatswordChargingSoundInstance;
import earth.terrarium.pastel.spells.MoonstoneStrike;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlassCrestGreatswordItem
extends GreatswordItem
implements SplitDamageHandler,
ExtendedItemBar,
SlotBackgroundEffect,
InkPowered {
    private static final InkCost GROUND_SLAM_COST = new InkCost(InkColors.WHITE, 25L);
    public static final float MAGIC_DAMAGE_SHARE = 0.25f;
    public final int GROUND_SLAM_CHARGE_TICKS = 32;

    public GlassCrestGreatswordItem(Tier material, int attackDamage, float attackSpeed, float extraReach, Item.Properties settings) {
        super(material, attackDamage, attackSpeed, extraReach, settings);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.pastel.glass_crest_ultra_greatsword.tooltip", (Object[])new Object[]{25}));
        tooltip.add((Component)Component.translatable((String)"item.pastel.glass_crest_ultra_greatsword.tooltip2"));
        this.addInkPoweredTooltip(tooltip);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (this.getGroundSlamStrength((HolderLookup.Provider)world.registryAccess(), user.getItemInHand(hand)) > 0 && InkPowered.tryDrainEnergy(user, GROUND_SLAM_COST)) {
            if (world.isClientSide) {
                this.startSoundInstance(user);
            }
            return ItemUtils.startUsingInstantly((Level)world, (Player)user, (InteractionHand)hand);
        }
        return InteractionResultHolder.pass((Object)user.getItemInHand(hand));
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 32;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public void onUseTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        super.onUseTick(world, user, stack, remainingUseTicks);
        if (world.isClientSide) {
            RandomSource random = world.random;
            for (int i = 0; i < (32 - remainingUseTicks) / 8; ++i) {
                world.addParticle((ParticleOptions)ParticleTypes.INSTANT_EFFECT, user.getRandomX(1.0), user.getY(), user.getRandomZ(1.0), random.nextDouble() * 5.0 - 2.5, random.nextDouble() * 1.2, random.nextDouble() * 5.0 - 2.5);
            }
        }
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
        int groundSlamStrength;
        if (!world.isClientSide && (groundSlamStrength = this.getGroundSlamStrength((HolderLookup.Provider)world.registryAccess(), stack)) > 0) {
            this.performGroundSlam(world, user.position(), user, groundSlamStrength);
            stack.hurtAndBreak(1, user, LivingEntity.getSlotForHand((InteractionHand)user.getUsedItemHand()));
        }
        return stack;
    }

    public int getGroundSlamStrength(HolderLookup.Provider lookup, ItemStack stack) {
        return Ench.getLevel(lookup, (ResourceKey<Enchantment>)Enchantments.SWEEPING_EDGE, stack);
    }

    public void performGroundSlam(Level level, Vec3 pos, LivingEntity attacker, float strength) {
        level.gameEvent((Entity)attacker, (Holder)GameEvent.HIT_GROUND, BlockPos.containing((double)pos.x, (double)pos.y, (double)pos.z));
        MoonstoneStrike.create(level, (Entity)attacker, null, attacker.getX(), attacker.getY(), attacker.getZ(), strength, 1.75f, Support.varFloat(level.random, 0.2f) - 0.1f);
        level.playSound(null, attacker.blockPosition(), PastelSounds.GROUND_SLAM, SoundSource.PLAYERS, 1.1f, Support.varFloatCentered(level.random, 0.1f));
        if (attacker instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)attacker;
            serverPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void startSoundInstance(Player user) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)new GreatswordChargingSoundInstance(user, this.GROUND_SLAM_CHARGE_TICKS));
    }

    @Override
    public SplitDamageHandler.DamageComposition getDamageComposition(LivingEntity attacker, LivingEntity target, ItemStack stack, float damage) {
        SplitDamageHandler.DamageComposition composition = new SplitDamageHandler.DamageComposition();
        composition.addPlayerOrEntity(attacker, damage * 0.75f);
        composition.add(attacker.damageSources().magic(), damage * 0.25f);
        return composition;
    }

    @Override
    public SlotBackgroundEffect.SlotEffect backgroundType(@Nullable Player player, ItemStack stack) {
        boolean usable = InkPowered.hasAvailableInk(player, GROUND_SLAM_COST);
        return usable ? SlotBackgroundEffect.SlotEffect.BORDER_FADE : SlotBackgroundEffect.SlotEffect.NONE;
    }

    @Override
    public int getBackgroundColor(@Nullable Player player, ItemStack stack, float tickDelta) {
        return 0xFFFFFF;
    }

    @Override
    public int barCount(ItemStack stack) {
        return 1;
    }

    @Override
    public boolean allowVanillaDurabilityBarRendering(@Nullable Player player, ItemStack stack) {
        if (player == null || player.getItemInHand(player.getUsedItemHand()) != stack) {
            return true;
        }
        return !player.isUsingItem();
    }

    @Override
    public ExtendedItemBar.BarSignature getSignature(@Nullable Player player, @NotNull ItemStack stack, int index) {
        if (player == null || !player.isUsingItem()) {
            return ExtendedItemBar.PASS;
        }
        ItemStack activeStack = player.getItemInHand(player.getUsedItemHand());
        if (activeStack != stack) {
            return ExtendedItemBar.PASS;
        }
        int progress = Math.round(Mth.clampedLerp((float)0.0f, (float)13.0f, (float)((float)player.getTicksUsingItem() / 32.0f)));
        return new ExtendedItemBar.BarSignature(2, 13, 13, progress, 1, -1, 2, -16777216);
    }

    @Override
    public List<InkColor> getUsedColors() {
        return List.of(GROUND_SLAM_COST.color());
    }
}

