/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.tools;

import com.cmdpro.databank.misc.ColorGradient;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.entity.entity.GlassArrowEntity;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import earth.terrarium.pastel.registries.PastelRegistries;
import java.awt.Color;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.commons.lang3.function.TriConsumer;

public class GlassArrowVariant {
    private static final Attributes MAL = new Attributes(1.5f, 2.0f, 0.0f, false, false, (ResourceKey<DamageType>)DamageTypes.MAGIC, 774816, 23904);
    private static final Attributes TOP = new Attributes(1.0f, 1.0f, 5.0f, false, false, PastelDamageTypes.IMPALING, 0xF0FFFD, 1868186);
    private static final Attributes AME = new Attributes(1.5f, 1.0f, 0.0f, false, true, (ResourceKey<DamageType>)DamageTypes.MAGIC, 0xFFD6FF, 13309128);
    private static final Attributes CIT = new Attributes(1.0f, 2.0f, 0.0f, true, false, (ResourceKey<DamageType>)DamageTypes.MAGIC, 0xFFFBF2, 16753183);
    private static final Attributes ONY = new Attributes(1.0f, 2.0f, 0.0f, false, false, (ResourceKey<DamageType>)DamageTypes.MAGIC, 0x66FFFF, 133397, (TriConsumer<GlassArrowEntity, HitResult, Level>)((TriConsumer)(arrow, v, level) -> level.getEntities((Entity)arrow, arrow.getBoundingBox().inflate(12.0)).forEach(target -> {
        if (v.getType() == HitResult.Type.ENTITY && ((EntityHitResult)v).getEntity() == target) {
            GlassArrowEntity puller = arrow.getOwner() != null ? arrow.getOwner() : arrow;
            GlassArrowEntity.pull((Entity)puller, target, 2.0);
            return;
        }
        if (arrow.isFirstHit()) {
            GlassArrowEntity.pull((Entity)arrow, target, Math.max(1.0f - arrow.distanceTo((Entity)target) / 24.0f, 0.0f));
        }
    })));
    private static final Attributes MOO = new Attributes(1.0f, 3.0f, 0.0f, false, false, PastelDamageTypes.IRRADIANCE, 0xFFFFFF, 7765740);
    public static final GlassArrowVariant MALACHITE = GlassArrowVariant.register("malachite", MAL);
    public static final GlassArrowVariant TOPAZ = GlassArrowVariant.register("topaz", TOP);
    public static final GlassArrowVariant AMETHYST = GlassArrowVariant.register("amethyst", AME);
    public static final GlassArrowVariant CITRINE = GlassArrowVariant.register("citrine", CIT);
    public static final GlassArrowVariant ONYX = GlassArrowVariant.register("onyx", ONY);
    public static final GlassArrowVariant MOONSTONE = GlassArrowVariant.register("moonstone", MOO);
    protected ArrowItem arrow;
    protected ParticleOptions particleEffect;
    protected final ResourceLocation texture;
    protected final Attributes attributes;

    public GlassArrowVariant(ResourceLocation texture, Attributes attributes) {
        this.texture = texture;
        this.attributes = attributes;
    }

    private static GlassArrowVariant register(String id, Attributes attributes) {
        return (GlassArrowVariant)Registry.register(PastelRegistries.GLASS_ARROW_VARIANT, (String)id, (Object)new GlassArrowVariant(PastelCommon.locate("textures/entity/projectile/arrow/" + id + "_glass_arrow.png"), attributes));
    }

    public static void init() {
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public ColorGradient getGradient() {
        return this.attributes.gradient;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    void setData(ArrowItem arrowItem, ParticleOptions particleEffect) {
        this.arrow = arrowItem;
        this.particleEffect = particleEffect;
    }

    public ArrowItem getArrow() {
        return this.arrow;
    }

    public ParticleOptions getParticleEffect() {
        return this.particleEffect;
    }

    public record Attributes(float damage, float speed, float kb, boolean piercing, boolean homing, ResourceKey<DamageType> type, ColorGradient gradient, TriConsumer<GlassArrowEntity, HitResult, Level> postHit) {
        public Attributes(float damage, float speed, float kb, boolean piercing, boolean homing, ResourceKey<DamageType> type, int gStart, int gEnd, TriConsumer<GlassArrowEntity, HitResult, Level> postHit) {
            this(damage, speed, kb, piercing, homing, type, new ColorGradient(new Color(gStart), new Color(gEnd)).fadeAlpha(1.0f, 0.1f).fadeAlpha(0.0f, 0.0f, 1.0f, 0.05f), postHit);
        }

        public Attributes(float damage, float speed, float kb, boolean piercing, boolean homing, ResourceKey<DamageType> type, int gStart, int gEnd) {
            this(damage, speed, kb, piercing, homing, type, gStart, gEnd, (TriConsumer<GlassArrowEntity, HitResult, Level>)((TriConsumer)(a, b, c) -> {}));
        }
    }
}

