/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.tools;

import earth.terrarium.pastel.api.energy.InkCost;
import earth.terrarium.pastel.api.energy.InkPowered;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.api.render.SlotBackgroundEffect;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.items.tools.MalachiteBidentItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import org.jetbrains.annotations.Nullable;

public class FerociousBidentItem
extends MalachiteBidentItem
implements SlotBackgroundEffect,
InkPowered {
    public static final InkCost RIPTIDE_COST = new InkCost(InkColors.WHITE, 10L);
    public static final int BUILTIN_RIPTIDE_LEVEL = 1;

    public FerociousBidentItem(Item.Properties settings, double attackSpeed, double damage, float armorPierce, float protPierce) {
        super(settings, attackSpeed, damage, armorPierce, protPierce);
    }

    @Override
    public List<InkColor> getUsedColors() {
        return List.of(RIPTIDE_COST.color());
    }

    @Override
    public int getRiptideLevel(HolderLookup.Provider lookup, ItemStack stack) {
        return Math.max(Ench.getLevel(lookup, (ResourceKey<Enchantment>)Enchantments.RIPTIDE, stack), 1);
    }

    @Override
    public boolean canStartRiptide(Player player, ItemStack stack) {
        return !this.isDisabled(stack) && (super.canStartRiptide(player, stack) || InkPowered.tryDrainEnergy(player, RIPTIDE_COST));
    }

    public void onUseTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        super.onUseTick(world, user, stack, remainingUseTicks);
        if (user.isAutoSpinAttack() && user instanceof Player) {
            Player player = (Player)user;
            int useTime = this.getUseDuration(stack, user) - remainingUseTicks;
            if (useTime % 10 == 0) {
                if (InkPowered.tryDrainEnergy(player, RIPTIDE_COST)) {
                    stack.hurtAndBreak(1, user, LivingEntity.getSlotForHand((InteractionHand)user.getUsedItemHand()));
                } else {
                    user.releaseUsingItem();
                    return;
                }
            }
            this.yeetPlayer(player, (float)this.getRiptideLevel((HolderLookup.Provider)world.registryAccess(), stack) / 128.0f - 0.75f);
            player.startAutoSpinAttack(20, 12.0f, stack);
            for (LivingEntity entityAround : world.getEntities(EntityTypeTest.forClass(LivingEntity.class), player.getBoundingBox().inflate(2.0), LivingEntity::isAlive)) {
                if (entityAround == player) continue;
                entityAround.hurt(world.damageSources().playerAttack(player), 2.0f);
            }
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.pastel.ferocious_glass_crest_bident.tooltip").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.pastel.ferocious_glass_crest_bident.tooltip2").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.pastel.ferocious_glass_crest_bident.tooltip3").withStyle(ChatFormatting.GRAY));
        this.addInkPoweredTooltip(tooltip);
    }

    @Override
    public boolean canBeDisabled() {
        return true;
    }

    @Override
    public SlotBackgroundEffect.SlotEffect backgroundType(@Nullable Player player, ItemStack stack) {
        boolean usable = InkPowered.hasAvailableInk(player, RIPTIDE_COST);
        return usable ? SlotBackgroundEffect.SlotEffect.BORDER_FADE : SlotBackgroundEffect.SlotEffect.NONE;
    }

    @Override
    public int getBackgroundColor(@Nullable Player player, ItemStack stack, float tickDelta) {
        return -427219;
    }

    @Override
    public float getDefenseMultiplier(LivingEntity target, ItemStack stack) {
        return 0.66f;
    }

    @Override
    public float getProtReduction(LivingEntity target, ItemStack stack) {
        return 0.33f;
    }
}

