/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.misc;

import earth.terrarium.pastel.helpers.level.BlockReference;
import earth.terrarium.pastel.items.ItemWithTooltip;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.registries.PastelBlocks;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;

public class AshItem
extends ItemWithTooltip {
    public AshItem(Item.Properties settings, String tooltip) {
        super(settings, tooltip);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        RandomSource random = world.getRandom();
        ItemStack stack = context.getItemInHand();
        BlockReference reference = BlockReference.of((LevelAccessor)world, context.getClickedPos());
        if (!reference.isOf((Block)PastelBlocks.BLACKSLAG.get())) {
            return InteractionResult.FAIL;
        }
        world.setBlockAndUpdate(reference.pos, ((Block)PastelBlocks.ASHEN_BLACKSLAG.get()).defaultBlockState());
        if (!world.isClientSide()) {
            world.addDestroyBlockEffect(reference.pos, ((Block)PastelBlocks.ASH.get()).defaultBlockState());
            world.playLocalSound(reference.pos, SoundEvents.DYE_USE, SoundSource.BLOCKS, 0.5f, 0.5f + random.nextFloat() * 0.5f, true);
        }
        for (int i = 0; i < 4 + random.nextInt(4); ++i) {
            world.addParticle((ParticleOptions)PastelParticleTypes.FALLING_ASH, (double)((float)reference.pos.getX() + random.nextFloat()), (double)reference.pos.getY() + 1.1 + (double)(random.nextFloat() * 0.4f), (double)((float)reference.pos.getZ() + random.nextFloat()), 0.0, 0.0, 0.0);
        }
        if (Optional.ofNullable(context.getPlayer()).map(p -> !p.getAbilities().instabuild).orElse(true).booleanValue()) {
            stack.shrink(1);
        }
        return InteractionResult.sidedSuccess((boolean)world.isClientSide());
    }
}

