/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.magic_items;

import com.mojang.datafixers.util.Pair;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import earth.terrarium.pastel.registries.PastelStructureTags;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureCompassItem
extends CompassItem {
    protected final TagKey<Structure> locatedStructures;

    public StructureCompassItem(Item.Properties settings, TagKey<Structure> locatedStructures) {
        super(settings);
        this.locatedStructures = locatedStructures;
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level world, Entity entity, int slot, boolean selected) {
        if (!world.isClientSide && world.getGameTime() % 200L == 0L) {
            this.locateStructure(stack, world, entity);
        }
    }

    protected void locateStructure(@NotNull ItemStack stack, @NotNull Level world, Entity entity) {
        Pair<BlockPos, Holder<Structure>> foundStructure = this.locateStructure((ServerLevel)world, entity.blockPosition());
        if (foundStructure != null) {
            this.saveStructurePos(stack, (ResourceKey<Level>)world.dimension(), (BlockPos)foundStructure.getFirst());
        } else {
            this.removeStructurePos(stack);
        }
    }

    @Nullable
    public Pair<BlockPos, Holder<Structure>> locateStructure(@NotNull ServerLevel world, @NotNull BlockPos pos) {
        Optional<HolderSet.Named<Structure>> registryEntryList = PastelStructureTags.entriesOf((Level)world, this.locatedStructures);
        return registryEntryList.map(registryEntries -> world.getChunkSource().getGenerator().findNearestMapStructure(world, (HolderSet)registryEntries, pos, 100, false)).orElse(null);
    }

    @Nullable
    public static GlobalPos getStructurePos(ItemStack stack) {
        return (GlobalPos)stack.getOrDefault(PastelDataComponentTypes.TARGETED_STRUCTURE, null);
    }

    protected void saveStructurePos(ItemStack stack, @NotNull ResourceKey<Level> worldKey, @NotNull BlockPos pos) {
        stack.set(PastelDataComponentTypes.TARGETED_STRUCTURE, (Object)new GlobalPos(worldKey, pos));
    }

    protected void removeStructurePos(@NotNull ItemStack stack) {
        stack.remove(PastelDataComponentTypes.TARGETED_STRUCTURE);
    }
}

