/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.magic_items;

import earth.terrarium.pastel.api.item.LoomPatternProvider;
import earth.terrarium.pastel.capabilities.ExperienceHandler;
import earth.terrarium.pastel.capabilities.PastelCapabilities;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.registries.PastelBannerPatterns;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import earth.terrarium.pastel.registries.PastelItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPattern;
import org.jetbrains.annotations.NotNull;

public class KnowledgeGemItem
extends Item
implements LoomPatternProvider {
    private static final int DEFAULT_MAX = 10000;

    public KnowledgeGemItem(Item.Properties settings) {
        super(settings);
    }

    public static ItemStack getKnowledgeDropStackWithXP(int experience, boolean noStoreTooltip) {
        ItemStack stack = new ItemStack((ItemLike)PastelItems.KNOWLEDGE_GEM.get());
        stack.set(PastelDataComponentTypes.STORED_EXPERIENCE, (Object)experience);
        if (noStoreTooltip) {
            stack.set(PastelDataComponentTypes.HIDE_USAGE_TOOLTIP, (Object)Unit.INSTANCE);
        }
        return stack;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getTransferRate(HolderLookup.Provider lookup, ItemStack itemStack) {
        int quickChargeLevel = Ench.getLevel(lookup, (ResourceKey<Enchantment>)Enchantments.QUICK_CHARGE, itemStack);
        return (int)(2.0 * Math.pow(2.0, Math.min(10, quickChargeLevel)));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        return ItemUtils.startUsingInstantly((Level)world, (Player)user, (InteractionHand)hand);
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return Integer.MAX_VALUE;
    }

    public void onUseTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        super.onUseTick(world, user, stack, remainingUseTicks);
        if (!(user instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)user;
        ExperienceHandler storage = (ExperienceHandler)stack.getCapability(PastelCapabilities.Misc.XP, (Object)world.registryAccess());
        if (storage == null) {
            return;
        }
        int available = player.totalExperience;
        int rate = this.getTransferRate((HolderLookup.Provider)world.registryAccess(), stack);
        if (player.isShiftKeyDown()) {
            int offer = player.isCreative() ? rate : Math.min(rate, available);
            int inserted = offer - storage.insert(offer, true);
            if (inserted == 0) {
                return;
            }
            this.removePlayerExperience((Player)player, inserted);
            storage.insert(inserted, false);
            if (remainingUseTicks % 4 == 0) {
                world.playSound(null, user.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.3f, 0.8f + world.getRandom().nextFloat() * 0.4f);
            }
        } else {
            int drain = storage.extract(rate, true);
            if (drain == 0) {
                return;
            }
            player.giveExperiencePoints(drain);
            if (player.isCreative()) {
                return;
            }
            storage.extract(drain, false);
            if (remainingUseTicks % 4 == 0) {
                world.playSound(null, user.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.3f, 0.8f + world.getRandom().nextFloat() * 0.4f);
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        HolderLookup.Provider registries = context.registries();
        if (registries == null) {
            return;
        }
        ExperienceHandler storage = (ExperienceHandler)stack.getCapability(PastelCapabilities.Misc.XP, (Object)registries);
        int maxExperience = 10000;
        int storedExperience = 0;
        if (storage != null) {
            maxExperience = storage.getCapacity();
            storedExperience = storage.getStoredAmount();
        }
        if (storedExperience == 0) {
            tooltip.add((Component)Component.literal((String)"0 ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.translatable((String)"item.pastel.knowledge_gem.tooltip.stored_experience", (Object[])new Object[]{maxExperience}).withStyle(ChatFormatting.GRAY)));
        } else {
            tooltip.add((Component)Component.literal((String)(storedExperience + " ")).withStyle(ChatFormatting.GREEN).append((Component)Component.translatable((String)"item.pastel.knowledge_gem.tooltip.stored_experience", (Object[])new Object[]{maxExperience}).withStyle(ChatFormatting.GRAY)));
        }
        if (this.shouldDisplayUsageTooltip(stack)) {
            tooltip.add((Component)Component.translatable((String)"item.pastel.knowledge_gem.tooltip.use", (Object[])new Object[]{this.getTransferRate(registries, stack)}).withStyle(ChatFormatting.GRAY));
            this.addBannerPatternProviderTooltip(tooltip);
        }
    }

    public boolean shouldDisplayUsageTooltip(ItemStack itemStack) {
        return itemStack.has(PastelDataComponentTypes.HIDE_USAGE_TOOLTIP);
    }

    public boolean removePlayerExperience(@NotNull Player playerEntity, int experience) {
        if (playerEntity.isCreative()) {
            return true;
        }
        if (playerEntity.totalExperience < experience) {
            return false;
        }
        playerEntity.giveExperiencePoints(-experience);
        return true;
    }

    @Override
    public ResourceKey<BannerPattern> getPattern() {
        return PastelBannerPatterns.KNOWLEDGE_GEM;
    }

    public boolean isEnchantable(ItemStack stack) {
        return stack.getCount() == 1;
    }

    public int getEnchantmentValue() {
        return 5;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return super.supportsEnchantment(stack, enchantment) || enchantment.is(Enchantments.EFFICIENCY) || enchantment.is(Enchantments.QUICK_CHARGE);
    }

    public static class Wrapper
    implements ExperienceHandler {
        private final ItemStack holder;
        private final HolderLookup.Provider lookup;

        public Wrapper(ItemStack holder, HolderLookup.Provider lookup) {
            if (!(holder.getItem() instanceof KnowledgeGemItem)) {
                throw new IllegalArgumentException("Tried to make a knowledge gem wrapper for a non-knowledge gem stack");
            }
            this.holder = holder;
            this.lookup = lookup;
        }

        private int get() {
            return (Integer)this.holder.getOrDefault(PastelDataComponentTypes.STORED_EXPERIENCE, (Object)0);
        }

        private void set(int amount) {
            this.holder.set(PastelDataComponentTypes.STORED_EXPERIENCE, (Object)amount);
        }

        @Override
        public int getStoredAmount() {
            return this.get();
        }

        @Override
        public int insert(int amount, boolean simulate) {
            int insertedAmount = this.getStoredAmount() + amount;
            int fill = Math.min(insertedAmount, this.getCapacity());
            int overflow = insertedAmount - fill;
            if (!simulate) {
                this.set(fill);
            }
            return overflow;
        }

        @Override
        public boolean extractOrFail(int amount) {
            if (this.extract(amount, true) == amount) {
                this.extract(amount, false);
                return true;
            }
            return false;
        }

        @Override
        public int extract(int amount, boolean simulate) {
            int extractAmount = this.getStoredAmount() - amount;
            int drain = amount + Math.min(extractAmount, 0);
            if (!simulate) {
                this.set(this.getStoredAmount() - drain);
            }
            return drain;
        }

        @Override
        public int getCapacity() {
            int efficiencyLevel = Ench.getLevel(this.lookup, (ResourceKey<Enchantment>)Enchantments.EFFICIENCY, this.holder);
            return 10000 * (int)Math.pow(10.0, Math.min(5, efficiencyLevel));
        }
    }
}

