/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.magic_items;

import earth.terrarium.pastel.api.energy.InkPowered;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.compat.claims.GenericClaimModsCompat;
import earth.terrarium.pastel.helpers.interaction.InventoryHelper;
import earth.terrarium.pastel.helpers.level.BuildingHelper;
import earth.terrarium.pastel.items.magic_items.BuildingStaffItem;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.recipe.pedestal.PedestalTier;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import earth.terrarium.pastel.registries.PastelEnchantments;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Triplet;

public class ExchangeStaffItem
extends BuildingStaffItem {
    public static final int INK_COST_PER_BLOCK = 5;
    public static final int CREATIVE_RANGE = 5;

    public ExchangeStaffItem(Item.Properties settings) {
        super(settings);
    }

    public static int getRange(Player playerEntity) {
        if (playerEntity == null || playerEntity.isCreative()) {
            return 5;
        }
        Optional<PedestalTier> highestUnlockedRecipeTier = PedestalTier.getHighestUnlockedRecipeTier(playerEntity);
        if (highestUnlockedRecipeTier.isPresent()) {
            switch (highestUnlockedRecipeTier.get()) {
                case COMPLEX: {
                    return 5;
                }
                case ADVANCED: {
                    return 4;
                }
            }
            return 3;
        }
        return 2;
    }

    @Override
    public boolean canInteractWith(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        return super.canInteractWith(state, world, pos, player) && state.getDestroySpeed(world, pos) < 20.0f;
    }

    public static boolean exchange(Level world, BlockPos pos, @NotNull Player player, @NotNull Block targetBlock, ItemStack exchangeStaffItemStack, Direction side) {
        return ExchangeStaffItem.exchange(world, pos, player, targetBlock, exchangeStaffItemStack, false, side);
    }

    public static boolean exchange(Level world, BlockPos pos, @NotNull Player player, @NotNull Block targetBlock, ItemStack exchangeStaffItemStack, boolean single, Direction side) {
        Triplet<Block, Item, Integer> replaceData = ExchangeStaffItem.countSuitableReplacementItems(player, targetBlock, single, 5);
        long blocksToReplaceCount = ((Integer)replaceData.getC()).intValue();
        if (blocksToReplaceCount == 0L) {
            return false;
        }
        targetBlock = (Block)replaceData.getA();
        Item consumedItem = (Item)replaceData.getB();
        int range = ExchangeStaffItem.getRange(player);
        List<BlockPos> targetPositions = BuildingHelper.getConnectedBlocks(world, pos, blocksToReplaceCount, range);
        if (targetPositions.isEmpty()) {
            return false;
        }
        int blocksReplaced = 0;
        if (!world.isClientSide) {
            ArrayList stacks = new ArrayList();
            for (BlockPos targetPosition : targetPositions) {
                if (!GenericClaimModsCompat.canModify(world, pos, (Entity)player)) continue;
                if (!player.isCreative()) {
                    BlockState droppedStacks = world.getBlockState(targetPosition);
                    stacks.addAll(Block.getDrops((BlockState)droppedStacks, (ServerLevel)((ServerLevel)world), (BlockPos)targetPosition, (BlockEntity)world.getBlockEntity(targetPosition), (Entity)player, (ItemStack)exchangeStaffItemStack));
                }
                world.setBlockAndUpdate(targetPosition, Blocks.AIR.defaultBlockState());
                BlockState stateToPlace = targetBlock.getStateForPlacement((BlockPlaceContext)new BuildingStaffItem.BuildingStaffPlacementContext(world, player, new BlockHitResult(Vec3.atBottomCenterOf((Vec3i)targetPosition), side, targetPosition, false)));
                if (stateToPlace != null && stateToPlace.canSurvive((LevelReader)world, targetPosition)) {
                    if (blocksReplaced == 0) {
                        world.playSound(null, player.blockPosition(), stateToPlace.getSoundType().getPlaceSound(), SoundSource.PLAYERS, stateToPlace.getSoundType().getVolume(), stateToPlace.getSoundType().getPitch());
                    }
                    if (!world.setBlockAndUpdate(targetPosition, stateToPlace)) {
                        ItemEntity itemEntity = new ItemEntity(world, (double)targetPosition.getX(), (double)targetPosition.getY(), (double)targetPosition.getZ(), new ItemStack((ItemLike)consumedItem));
                        itemEntity.setTarget(player.getUUID());
                        itemEntity.setNoPickUpDelay();
                        world.addFreshEntity((Entity)itemEntity);
                    }
                }
                ++blocksReplaced;
            }
            if (!player.isCreative()) {
                InventoryHelper.removeFromInventoryWithRemainders(player, new ItemStack((ItemLike)consumedItem, targetPositions.size()));
                for (ItemStack stack : stacks) {
                    player.getInventory().placeItemBackInInventory(stack);
                }
                InkPowered.tryDrainEnergy(player, USED_COLOR, (long)targetPositions.size() * 5L);
            }
        }
        return true;
    }

    public void storeBlockAsTarget(@NotNull ItemStack exchangeStaffItemStack, Block block) {
        exchangeStaffItemStack.set(PastelDataComponentTypes.STORED_BLOCK, (Object)BuiltInRegistries.BLOCK.getKey((Object)block));
    }

    public static Optional<Block> getStoredBlock(@NotNull ItemStack exchangeStaffItemStack) {
        Block targetBlock;
        ResourceLocation blockId = (ResourceLocation)exchangeStaffItemStack.get(PastelDataComponentTypes.STORED_BLOCK);
        if (blockId != null && (targetBlock = (Block)BuiltInRegistries.BLOCK.get(blockId)) != Blocks.AIR) {
            return Optional.of(targetBlock);
        }
        return Optional.empty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.pastel.exchanging_staff.tooltip.range", (Object[])new Object[]{ExchangeStaffItem.getRange((Player)Minecraft.getInstance().player)}).withStyle(ChatFormatting.GRAY));
        ExchangeStaffItem.getStoredBlock(stack).ifPresent(block -> tooltip.add((Component)Component.translatable((String)"item.pastel.exchanging_staff.tooltip.target", (Object[])new Object[]{block.getName()}).withStyle(ChatFormatting.GRAY)));
        this.addInkPoweredTooltip(tooltip);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState targetBlockState = world.getBlockState(pos);
        Block targetBlock = targetBlockState.getBlock();
        if (!this.canInteractWith(targetBlockState, (BlockGetter)context.getLevel(), context.getClickedPos(), context.getPlayer())) {
            world.playSound(null, player.blockPosition(), SoundEvents.DISPENSER_FAIL, SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResult.FAIL;
        }
        ItemStack staffStack = context.getItemInHand();
        if (player.isShiftKeyDown()) {
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                this.storeBlockAsTarget(staffStack, targetBlock);
                Direction side = context.getClickedFace();
                Vec3 sourcePos = new Vec3(context.getClickLocation().x() + (double)side.getStepX() * 0.1, context.getClickLocation().y() + (double)side.getStepY() * 0.1, context.getClickLocation().z() + (double)side.getStepZ() * 0.1);
                PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity(serverWorld, sourcePos, (ParticleOptions)PastelParticleTypes.SHIMMERSTONE_SPARKLE_SMALL, 15, Vec3.ZERO, new Vec3(0.25, 0.25, 0.25));
                world.playSound(null, player.blockPosition(), PastelSounds.EXCHANGING_STAFF_SELECT, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        Optional<Block> storedBlock = ExchangeStaffItem.getStoredBlock(staffStack);
        if (storedBlock.isPresent() && storedBlock.get() != targetBlock && storedBlock.get().asItem() != Items.AIR && ExchangeStaffItem.exchange(world, pos, player, storedBlock.get(), staffStack, context.getClickedFace())) {
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        world.playSound(null, player.blockPosition(), SoundEvents.DISPENSER_FAIL, SoundSource.PLAYERS, 1.0f, 1.0f);
        return InteractionResult.FAIL;
    }

    public boolean isEnchantable(ItemStack stack) {
        return stack.getCount() == 1;
    }

    public int getEnchantmentValue() {
        return 3;
    }

    @Override
    public List<InkColor> getUsedColors() {
        return List.of(USED_COLOR);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return super.supportsEnchantment(stack, enchantment) || enchantment.is(Enchantments.FORTUNE) || enchantment.is(Enchantments.SILK_TOUCH) || enchantment.is(PastelEnchantments.RESONANCE);
    }
}

