/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.magic_items;

import earth.terrarium.pastel.api.item.PrioritizedEntityInteraction;
import earth.terrarium.pastel.attachments.data.EverpromiseRibbonData;
import earth.terrarium.pastel.compat.claims.GenericClaimModsCompat;
import earth.terrarium.pastel.helpers.level.EntityHelper;
import earth.terrarium.pastel.registries.PastelEntityTypeTags;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class EverpromiseRibbonItem
extends Item
implements PrioritizedEntityInteraction {
    public EverpromiseRibbonItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player user, LivingEntity entity, InteractionHand hand) {
        Level world = user.level();
        if (!GenericClaimModsCompat.canInteract(world, (Entity)entity, (Entity)user)) {
            return InteractionResult.FAIL;
        }
        if (entity.getType().is(PastelEntityTypeTags.EVERPROMISE_RIBBON_BLACKLISTED)) {
            return InteractionResult.FAIL;
        }
        if (stack.get(DataComponents.CUSTOM_NAME) != null && !(entity instanceof Player)) {
            if (entity.isAlive()) {
                if (world.isClientSide) {
                    Level entityWorld = entity.level();
                    RandomSource random = entityWorld.random;
                    for (int i = 0; i < 7; ++i) {
                        world.addParticle((ParticleOptions)ParticleTypes.HEART, entity.getRandomX(1.0), entity.getRandomY() + 0.5, entity.getRandomZ(1.0), random.nextGaussian() * 0.02, random.nextGaussian() * 0.02, random.nextGaussian() * 0.02);
                    }
                } else {
                    EverpromiseRibbonData.attachRibbon(entity);
                    Component newName = stack.getHoverName();
                    if (newName instanceof MutableComponent) {
                        MutableComponent mutableText = (MutableComponent)newName;
                        newName = Component.literal((String)(mutableText.getString() + " \u2763")).setStyle(mutableText.getStyle());
                    }
                    entity.setCustomName(newName);
                    if (entity instanceof Mob) {
                        Mob mobEntity = (Mob)entity;
                        mobEntity.setPersistenceRequired();
                        EntityHelper.addPlayerTrust((Entity)mobEntity, user);
                    }
                }
                if (!user.isCreative()) {
                    stack.shrink(1);
                }
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.pastel.everpromise_ribbon.tooltip").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.pastel.everpromise_ribbon.tooltip2").withStyle(ChatFormatting.GRAY));
    }
}

