/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.magic_items;

import earth.terrarium.pastel.api.energy.InkCost;
import earth.terrarium.pastel.api.energy.InkPowered;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.networking.s2c_payloads.StartSkyLerpingPayload;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class CelestialPocketWatchItem
extends Item
implements InkPowered {
    public static final int TIME_STEP_TICKS = 3000;
    public static final InkCost COST = new InkCost(InkColors.MAGENTA, 1000L);

    public CelestialPocketWatchItem(Item.Properties settings) {
        super(settings);
    }

    @Override
    public List<InkColor> getUsedColors() {
        return List.of(COST.color());
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        if (!world.isClientSide) {
            if (!CelestialPocketWatchItem.tryAdvanceTime((ServerLevel)world, (ServerPlayer)user)) {
                world.playSound(null, user.blockPosition(), PastelSounds.USE_FAIL, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return InteractionResultHolder.consume((Object)itemStack);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)true);
    }

    public static boolean tryAdvanceTime(ServerLevel world, ServerPlayer user) {
        switch (CelestialPocketWatchItem.canAdvanceTime((Level)world).ordinal()) {
            case 2: {
                user.displayClientMessage((Component)Component.translatable((String)"item.pastel.celestial_pocketwatch.tooltip.use_blocked_gamerule"), true);
                break;
            }
            case 1: {
                user.displayClientMessage((Component)Component.translatable((String)"item.pastel.celestial_pocketwatch.tooltip.use_blocked_fixed_time"), true);
                break;
            }
            case 0: {
                if (InkPowered.tryDrainEnergy((Player)user, COST)) {
                    world.playSound(null, user.blockPosition(), PastelSounds.CELESTIAL_POCKET_WATCH_TICKING, SoundSource.PLAYERS, 1.0f, 1.0f);
                    CelestialPocketWatchItem.advanceTime(world, 3000);
                }
                return true;
            }
        }
        return false;
    }

    private static TimeToggleResult canAdvanceTime(@NotNull Level world) {
        GameRules.BooleanValue doDaylightCycleRule = (GameRules.BooleanValue)world.getGameRules().getRule(GameRules.RULE_DAYLIGHT);
        if (doDaylightCycleRule.get()) {
            if (world.dimensionType().hasFixedTime()) {
                return TimeToggleResult.FAILED_FIXED_TIME;
            }
            return TimeToggleResult.SUCCESS;
        }
        return TimeToggleResult.FAILED_GAME_RULE;
    }

    private static void advanceTime(@NotNull ServerLevel world, int additionalTime) {
        StartSkyLerpingPayload.startSkyLerping(world, additionalTime);
        long timeOfDay = world.getDayTime();
        world.setDayTime(timeOfDay + (long)additionalTime);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        ClientLevel world = Minecraft.getInstance().level;
        if (world != null) {
            switch (CelestialPocketWatchItem.canAdvanceTime((Level)world).ordinal()) {
                case 2: {
                    tooltip.add((Component)Component.translatable((String)"item.pastel.celestial_pocketwatch.tooltip.use_blocked_gamerule").withStyle(ChatFormatting.GRAY));
                    break;
                }
                case 1: {
                    tooltip.add((Component)Component.translatable((String)"item.pastel.celestial_pocketwatch.tooltip.use_blocked_fixed_time").withStyle(ChatFormatting.GRAY));
                    break;
                }
                case 0: {
                    tooltip.add((Component)Component.translatable((String)"item.pastel.celestial_pocketwatch.tooltip.working").withStyle(ChatFormatting.GRAY));
                }
            }
        }
        this.addInkPoweredTooltip(tooltip);
    }

    static enum TimeToggleResult {
        SUCCESS,
        FAILED_FIXED_TIME,
        FAILED_GAME_RULE;

    }
}

