/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.food.beverages;

import earth.terrarium.pastel.api.item.FermentedItem;
import earth.terrarium.pastel.components.BeverageComponent;
import earth.terrarium.pastel.components.InfusedBeverageComponent;
import earth.terrarium.pastel.components.JadeWineComponent;
import earth.terrarium.pastel.items.food.StatusEffectDrinkItem;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;

public class BeverageItem
extends StatusEffectDrinkItem
implements FermentedItem {
    public BeverageItem(Item.Properties settings) {
        super(settings.component(PastelDataComponentTypes.BEVERAGE, (Object)BeverageComponent.DEFAULT));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        PotionContents effects;
        JadeWineComponent jade;
        BeverageComponent beverage;
        super.appendHoverText(stack, context, tooltip, type);
        InfusedBeverageComponent infused = (InfusedBeverageComponent)stack.get(PastelDataComponentTypes.INFUSED_BEVERAGE);
        if (infused != null) {
            infused.addToTooltip(context, tooltip::add, type);
        }
        if ((beverage = (BeverageComponent)stack.get(PastelDataComponentTypes.BEVERAGE)) != null) {
            beverage.addToTooltip(context, tooltip::add, type);
        }
        if ((jade = (JadeWineComponent)stack.get(PastelDataComponentTypes.JADE_WINE)) != null) {
            jade.addToTooltip(context, tooltip::add, type);
        }
        if ((effects = (PotionContents)stack.get(DataComponents.POTION_CONTENTS)) != null) {
            effects.addPotionTooltip(tooltip::add, 1.0f, context.tickRate());
        }
    }
}

