/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.food;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class DrinkItem
extends Item {
    @Nullable
    protected Component tooltip;

    public DrinkItem(Item.Properties settings) {
        super(settings);
    }

    public DrinkItem(Item.Properties settings, String tooltip) {
        super(settings);
        this.tooltip = Component.translatable((String)tooltip).withStyle(ChatFormatting.GRAY);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
        ItemStack itemStack = super.finishUsingItem(stack, world, user);
        if (user instanceof Player) {
            Player player = (Player)user;
            if (!player.getAbilities().instabuild) {
                if (stack.isEmpty()) {
                    return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
                }
                player.getInventory().add(new ItemStack((ItemLike)Items.GLASS_BOTTLE));
            }
        }
        return itemStack;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public SoundEvent getEatingSound() {
        return SoundEvents.GENERIC_DRINK;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        if (this.tooltip != null) {
            tooltip.add(this.tooltip);
        }
    }
}

