/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items;

import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import earth.terrarium.pastel.api.item.CreativeOnlyItem;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.registries.PastelMultiblocks;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Rotation;

public class StructurePlacerItem
extends Item
implements CreativeOnlyItem {
    protected final ResourceLocation multiBlockIdentifier;

    public StructurePlacerItem(Item.Properties settings, ResourceLocation multiBlockIdentifier) {
        super(settings);
        this.multiBlockIdentifier = multiBlockIdentifier;
    }

    public InteractionResult useOn(UseOnContext context) {
        Multiblock multiblock;
        if (context.getPlayer() != null && context.getPlayer().isCreative() && (multiblock = PastelMultiblocks.get(this.multiBlockIdentifier)) != null) {
            Rotation blockRotation = Support.rotationFromDirection(context.getHorizontalDirection());
            multiblock.place(context.getLevel(), context.getClickedPos().above(), blockRotation);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        CreativeOnlyItem.appendTooltip(tooltip);
    }
}

