/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.inventories.widgets;

import earth.terrarium.pastel.api.energy.InkStorageBlockEntity;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.storage.IndividualCappedInkStorage;
import earth.terrarium.pastel.helpers.render.RenderHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class InkMeterWidget
implements Renderable,
GuiEventListener,
NarratableEntry {
    public static final int WIDTH_PER_COLOR = 4;
    public static final int SPACE_BETWEEN_COLORS = 2;
    public final int x;
    public final int y;
    public final int width;
    public final int height;
    protected boolean hovered;
    protected boolean focused;
    protected final Screen screen;
    protected final InkStorageBlockEntity<IndividualCappedInkStorage> inkStorageBlockEntity;

    public InkMeterWidget(int x, int y, int height, Screen screen, InkStorageBlockEntity<IndividualCappedInkStorage> inkStorageBlockEntity) {
        this.x = x;
        this.y = y;
        this.width = inkStorageBlockEntity.getEnergyStorage().getSupportedColors().size() * 6 - 2;
        this.height = height;
        this.screen = screen;
        this.inkStorageBlockEntity = inkStorageBlockEntity;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return this.hovered ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE;
    }

    public void updateNarration(NarrationElementOutput builder) {
    }

    public void drawMouseoverTooltip(GuiGraphics drawContext, int x, int y) {
        Minecraft client = Minecraft.getInstance();
        ArrayList<Component> tooltip = new ArrayList<Component>();
        this.inkStorageBlockEntity.getEnergyStorage().addTooltip(tooltip);
        drawContext.renderTooltip(client.font, tooltip, Optional.empty(), x, y);
    }

    public void draw(GuiGraphics drawContext, List<InkColor> colors) {
        int startHeight = this.y + this.height;
        int currentXOffset = 0;
        IndividualCappedInkStorage inkStorage = this.inkStorageBlockEntity.getEnergyStorage();
        long total = inkStorage.getMaxPerColor();
        for (InkColor color : colors) {
            long amount = inkStorage.getEnergy(color);
            if (amount > 0L) {
                int height = Math.max(1, Math.round((float)amount / ((float)total / (float)this.height)));
                RenderHelper.fillQuad(drawContext.pose(), this.x + currentXOffset, startHeight - height, height, 4, color.getColorVec());
            }
            currentXOffset = currentXOffset + 4 + 2;
        }
    }

    public void render(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.hovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
    }
}

