/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.inventories.slots;

import earth.terrarium.pastel.api.gui.SlotWithOnClickAction;
import earth.terrarium.pastel.blocks.pedestal.PedestalBlockEntity;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.inventories.slots.ReadOnlySlot;
import earth.terrarium.pastel.recipe.pedestal.PedestalRecipe;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;

public class PedestalPreviewSlot
extends ReadOnlySlot
implements SlotWithOnClickAction {
    public PedestalPreviewSlot(PedestalBlockEntity pedestal, int index, int x, int y) {
        super((Container)pedestal, index, x, y);
    }

    public ItemStack getItem() {
        ItemStack out = ItemStack.EMPTY;
        PedestalBlockEntity pedestal = (PedestalBlockEntity)this.container;
        RegistryAccess registries = pedestal.getLevel().registryAccess();
        if (pedestal.recipe.isEmpty()) {
            return out;
        }
        Recipe rec = pedestal.recipe.get().value();
        if (rec instanceof PedestalRecipe) {
            PedestalRecipe pr = (PedestalRecipe)rec;
            out = pr.getResultItem((HolderLookup.Provider)registries);
        } else {
            out = rec.assemble((RecipeInput)pedestal.getInput().getCraftingGridInput(), (HolderLookup.Provider)registries);
        }
        return out;
    }

    @Override
    public boolean onClicked(ItemStack heldStack, ClickAction type, Player player) {
        Container container = this.container;
        if (container instanceof PedestalBlockEntity) {
            PedestalBlockEntity pedestalBlockEntity = (PedestalBlockEntity)container;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)player;
                if (pedestalBlockEntity.recipe != null) {
                    Support.grantAdvancementCriterion(serverPlayerEntity, "fail_to_take_item_out_of_pedestal", "try_take_out_item_from_pedestal");
                }
            }
        }
        return false;
    }
}

