/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.inventories;

import earth.terrarium.pastel.helpers.render.RenderHelper;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.List;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class QuickNavigationGridScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    public static final int TEXT_COLOR = 0xEEEEEE;
    public static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"pastel", (String)"textures/gui/quick_navigation.png");
    protected static final Component CONTROLS_TEXT_1 = Component.translatable((String)"gui.pastel.quick_navigation.controls1");
    protected static final Component CONTROLS_TEXT_2 = Component.translatable((String)"gui.pastel.quick_navigation.controls2");
    private static final List<Tuple<Integer, Integer>> SQUARE_OFFSETS = List.of(new Tuple((Object)-20, (Object)-80), new Tuple((Object)40, (Object)-20), new Tuple((Object)-20, (Object)40), new Tuple((Object)-80, (Object)-20));
    public final Stack<Grid> gridStack = new Stack();

    public QuickNavigationGridScreen(T handler, Inventory playerInventory, Component title) {
        super(handler, playerInventory, title);
        this.imageHeight = 256;
    }

    private void back() {
        this.minecraft.level.playSound(null, this.minecraft.player.blockPosition(), PastelSounds.PAINTBRUSH_SWITCH, SoundSource.NEUTRAL, 0.5f, 1.0f);
        if (this.gridStack.size() == 1) {
            this.minecraft.player.closeContainer();
        } else {
            this.gridStack.pop();
        }
    }

    protected void selectGrid(Grid grid) {
        this.minecraft.level.playSound(null, this.minecraft.player.blockPosition(), PastelSounds.PAINTBRUSH_SWITCH, SoundSource.NEUTRAL, 0.5f, 1.0f);
        this.gridStack.push(grid);
    }

    public Grid current() {
        return this.gridStack.peek();
    }

    protected void renderLabels(GuiGraphics drawContext, int mouseX, int mouseY) {
        this.current().drawBackground((Screen)this, drawContext, this.imageWidth / 2, this.imageHeight / 2);
        this.current().drawForeground((Screen)this, drawContext, this.imageWidth / 2, this.imageHeight / 2);
        drawContext.drawCenteredString(this.font, CONTROLS_TEXT_1, this.imageWidth / 2, 228, 0xEEEEEE);
        drawContext.drawCenteredString(this.font, CONTROLS_TEXT_2, this.imageWidth / 2, 238, 0xEEEEEE);
    }

    protected void renderBg(GuiGraphics drawContext, float delta, int mouseX, int mouseY) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 1) {
            this.current().navigate(GUISelection.BACK, this);
        } else {
            int centerElementSize;
            int startX = this.imageWidth / 2;
            int startY = this.imageHeight / 2;
            mouseX -= (double)this.leftPos;
            mouseY -= (double)this.topPos;
            int n = centerElementSize = this.gridStack.size() == 1 ? 5 : 14;
            if (mouseX >= (double)(startX - centerElementSize) && mouseX <= (double)(startX + centerElementSize) && mouseY >= (double)(startY - centerElementSize) && mouseY <= (double)(startY + centerElementSize)) {
                this.current().navigate(GUISelection.SELECT, this);
                return true;
            }
            int offsetID = 0;
            for (Tuple<Integer, Integer> offset : SQUARE_OFFSETS) {
                if (mouseX >= (double)(startX + (Integer)offset.getA()) && mouseX <= (double)(startX + (Integer)offset.getA() + 32) && mouseY >= (double)(startY + (Integer)offset.getB()) && mouseY <= (double)(startY + (Integer)offset.getB() + 32)) {
                    switch (offsetID) {
                        case 0: {
                            this.current().navigate(GUISelection.UP, this);
                            return true;
                        }
                        case 1: {
                            this.current().navigate(GUISelection.RIGHT, this);
                            return true;
                        }
                        case 2: {
                            this.current().navigate(GUISelection.DOWN, this);
                            return true;
                        }
                        case 3: {
                            this.current().navigate(GUISelection.LEFT, this);
                            return true;
                        }
                    }
                }
                ++offsetID;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        Minecraft client = Minecraft.getInstance();
        Options options = client.options;
        if (options.keyLeft.matches(keyCode, scanCode)) {
            this.current().navigate(GUISelection.LEFT, this);
            return true;
        }
        if (options.keyUp.matches(keyCode, scanCode)) {
            this.current().navigate(GUISelection.UP, this);
            return true;
        }
        if (options.keyRight.matches(keyCode, scanCode)) {
            this.current().navigate(GUISelection.RIGHT, this);
            return true;
        }
        if (options.keyDown.matches(keyCode, scanCode)) {
            this.current().navigate(GUISelection.DOWN, this);
            return true;
        }
        if (options.keyDrop.matches(keyCode, scanCode) || options.keyInventory.matches(keyCode, scanCode)) {
            this.current().navigate(GUISelection.SELECT, this);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public static class Grid {
        private final GridEntry centerEntry;
        private final GridEntry topEntry;
        private final GridEntry rightEntry;
        private final GridEntry bottomEntry;
        private final GridEntry leftEntry;

        public Grid(GridEntry centerEntry, GridEntry topEntry, GridEntry rightEntry, GridEntry bottomEntry, GridEntry leftEntry) {
            this.centerEntry = centerEntry;
            this.topEntry = topEntry;
            this.rightEntry = rightEntry;
            this.bottomEntry = bottomEntry;
            this.leftEntry = leftEntry;
        }

        void navigate(GUISelection direction, QuickNavigationGridScreen<?> screen) {
            switch (direction.ordinal()) {
                case 5: {
                    screen.back();
                    break;
                }
                case 4: {
                    this.centerEntry.whenSelected(screen);
                    break;
                }
                case 0: {
                    this.topEntry.whenSelected(screen);
                    break;
                }
                case 1: {
                    this.rightEntry.whenSelected(screen);
                    break;
                }
                case 2: {
                    this.bottomEntry.whenSelected(screen);
                    break;
                }
                default: {
                    this.leftEntry.whenSelected(screen);
                }
            }
        }

        void drawForeground(Screen screen, GuiGraphics drawContext, int startX, int startY) {
            this.centerEntry.drawSmallForeground(screen, drawContext, startX - 15, startY - 15);
            this.topEntry.drawBigForeground(screen, drawContext, startX + (Integer)SQUARE_OFFSETS.get(0).getA(), startY + (Integer)SQUARE_OFFSETS.get(0).getB());
            this.rightEntry.drawBigForeground(screen, drawContext, startX + (Integer)SQUARE_OFFSETS.get(1).getA(), startY + (Integer)SQUARE_OFFSETS.get(1).getB());
            this.bottomEntry.drawBigForeground(screen, drawContext, startX + (Integer)SQUARE_OFFSETS.get(2).getA(), startY + (Integer)SQUARE_OFFSETS.get(2).getB());
            this.leftEntry.drawBigForeground(screen, drawContext, startX + (Integer)SQUARE_OFFSETS.get(3).getA(), startY + (Integer)SQUARE_OFFSETS.get(3).getB());
        }

        void drawBackground(Screen screen, GuiGraphics drawContext, int startX, int startY) {
            this.centerEntry.drawSmallBackground(screen, drawContext, startX - 15, startY - 15);
            this.topEntry.drawBigBackground(screen, drawContext, startX + (Integer)SQUARE_OFFSETS.get(0).getA(), startY + (Integer)SQUARE_OFFSETS.get(0).getB());
            this.rightEntry.drawBigBackground(screen, drawContext, startX + (Integer)SQUARE_OFFSETS.get(1).getA(), startY + (Integer)SQUARE_OFFSETS.get(1).getB());
            this.bottomEntry.drawBigBackground(screen, drawContext, startX + (Integer)SQUARE_OFFSETS.get(2).getA(), startY + (Integer)SQUARE_OFFSETS.get(2).getB());
            this.leftEntry.drawBigBackground(screen, drawContext, startX + (Integer)SQUARE_OFFSETS.get(3).getA(), startY + (Integer)SQUARE_OFFSETS.get(3).getB());
        }
    }

    public static enum GUISelection {
        UP,
        RIGHT,
        DOWN,
        LEFT,
        SELECT,
        BACK;

    }

    private static class ItemGridEntry
    extends GridEntry {
        protected final ItemStack stack;

        private ItemGridEntry(Item item, Component text, GridEntry.GridEntryCallback callback) {
            super(text, callback);
            this.stack = item.getDefaultInstance();
        }

        @Override
        void drawBigForeground(Screen screen, GuiGraphics drawContext, int startX, int startY) {
            super.drawBigForeground(screen, drawContext, startX, startY);
            drawContext.renderItem(this.stack, startX + 10, startY + 10);
        }

        @Override
        void drawSmallForeground(Screen screen, GuiGraphics drawContext, int startX, int startY) {
            super.drawSmallForeground(screen, drawContext, startX, startY);
            drawContext.renderItem(this.stack, startX + 5, startY + 5);
        }
    }

    public static class TextGridEntry
    extends GridEntry {
        protected final Component innerText;
        protected final int innerHalfTextWidth;

        private TextGridEntry(Component innerText, @Nullable Component text, GridEntry.GridEntryCallback callback) {
            super(text, callback);
            Minecraft client = Minecraft.getInstance();
            this.innerText = innerText;
            this.innerHalfTextWidth = client.font.width((FormattedText)this.innerText) / 2;
        }

        @Override
        void drawBigForeground(Screen screen, GuiGraphics drawContext, int startX, int startY) {
            Minecraft client = Minecraft.getInstance();
            drawContext.drawCenteredString(client.font, this.innerText, startX + 19, startY + 15, 0xEEEEEE);
        }

        @Override
        void drawSmallForeground(Screen screen, GuiGraphics drawContext, int startX, int startY) {
            Minecraft client = Minecraft.getInstance();
            drawContext.drawCenteredString(client.font, this.innerText, startX + 14, startY + 10, 0xEEEEEE);
        }
    }

    public static class TexturedGridEntry
    extends GridEntry {
        protected final int textureStartX;
        protected final int textureStartY;

        private TexturedGridEntry(int textureStartX, int textureStartY, @Nullable Component text, GridEntry.GridEntryCallback callback) {
            super(text, callback);
            this.textureStartX = textureStartX;
            this.textureStartY = textureStartY;
        }

        @Override
        void drawBigBackground(Screen screen, GuiGraphics drawContext, int startX, int startY) {
            super.drawBigBackground(screen, drawContext, startX, startY);
            drawContext.blit(BACKGROUND, startX + 11, startY + 11, this.textureStartX, this.textureStartY, 20, 20);
        }

        @Override
        void drawSmallBackground(Screen screen, GuiGraphics drawContext, int startX, int startY) {
            super.drawSmallBackground(screen, drawContext, startX, startY);
            drawContext.blit(BACKGROUND, startX, startY, this.textureStartX, this.textureStartY, 20, 20);
        }
    }

    public static class ColoredGridEntry
    extends GridEntry {
        protected final Vector3f color;

        private ColoredGridEntry(Vector3f color, Component text, GridEntry.GridEntryCallback callback) {
            super(text, callback);
            this.color = color;
        }

        @Override
        void drawBigForeground(Screen screen, GuiGraphics drawContext, int startX, int startY) {
            super.drawBigForeground(screen, drawContext, startX, startY);
            RenderHelper.fillQuad(drawContext.pose(), startX + 3, startY + 3, 32, 32, this.color);
        }

        @Override
        void drawSmallForeground(Screen screen, GuiGraphics drawContext, int startX, int startY) {
            super.drawSmallForeground(screen, drawContext, startX, startY);
            RenderHelper.fillQuad(drawContext.pose(), startX + 2, startY + 2, 24, 24, this.color);
        }
    }

    public static class EmptyGridEntry
    extends GridEntry {
        protected EmptyGridEntry(@Nullable GridEntry.GridEntryCallback onClickCallback) {
            super((Component)Component.empty(), onClickCallback);
        }

        @Override
        void drawBigBackground(Screen screen, GuiGraphics drawContext, int startX, int startY) {
        }

        @Override
        void drawSmallBackground(Screen screen, GuiGraphics drawContext, int startX, int startY) {
            drawContext.blit(BACKGROUND, startX + 9, startY + 9, 0, 0, 10, 10);
        }

        @Override
        void drawBigForeground(Screen screen, GuiGraphics drawContext, int startX, int startY) {
        }

        @Override
        void drawSmallForeground(Screen screen, GuiGraphics drawContext, int startX, int startY) {
        }
    }

    public static abstract class GridEntry {
        public static final GridEntry CLOSE = GridEntry.empty(AbstractContainerScreen::onClose);
        public static final GridEntry BACK = GridEntry.empty(QuickNavigationGridScreen::back);
        public static final GridEntry EMPTY = GridEntry.empty(null);
        protected final Component text;
        @Nullable
        protected final GridEntryCallback onClickCallback;

        protected GridEntry(Component text, @Nullable GridEntryCallback onClickCallback) {
            this.text = text;
            this.onClickCallback = onClickCallback;
        }

        public static GridEntry empty(@Nullable GridEntryCallback callback) {
            return new EmptyGridEntry(callback);
        }

        public static GridEntry textured(int textureStartX, int textureStartY, Component text, @Nullable GridEntryCallback callback) {
            return new TexturedGridEntry(textureStartX, textureStartY, text, callback);
        }

        public static GridEntry text(Component innerText, Component text, @Nullable GridEntryCallback callback) {
            return new TextGridEntry(innerText, text, callback);
        }

        public static GridEntry colored(Vector3f color, Component text, @Nullable GridEntryCallback callback) {
            return new ColoredGridEntry(color, text, callback);
        }

        public static GridEntry item(Item item, Component text, @Nullable GridEntryCallback callback) {
            return new ItemGridEntry(item, text, callback);
        }

        public void whenSelected(QuickNavigationGridScreen<?> screen) {
            if (this.onClickCallback != null) {
                this.onClickCallback.whenSelected(screen);
            }
        }

        void drawBigBackground(Screen screen, GuiGraphics drawContext, int startX, int startY) {
            drawContext.blit(BACKGROUND, startX, startY, 10, 0, 38, 38);
        }

        void drawSmallBackground(Screen screen, GuiGraphics drawContext, int startX, int startY) {
            drawContext.blit(BACKGROUND, startX, startY, 48, 0, 28, 28);
        }

        void drawBigForeground(Screen screen, GuiGraphics drawContext, int startX, int startY) {
            Minecraft client = Minecraft.getInstance();
            drawContext.drawCenteredString(client.font, this.text, startX + 19, startY + 40, 0xEEEEEE);
        }

        void drawSmallForeground(Screen screen, GuiGraphics drawContext, int startX, int startY) {
            Minecraft client = Minecraft.getInstance();
            drawContext.drawCenteredString(client.font, this.text, startX + 14, startY + 34, 0xEEEEEE);
        }

        public static interface GridEntryCallback {
            public void whenSelected(QuickNavigationGridScreen<?> var1);
        }
    }
}

