/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.inventories;

import com.cmdpro.databank.DatabankUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.inventories.PotionWorkshopScreenHandler;
import earth.terrarium.pastel.registries.PastelAdvancements;
import java.awt.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class PotionWorkshopScreen
extends AbstractContainerScreen<PotionWorkshopScreenHandler> {
    public static final ResourceLocation BACKGROUND_3_SLOTS = PastelCommon.locate("textures/gui/container/potion_workshop_3_slots.png");
    public static final ResourceLocation BACKGROUND_4_SLOTS = PastelCommon.locate("textures/gui/container/potion_workshop_4_slots.png");
    private static final int[] BUBBLE_PROGRESS = new int[]{0, 4, 8, 11, 13, 17, 20, 24, 26, 30, 33, 36, 41};
    private final ResourceLocation background;

    public PotionWorkshopScreen(PotionWorkshopScreenHandler handler, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)handler, playerInventory, title);
        this.imageHeight = 202;
        this.background = DatabankUtils.hasAdvancement((Player)playerInventory.player, (ResourceLocation)PastelAdvancements.Milestones.UNLOCK_FOURTH_POTION_WORKSHOP_REAGENT_SLOT) ? BACKGROUND_4_SLOTS : BACKGROUND_3_SLOTS;
    }

    protected void renderLabels(GuiGraphics drawContext, int mouseX, int mouseY) {
        int titleX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        int titleY = 6;
        Component title = this.title;
        int playerInventoryX = 8;
        int playerInventoryY = 109;
        drawContext.drawString(this.font, title, titleX, titleY, 0x323232, false);
        drawContext.drawString(this.font, this.playerInventoryTitle, playerInventoryX, playerInventoryY, 0x323232, false);
    }

    protected void renderBg(GuiGraphics drawContext, float delta, int mouseX, int mouseY) {
        int startX = (this.width - this.imageWidth) / 2;
        int startY = (this.height - this.imageHeight) / 2;
        drawContext.blit(this.background, startX, startY, 0, 0, this.imageWidth, this.imageHeight);
        int brewTime = ((PotionWorkshopScreenHandler)this.menu).getBrewTime();
        if (brewTime > 0) {
            int progress = BUBBLE_PROGRESS[brewTime / 2 % 13];
            if (progress > 0) {
                drawContext.blit(this.background, startX + 29, startY + 39 + 43 - progress, 176, 40 - progress, 11, progress);
            }
            int maxBrewTime = ((PotionWorkshopScreenHandler)this.menu).getMaxBrewTime();
            int potionColor = ((PotionWorkshopScreenHandler)this.menu).getPotionColor();
            Color color = new Color(potionColor);
            progress = (int)(100.0f * ((float)brewTime / (float)maxBrewTime));
            RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
            drawContext.blit(this.background, startX + 45, startY + 22, 0, 212, progress, 44);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void render(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.renderBackground(drawContext, mouseX, mouseY, delta);
        super.render(drawContext, mouseX, mouseY, delta);
        this.renderTooltip(drawContext, mouseX, mouseY);
    }
}

