/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.inventories;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.inventories.Pastel3x3ContainerScreenHandler;
import earth.terrarium.pastel.inventories.ScreenBackgroundVariant;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class Pastel3x3ContainerScreen
extends AbstractContainerScreen<Pastel3x3ContainerScreenHandler> {
    private static final ResourceLocation TIER_1_TEXTURE_3x3 = PastelCommon.locate("textures/gui/container/generic_3x3_tier_1.png");
    private static final ResourceLocation TIER_2_TEXTURE_3x3 = PastelCommon.locate("textures/gui/container/generic_3x3_tier_2.png");
    private static final ResourceLocation TIER_3_TEXTURE_3x3 = PastelCommon.locate("textures/gui/container/generic_3x3_tier_3.png");
    private final ResourceLocation backgroundTexture;

    public Pastel3x3ContainerScreen(Pastel3x3ContainerScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        ScreenBackgroundVariant tier = handler.getTier();
        this.backgroundTexture = this.getBackground(tier);
    }

    protected void init() {
        super.init();
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
    }

    public void render(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.renderBackground(drawContext, mouseX, mouseY, delta);
        super.render(drawContext, mouseX, mouseY, delta);
        this.renderTooltip(drawContext, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics drawContext, float delta, int mouseX, int mouseY) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        drawContext.blit(this.backgroundTexture, i, j, 0, 0, this.imageWidth, this.imageHeight);
    }

    @Contract(pure=true)
    private ResourceLocation getBackground(@NotNull ScreenBackgroundVariant tier) {
        switch (tier) {
            case EARLYGAME: {
                return TIER_1_TEXTURE_3x3;
            }
            case MIDGAME: {
                return TIER_2_TEXTURE_3x3;
            }
        }
        return TIER_3_TEXTURE_3x3;
    }
}

