/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.inventories;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.helpers.render.LoreHelper;
import earth.terrarium.pastel.inventories.BedrockAnvilScreenHandler;
import earth.terrarium.pastel.items.PigmentItem;
import earth.terrarium.pastel.networking.c2s_payloads.AddLoreBedrockAnvilPayload;
import earth.terrarium.pastel.networking.c2s_payloads.RenameItemInBedrockAnvilPayload;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.ItemCombinerScreen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class BedrockAnvilScreen
extends ItemCombinerScreen<BedrockAnvilScreenHandler> {
    private static final ResourceLocation TEXTURE = PastelCommon.locate("textures/gui/container/bedrock_anvil.png");
    private final Player player;
    private EditBox nameField;
    private EditBox loreField;

    public BedrockAnvilScreen(BedrockAnvilScreenHandler handler, Inventory inventory, Component title) {
        super((ItemCombinerMenu)handler, inventory, title, TEXTURE);
        this.player = inventory.player;
        this.titleLabelX = 60;
        this.titleLabelY += 2;
        this.inventoryLabelY = 95;
        this.imageHeight = 190;
    }

    protected void subInit() {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        this.nameField = new EditBox(this.font, i + 62, j + 24, 98, 12, (Component)Component.translatable((String)"container.pastel.bedrock_anvil"));
        this.nameField.setTextColor(-1);
        this.nameField.setTextColorUneditable(-1);
        this.nameField.setBordered(false);
        this.nameField.setMaxLength(50);
        this.nameField.setResponder(this::onRenamed);
        this.nameField.setValue("");
        this.addWidget((GuiEventListener)this.nameField);
        this.nameField.setEditable(((BedrockAnvilScreenHandler)this.menu).getSlot(0).hasItem());
        this.loreField = new EditBox(this.font, i + 45, j + 76, 116, 12, (Component)Component.translatable((String)"container.pastel.bedrock_anvil.lore"));
        this.loreField.setTextColor(-1);
        this.loreField.setTextColorUneditable(-1);
        this.loreField.setBordered(false);
        this.loreField.setMaxLength(200);
        this.loreField.setResponder(this::onLoreChanged);
        this.loreField.setValue("");
        this.addWidget((GuiEventListener)this.loreField);
        this.loreField.setEditable(((BedrockAnvilScreenHandler)this.menu).getSlot(0).hasItem());
        this.nameField.setEditable(false);
        this.loreField.setEditable(false);
    }

    protected void setInitialFocus() {
        this.setInitialFocus((GuiEventListener)this.nameField);
    }

    public void resize(Minecraft client, int width, int height) {
        String name = this.nameField.getValue();
        String lore = this.loreField.getValue();
        this.init(client, width, height);
        this.nameField.setValue(name);
        this.loreField.setValue(lore);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        EditBox textFieldWidget;
        if (keyCode == 256 || keyCode == 258) {
            super.keyPressed(keyCode, scanCode, modifiers);
            return true;
        }
        GuiEventListener focused = this.getFocused();
        return focused == null || !focused.keyPressed(keyCode, scanCode, modifiers) || focused instanceof EditBox && (textFieldWidget = (EditBox)focused).canConsumeInput() || super.keyPressed(keyCode, scanCode, modifiers);
    }

    private void onRenamed(String name) {
        Slot slot = ((BedrockAnvilScreenHandler)this.menu).getSlot(0);
        if (slot.hasItem()) {
            String string = name;
            if (!slot.getItem().has(DataComponents.CUSTOM_NAME) && string.equals(slot.getItem().getHoverName().getString())) {
                string = "";
            }
            if (((BedrockAnvilScreenHandler)this.menu).setNewItemName(string)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new RenameItemInBedrockAnvilPayload(name), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    private void onLoreChanged(String lore) {
        Slot slot = ((BedrockAnvilScreenHandler)this.menu).getSlot(0);
        if (slot.hasItem()) {
            String string = lore;
            if (!LoreHelper.hasLore(slot.getItem()) && string.equals(LoreHelper.getStringFromLoreTextArray(LoreHelper.getLoreList(slot.getItem())))) {
                string = "";
            }
            if (((BedrockAnvilScreenHandler)this.menu).setNewItemLore(string)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new AddLoreBedrockAnvilPayload(lore), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    protected void renderLabels(GuiGraphics context, int mouseX, int mouseY) {
        super.renderLabels(context, mouseX, mouseY);
        context.drawString(this.font, (Component)Component.translatable((String)"container.pastel.bedrock_anvil.lore"), this.inventoryLabelX, 76, 0x404040, false);
        int levelCost = ((BedrockAnvilScreenHandler)this.menu).getLevelCost();
        if (levelCost > 0 || ((BedrockAnvilScreenHandler)this.menu).getSlot(2).hasItem()) {
            MutableComponent costText;
            int textColor = 8453920;
            if (!((BedrockAnvilScreenHandler)this.menu).getSlot(2).hasItem()) {
                costText = null;
            } else {
                costText = Component.translatable((String)"container.repair.cost", (Object[])new Object[]{levelCost});
                if (!((BedrockAnvilScreenHandler)this.menu).getSlot(2).mayPickup(this.player)) {
                    textColor = 0xFF6060;
                }
            }
            if (costText != null) {
                int k = this.imageWidth - 8 - this.font.width((FormattedText)costText) - 2;
                context.fill(k - 2, 91, this.imageWidth - 8, 103, 0x4F000000);
                context.drawString(this.font, (Component)costText, k, 93, textColor, true);
            }
        }
    }

    protected void renderBg(GuiGraphics context, float delta, int mouseX, int mouseY) {
        super.renderBg(context, delta, mouseX, mouseY);
        boolean hasStack = ((BedrockAnvilScreenHandler)this.menu).getSlot(0).hasItem();
        context.blit(TEXTURE, this.leftPos + 59, this.topPos + 20, 0, this.imageHeight + (hasStack ? 0 : 16), 110, 16);
        context.blit(TEXTURE, this.leftPos + 42, this.topPos + 72, 0, this.imageHeight + (hasStack ? 32 : 48), 127, 16);
    }

    public void renderFg(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.nameField.render(drawContext, mouseX, mouseY, delta);
        this.loreField.render(drawContext, mouseX, mouseY, delta);
    }

    protected void renderErrorIcon(GuiGraphics context, int x, int y) {
        if ((((BedrockAnvilScreenHandler)this.menu).getSlot(0).hasItem() || ((BedrockAnvilScreenHandler)this.menu).getSlot(1).hasItem()) && !((BedrockAnvilScreenHandler)this.menu).getSlot(((BedrockAnvilScreenHandler)this.menu).getResultSlot()).hasItem()) {
            context.blit(TEXTURE, x + 99, y + 45, this.imageWidth, 0, 28, 21);
        }
    }

    public void slotChanged(AbstractContainerMenu handler, int slotId, ItemStack stack) {
        Item mutableText;
        Component component;
        if (slotId == 0) {
            boolean stackEmpty = stack.isEmpty();
            this.nameField.setValue(stack.isEmpty() ? "" : stack.getHoverName().getString());
            if (!(((BedrockAnvilScreenHandler)this.menu).getSlot(1).getItem().getItem() instanceof PigmentItem)) {
                component = stack.getHoverName();
                if (component instanceof MutableComponent) {
                    mutableText = (MutableComponent)component;
                    if (mutableText.getStyle().getColor() == null) {
                        this.nameField.setTextColor(-1);
                    } else {
                        this.nameField.setTextColor(mutableText.getStyle().getColor().getValue());
                    }
                } else {
                    this.nameField.setTextColor(-1);
                }
            }
            this.nameField.setEditable(!stack.isEmpty());
            this.nameField.setCanLoseFocus(!stackEmpty);
            this.loreField.setValue(stackEmpty ? "" : LoreHelper.getStringFromLoreTextArray(LoreHelper.getLoreList(stack)));
            this.loreField.setEditable(!stackEmpty);
            this.nameField.setCanLoseFocus(!stackEmpty);
            this.setFocused((GuiEventListener)this.nameField);
        }
        if (slotId == 1) {
            mutableText = stack.getItem();
            if (mutableText instanceof PigmentItem) {
                PigmentItem pigmentItem = (PigmentItem)mutableText;
                this.nameField.setTextColor(pigmentItem.getInkColor().getColorInt());
            } else {
                component = ((BedrockAnvilScreenHandler)this.menu).getSlot(0).getItem().getHoverName();
                if (component instanceof MutableComponent) {
                    mutableText = (MutableComponent)component;
                    if (mutableText.getStyle().getColor() == null) {
                        this.nameField.setTextColor(-1);
                    } else {
                        this.nameField.setTextColor(mutableText.getStyle().getColor().getValue());
                    }
                } else {
                    this.nameField.setTextColor(-1);
                }
            }
        }
    }
}

