/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.helpers.level;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.injectors.MobEffectInstanceInjector;
import earth.terrarium.pastel.registries.PastelMobEffectTags;
import earth.terrarium.pastel.registries.PastelMobEffects;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;

public class MobEffectHelper {
    private static final StatusEffectBackground DIVINITY = new StatusEffectBackground("divinity");
    private static final StatusEffectBackground INCURABLE = new StatusEffectBackground("incurable");
    private static final StatusEffectBackground NIGHT_ALCHEMY = new StatusEffectBackground("night_alchemy");

    public static ResourceLocation getTextureLocation(ResourceLocation original, MobEffectInstance effect, RenderType renderType) {
        Holder type = effect.getEffect();
        if (type == PastelMobEffects.DIVINITY) {
            return DIVINITY.get(renderType);
        }
        if (MobEffectHelper.resistsRemoval(effect)) {
            return INCURABLE.get(renderType);
        }
        if (type.is(PastelMobEffectTags.NIGHT_ALCHEMY)) {
            return NIGHT_ALCHEMY.get(renderType);
        }
        return original;
    }

    public static boolean resistsRemoval(MobEffectInstance instance) {
        Holder type = instance.getEffect();
        if (type.is(PastelMobEffectTags.CANNOT_BE_INCURABLE)) {
            return false;
        }
        return instance.getCures().contains(PastelMobEffects.Cures.INCURABLE);
    }

    public static boolean drainImmunity(MobEffectInstance immunity, float multiplier) {
        int cost = Math.round(600.0f * multiplier);
        if (immunity.getDuration() <= cost) {
            return true;
        }
        ((MobEffectInstanceInjector)immunity).setDuration(Math.max(5, immunity.getDuration() - cost));
        return false;
    }

    public static void actionImmunity(LivingEntity entity, boolean ignoreIncurable) {
        ArrayList<Holder> removals = new ArrayList<Holder>();
        MobEffectInstance immunity = entity.getEffect(PastelMobEffects.IMMUNITY);
        assert (immunity != null);
        for (MobEffectInstance proposal : entity.getActiveEffects()) {
            if (proposal.getEffect().is(PastelMobEffectTags.BYPASSES_IMMUNITY) || ignoreIncurable && MobEffectHelper.resistsRemoval(proposal)) continue;
            removals.add(proposal.getEffect());
        }
        removals.forEach(arg_0 -> ((LivingEntity)entity).removeEffect(arg_0));
    }

    public record StatusEffectBackground(ResourceLocation guiLarge, ResourceLocation guiSmall, ResourceLocation hudDefault, ResourceLocation hudAmbient) {
        public StatusEffectBackground(String name) {
            this(PastelCommon.locate("container/inventory/" + name + "_effect_background_gui_large"), PastelCommon.locate("container/inventory/" + name + "_effect_background_gui_small"), PastelCommon.locate("hud/" + name + "_effect_background_hud_default"), PastelCommon.locate("hud/" + name + "_effect_background_hud_ambient"));
        }

        public ResourceLocation get(RenderType type) {
            return switch (type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this.guiLarge;
                case 1 -> this.guiSmall;
                case 2 -> this.hudDefault;
                case 3 -> this.hudAmbient;
            };
        }
    }

    public static enum RenderType {
        GUI_LARGE,
        GUI_SMALL,
        HUD_DEFAULT,
        HUD_AMBIENT;

    }
}

