/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.helpers.level;

import earth.terrarium.pastel.capabilities.item.FriendlyStackHandler;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public interface ContainerWrapper
extends Container {
    public FriendlyStackHandler getHandlerForScreens();

    default public int getContainerSize() {
        return this.getHandlerForScreens().getSlots();
    }

    default public boolean isEmpty() {
        return this.getHandlerForScreens().isEmpty();
    }

    default public ItemStack getItem(int slot) {
        return this.getHandlerForScreens().getStackInSlot(slot);
    }

    default public ItemStack removeItem(int slot, int amount) {
        return this.getHandlerForScreens().extractItem(slot, amount, false);
    }

    default public void setChanged() {
        this.getHandlerForScreens().onContentsChanged(0);
    }

    default public ItemStack removeItemNoUpdate(int slot) {
        return this.getHandlerForScreens().removeStackInSlot(slot);
    }

    default public void setItem(int slot, ItemStack stack) {
        this.getHandlerForScreens().setStackInSlot(slot, stack);
    }

    default public boolean stillValid(Player player) {
        return true;
    }

    default public void clearContent() {
        this.getHandlerForScreens().clear();
    }
}

