/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.helpers;

import com.cmdpro.databank.DatabankUtils;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.progression.PastelCriteria;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FastBufferedInputStream;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Support {
    public static final DecimalFormat DF = new DecimalFormat("0");
    public static final DecimalFormat DF1 = new DecimalFormat("0.0");
    public static final DecimalFormat DF2 = new DecimalFormat("0.00");
    public static final int HH_RANGE = 20;
    public static final int H_RANGE = 16;
    public static final int M_RANGE = 12;
    public static final int L_RANGE = 8;
    private static boolean migrationActioned;

    public static float varFloat(RandomSource random, float variance) {
        return 1.0f - variance + random.nextFloat() * variance;
    }

    public static float varFloatCentered(RandomSource random, float variance) {
        return 1.0f + random.nextFloat() * variance - variance / 2.0f;
    }

    public static HitResult playerBlockInteractionRaycast(Level world, LivingEntity user, Player player) {
        double maxDistance = Support.getBlockReachDistance(player);
        Vec3 eyePos = user.getEyePosition();
        Vec3 rotationVec = user.getViewVector(0.0f);
        Vec3 vec3d3 = eyePos.add(rotationVec.x * maxDistance, rotationVec.y * maxDistance, rotationVec.z * maxDistance);
        return world.clip(new ClipContext(eyePos, vec3d3, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
    }

    public static float getBlockReachDistance(Player player) {
        return (player.isCreative() ? 5.0f : 4.5f) + (float)player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
    }

    public static float refineDamage(float damage) {
        damage = Math.clamp(damage, 0.0f, 1.7014117E38f);
        damage = Math.round(damage);
        return damage;
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> checkType(BlockEntityType<A> givenType, BlockEntityType<E> expectedType, BlockEntityTicker<? super E> ticker) {
        return expectedType == givenType ? ticker : null;
    }

    @NotNull
    public static Optional<TagKey<Block>> getFirstMatchingBlockTag(@NotNull BlockState blockState, @NotNull List<TagKey<Block>> tags) {
        return blockState.getTags().filter(tags::contains).findFirst();
    }

    public static String getWithOneDecimalAfterComma(float number) {
        return DF1.format(number);
    }

    public static String getShortenedNumberString(double number) {
        if (number > 1.0E9) {
            return DF2.format(number / 1.0E9) + "G";
        }
        if (number > 1000000.0) {
            return DF2.format(number / 1000000.0) + "M";
        }
        if (number > 1000.0) {
            return DF2.format(number / 1000.0) + "K";
        }
        return DF.format(number);
    }

    public static String getShortenedNumberString(long number) {
        if (number > 1000000000L) {
            return DF2.format((double)number / 1.0E9) + "G";
        }
        if (number > 1000000L) {
            return DF2.format((double)number / 1000000.0) + "M";
        }
        if (number > 1000L) {
            return DF2.format((double)number / 1000.0) + "K";
        }
        return DF.format(number);
    }

    public static String getSensiblePercentString(long x, long y) {
        if (y == 0L) {
            return "0";
        }
        double result = (double)x / (double)y;
        if (result < 0.01 && x > 0L) {
            return "1";
        }
        if (result > 0.99 && x != y) {
            return "99";
        }
        return DF.format(Math.round(result * 100.0));
    }

    public static int getSensiblePercent(long x, long y, int max) {
        if (y == 0L) {
            return 0;
        }
        int result = (int)Mth.clampedLerp((double)0.0, (double)max, (double)((double)x / (double)y));
        if (result < 1 && x > 0L) {
            return 1;
        }
        if (result == max && x != y) {
            return max - 1;
        }
        return result;
    }

    public static int chanceRound(double d, @NotNull RandomSource random) {
        boolean roundUp;
        boolean bl = roundUp = (double)random.nextFloat() < d % 1.0;
        if (roundUp) {
            return (int)d + 1;
        }
        return (int)d;
    }

    public static void areaCriterion(ServerLevel level, int radius, BlockPos center, Optional<ResourceLocation> prerequisite, Consumer<ServerPlayer> trigger) {
        for (Entity proposal : level.getEntities(null, AABB.ofSize((Vec3)center.getCenter(), (double)((double)radius + 0.5), (double)((double)radius + 0.5), (double)((double)radius + 0.5)))) {
            ServerPlayer player;
            if (!(proposal instanceof ServerPlayer) || prerequisite.map(arg_0 -> Support.lambda$areaCriterion$0(player = (ServerPlayer)proposal, arg_0)).orElse(false).booleanValue()) continue;
            trigger.accept(player);
        }
    }

    public static void areaCriterion(ServerLevel level, int radius, BlockPos center, ResourceLocation prerequisite, Consumer<ServerPlayer> trigger) {
        Support.areaCriterion(level, radius, center, Optional.of(prerequisite), trigger);
    }

    public static void mbCriterion(ServerLevel level, BlockPos center, Multiblock multiblock) {
        Support.areaCriterion(level, 20, center, Optional.empty(), (ServerPlayer p) -> PastelCriteria.COMPLETED_MULTIBLOCK.trigger((ServerPlayer)p, multiblock));
    }

    public static BlockPos directionalOffset(BlockPos origin, Vec3i forwardUpRight, @NotNull Direction horizontalFacing) {
        switch (horizontalFacing) {
            case NORTH: {
                return origin.offset(forwardUpRight.getZ(), forwardUpRight.getY(), -forwardUpRight.getX());
            }
            case EAST: {
                return origin.offset(forwardUpRight.getX(), forwardUpRight.getY(), forwardUpRight.getZ());
            }
            case SOUTH: {
                return origin.offset(-forwardUpRight.getZ(), forwardUpRight.getY(), forwardUpRight.getX());
            }
            case WEST: {
                return origin.offset(-forwardUpRight.getX(), forwardUpRight.getY(), -forwardUpRight.getZ());
            }
        }
        PastelCommon.logWarning("Called directionalOffset with facing" + String.valueOf(horizontalFacing) + " this is not supported.");
        return origin;
    }

    public static void grantAdvancementCriterion(@NotNull ServerPlayer serverPlayerEntity, ResourceLocation advancementIdentifier, String criterion) {
        if (serverPlayerEntity.getServer() == null) {
            return;
        }
        ServerAdvancementManager sal = serverPlayerEntity.getServer().getAdvancements();
        PlayerAdvancements tracker = serverPlayerEntity.getAdvancements();
        AdvancementHolder advancement = sal.get(advancementIdentifier);
        if (advancement == null) {
            PastelCommon.logError("Trying to grant a criterion \"" + criterion + "\" for an advancement that does not exist: " + String.valueOf(advancementIdentifier));
        } else if (!tracker.getOrStartProgress(advancement).isDone()) {
            tracker.award(advancement, criterion);
        }
    }

    public static void grantAdvancementCriterion(@NotNull ServerPlayer serverPlayerEntity, String advancementString, String criterion) {
        Support.grantAdvancementCriterion(serverPlayerEntity, PastelCommon.locate(advancementString), criterion);
    }

    @NotNull
    public static String getReadableDimensionString(@NotNull String dimensionKeyString) {
        switch (dimensionKeyString) {
            case "minecraft:overworld": {
                return "Overworld";
            }
            case "minecraft:nether": {
                return "Nether";
            }
            case "minecraft:end": {
                return "End";
            }
            case "pastel:deeper_down": {
                return "Deeper Down";
            }
        }
        if (dimensionKeyString.contains(":")) {
            return dimensionKeyString.substring(dimensionKeyString.indexOf(":") + 1);
        }
        return dimensionKeyString;
    }

    @Contract(pure=true)
    public static Direction directionFromRotation(@NotNull Rotation blockRotation) {
        switch (blockRotation) {
            case NONE: {
                return Direction.NORTH;
            }
            case CLOCKWISE_90: {
                return Direction.EAST;
            }
            case CLOCKWISE_180: {
                return Direction.SOUTH;
            }
        }
        return Direction.WEST;
    }

    @Contract(pure=true)
    public static Rotation rotationFromDirection(@NotNull Direction direction) {
        switch (direction) {
            case EAST: {
                return Rotation.CLOCKWISE_90;
            }
            case SOUTH: {
                return Rotation.CLOCKWISE_180;
            }
            case WEST: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    public static Optional<BlockPos> getNexReplaceableBlockPosUpDown(Level world, BlockPos blockPos, int maxUpDown) {
        if (world.getBlockState(blockPos).canBeReplaced()) {
            for (int i = 0; i < maxUpDown; ++i) {
                if (world.getBlockState(blockPos.below(i + 1)).canBeReplaced()) continue;
                return Optional.of(blockPos.below(i));
            }
        } else {
            for (int i = 1; i <= maxUpDown; ++i) {
                if (!world.getBlockState(blockPos.above(i)).canBeReplaced()) continue;
                return Optional.of(blockPos.above(i));
            }
        }
        return Optional.empty();
    }

    public static double logBase(double base, double logNumber) {
        return Math.log(logNumber) / Math.log(base);
    }

    public static void migrateStructureNBT(MinecraftServer server) {
    }

    private static void replaceModId(ListTag tag) {
        for (int i = 0; i < tag.size(); ++i) {
            Tag element = tag.get(i);
            if (element instanceof StringTag) {
                tag.setTag(i, (Tag)StringTag.valueOf((String)element.getAsString().replace("spectrum:", "pastel:")));
                continue;
            }
            if (element instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)element;
                Support.replaceModId(compound);
                continue;
            }
            if (!(element instanceof ListTag)) continue;
            ListTag list = (ListTag)element;
            Support.replaceModId(list);
        }
    }

    private static void replaceModId(CompoundTag tag) {
        for (String key : tag.getAllKeys()) {
            Tag element = tag.get(key);
            if (element instanceof StringTag) {
                tag.putString(key, element.getAsString().replace("spectrum:", "pastel:"));
                continue;
            }
            if (element instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)element;
                Support.replaceModId(compound);
                continue;
            }
            if (!(element instanceof ListTag)) continue;
            ListTag list = (ListTag)element;
            Support.replaceModId(list);
        }
    }

    private static /* synthetic */ void lambda$migrateStructureNBT$3(StructureTemplateManager man, MinecraftServer server, FileToIdConverter sex, ResourceLocation l) {
        Optional opt = man.get(l);
        if (opt.isEmpty()) {
            return;
        }
        ResourceManager res = server.getResourceManager();
        ResourceLocation loc = sex.idToFile(l);
        FileOutputStream write = null;
        try {
            FastBufferedInputStream stream = new FastBufferedInputStream(res.open(loc));
            CompoundTag structTag = NbtIo.readCompressed((InputStream)stream, (NbtAccounter)NbtAccounter.unlimitedHeap());
            Support.replaceModId(structTag);
            Path dev = server.getWorldPath(new LevelResource("dev"));
            Path path = dev.resolve(loc.getPath());
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            write = new FileOutputStream(path.toFile());
            NbtIo.writeCompressed((CompoundTag)structTag, (OutputStream)write);
        }
        catch (Exception logged) {
            PastelCommon.LOGGER.error("piss", (Throwable)logged);
        }
        try {
            if (write != null) {
                write.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ boolean lambda$migrateStructureNBT$2(ResourceLocation l) {
        return l.getNamespace().equals("pastel");
    }

    private static /* synthetic */ Boolean lambda$areaCriterion$0(ServerPlayer player, ResourceLocation a) {
        return !DatabankUtils.hasAdvancement((Player)player, (ResourceLocation)a);
    }

    static {
        DF.setRoundingMode(RoundingMode.DOWN);
        DF1.setRoundingMode(RoundingMode.DOWN);
        DF2.setRoundingMode(RoundingMode.DOWN);
        migrationActioned = false;
    }
}

