/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.events;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.PastelSided;
import earth.terrarium.pastel.api.item.PrioritizedBlockInteraction;
import earth.terrarium.pastel.api.item.PrioritizedEntityInteraction;
import earth.terrarium.pastel.attachments.data.InertiaData;
import earth.terrarium.pastel.blocks.idols.FirestarterIdolBlock;
import earth.terrarium.pastel.blocks.pastel_network.Pastel;
import earth.terrarium.pastel.capabilities.AreaMiningHandler;
import earth.terrarium.pastel.capabilities.PastelCapabilities;
import earth.terrarium.pastel.entity.spawners.ShootingStarSpawner;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.helpers.interaction.TimeHelper;
import earth.terrarium.pastel.inventories.AutoCraftingMode;
import earth.terrarium.pastel.items.magic_items.ExchangeStaffItem;
import earth.terrarium.pastel.items.tools.GlassCrestCrossbowItem;
import earth.terrarium.pastel.items.tools.TuningStampItem;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import earth.terrarium.pastel.progression.PastelCriteria;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelEnchantments;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelLevels;
import earth.terrarium.pastel.registries.client.PastelColorProviders;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.fluids.FluidStack;

public class PastelMiscEvents {
    private static final Set<BlockPos> AREA_TARGETS = new HashSet<BlockPos>();

    public static void register() {
        NeoForge.EVENT_BUS.addListener(PastelMiscEvents::onReloadResources);
        NeoForge.EVENT_BUS.addListener(PastelMiscEvents::serverStart);
        NeoForge.EVENT_BUS.addListener(PastelMiscEvents::startServerLevelTick);
        NeoForge.EVENT_BUS.addListener(PastelMiscEvents::endServerTick);
        NeoForge.EVENT_BUS.addListener(PastelMiscEvents::interactEntity);
        NeoForge.EVENT_BUS.addListener(PastelMiscEvents::blockUse);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOW, PastelMiscEvents::handleAoEMining);
        NeoForge.EVENT_BUS.addListener(PastelMiscEvents::updateInertia);
        NeoForge.EVENT_BUS.addListener(PastelMiscEvents::tagReload);
        NeoForge.EVENT_BUS.addListener(PastelMiscEvents::leftClickBlock);
        NeoForge.EVENT_BUS.addListener(PastelMiscEvents::registerTillable);
    }

    public static void onCrossbowShot(LivingEntity shooter, Projectile projectile) {
        ItemStack crossbow = shooter.getItemInHand(shooter.getUsedItemHand());
        Level level = shooter.level();
        int snipingLevel = Ench.getLevel((HolderLookup.Provider)level.registryAccess(), PastelEnchantments.SNIPING, crossbow);
        if (snipingLevel > 0) {
            projectile.setDeltaMovement(projectile.getDeltaMovement().scale((double)(1.25f * (float)snipingLevel)));
        }
        if (crossbow.getItem() != PastelItems.GLASS_CREST_CROSSBOW.get() || !GlassCrestCrossbowItem.isOvercharged(crossbow)) {
            return;
        }
        Vec3 particleVelocity = projectile.getDeltaMovement().scale(0.05);
        if (GlassCrestCrossbowItem.getOvercharge(crossbow) > 0.99f) {
            PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity((ServerLevel)level, projectile.position(), (ParticleOptions)ParticleTypes.SCRAPE, 5, Vec3.ZERO, particleVelocity);
            PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity((ServerLevel)level, projectile.position(), (ParticleOptions)ParticleTypes.WAX_OFF, 5, Vec3.ZERO, particleVelocity);
            PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity((ServerLevel)level, projectile.position(), (ParticleOptions)ParticleTypes.WAX_ON, 5, Vec3.ZERO, particleVelocity);
            PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity((ServerLevel)level, projectile.position(), (ParticleOptions)ParticleTypes.GLOW, 5, Vec3.ZERO, particleVelocity);
            if (shooter instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)shooter;
                Support.grantAdvancementCriterion(serverPlayerEntity, PastelCommon.locate("lategame/shoot_fully_overcharged_crossbow"), "shot_fully_overcharged_crossbow");
            }
            if (projectile instanceof AbstractArrow) {
                AbstractArrow persistentProjectileEntity = (AbstractArrow)projectile;
                persistentProjectileEntity.setBaseDamage(persistentProjectileEntity.getBaseDamage() * 1.5);
            }
        }
        PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity((ServerLevel)level, projectile.position(), (ParticleOptions)ParticleTypes.FIREWORK, 10, Vec3.ZERO, particleVelocity);
        GlassCrestCrossbowItem.unOvercharge(crossbow);
    }

    private static void registerTillable(BlockEvent.BlockToolModificationEvent event) {
        UseOnContext context = event.getContext();
        BlockState originalState = event.getState();
        ItemStack tool = context.getItemInHand();
        ItemAbility action = event.getItemAbility();
        if (action != ItemAbilities.HOE_TILL || !tool.canPerformAction(action)) {
            return;
        }
        if (originalState.is((Block)PastelBlocks.SLUSH.get()) || originalState.is((Block)PastelBlocks.OVERGROWN_SLUSH.get())) {
            event.setFinalState(((Block)PastelBlocks.TILLED_SLUSH.get()).defaultBlockState());
        } else if (originalState.is((Block)PastelBlocks.SHALE_CLAY.get())) {
            event.setFinalState(((Block)PastelBlocks.TILLED_SHALE_CLAY.get()).defaultBlockState());
        }
    }

    private static void onReloadResources(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new ResourceManagerReloadListener(){

            public void onResourceManagerReload(ResourceManager resourceManager) {
                if (!FMLEnvironment.dist.isDedicatedServer()) {
                    PastelSided.clearToastManager();
                }
                AutoCraftingMode.clearCache();
                PastelCommon.CACHED_ITEM_TAG_MAP.clear();
                if (PastelCommon.getSidedServer() != null) {
                    FirestarterIdolBlock.addBlockSmeltingRecipes(PastelCommon.getSidedServer());
                }
            }

            public String getName() {
                return "pastel:cache_clearer";
            }
        });
    }

    private static void serverStart(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        PastelCommon.logInfo("Injecting dynamic recipes into recipe manager...");
        FirestarterIdolBlock.addBlockSmeltingRecipes(server);
    }

    private static void startServerLevelTick(LevelTickEvent.Pre event) {
        Level level = event.getLevel();
        if (level.isClientSide()) {
            return;
        }
        if (!level.tickRateManager().runsNormally()) {
            return;
        }
        if (level.getGameTime() % 100L == 0L && TimeHelper.getTimeOfDay(level).isNight() && PastelCommon.CONFIG.ShootingStarWorlds.contains(level.dimension().location().toString())) {
            ShootingStarSpawner.INSTANCE.tick((ServerLevel)level, true, true);
        }
    }

    private static void endServerTick(ServerTickEvent.Post event) {
        MinecraftServer server = event.getServer();
        if (!server.tickRateManager().runsNormally()) {
            return;
        }
        try {
            Pastel.getServerInstance().tick();
        }
        catch (Exception e) {
            PastelCommon.logError("Error in the Pastel Network transmission loop.");
            e.printStackTrace();
        }
        PlayerList playerManager = server.getPlayerList();
        for (ServerPlayer player : playerManager.getPlayers()) {
            Level level = player.level();
            if (player.isCreative() || player.isSpectator() || level.dimension() != PastelLevels.DIMENSION_KEY || !(player.getY() > (double)level.getMaxBuildHeight())) continue;
            player.hurt(player.damageSources().fellOutOfWorld(), 10.0f);
            if (!player.isDeadOrDying()) continue;
            Support.grantAdvancementCriterion(player, "lategame/get_killed_while_out_of_deeper_down_bounds", "get_rekt");
        }
    }

    private static void interactEntity(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        InteractionHand hand = player.getUsedItemHand();
        Entity entity = event.getTarget();
        ItemStack handStack = player.getItemInHand(hand);
        if (handStack.getItem() instanceof PrioritizedEntityInteraction && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            event.setCancellationResult(handStack.interactLivingEntity(player, livingEntity, hand));
            if (event.getCancellationResult().indicateItemUse()) {
                event.setCanceled(true);
            }
        }
    }

    private static void blockUse(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        InteractionHand hand = player.getUsedItemHand();
        BlockHitResult hitResult = event.getHitVec();
        ItemStack handStack = player.getItemInHand(hand);
        if (handStack.getItem() instanceof PrioritizedBlockInteraction) {
            event.setCancellationResult(handStack.useOn(new UseOnContext(player, hand, hitResult)));
            if (event.getCancellationResult().indicateItemUse()) {
                event.setCanceled(true);
            }
        }
    }

    private static void handleAoEMining(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        BlockPos original = event.getPos();
        if (AREA_TARGETS.contains(original)) {
            return;
        }
        AreaMiningHandler cap = (AreaMiningHandler)player2.getMainHandItem().getCapability(PastelCapabilities.Misc.MINING);
        if (cap == null) {
            return;
        }
        Vec3i aoe = cap.getMiningArea((Player)player2, player2.getMainHandItem(), original);
        int reach = Math.max(Math.max(aoe.getX(), aoe.getY()), aoe.getZ());
        if (aoe.equals((Object)Vec3i.ZERO)) {
            return;
        }
        BlockPos start = switch (player2.getNearestViewDirection().getAxis()) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> original.offset(aoe.getZ(), aoe.getY(), aoe.getX());
            case Direction.Axis.Y -> original.offset(aoe.getX(), aoe.getZ(), aoe.getY());
            case Direction.Axis.Z -> original.offset(aoe.getX(), aoe.getY(), aoe.getZ());
        };
        BlockPos end = switch (player2.getNearestViewDirection().getAxis()) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> original.offset(0, -aoe.getY(), -aoe.getX());
            case Direction.Axis.Y -> original.offset(-aoe.getX(), 0, -aoe.getY());
            case Direction.Axis.Z -> original.offset(-aoe.getX(), -aoe.getY(), 0);
        };
        Predicate<BlockState> minableBlocksPredicate = state -> {
            boolean suitableTool = !state.requiresCorrectToolForDrops() || event.getPlayer().getMainHandItem().isCorrectToolForDrops(state);
            boolean suitableSpeed = event.getPlayer().getMainHandItem().getDestroySpeed(state) > 1.0f;
            return suitableTool && suitableSpeed;
        };
        BlockPos.betweenClosedStream((BlockPos)start, (BlockPos)end).filter(pos -> !pos.equals((Object)original) && player2.canInteractWithBlock(pos, 1.0 + (double)reach) && minableBlocksPredicate.test(event.getPlayer().level().getBlockState(pos))).peek(AREA_TARGETS::add).peek(arg_0 -> ((ServerPlayerGameMode)player2.gameMode).destroyBlock(arg_0)).forEach(AREA_TARGETS::remove);
    }

    private static void updateInertia(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        BlockState state = event.getState();
        ItemStack stack = player2.getItemInHand(player2.getUsedItemHand());
        RegistryAccess lookup = player2.level().registryAccess();
        int inertia = Ench.getLevel((HolderLookup.Provider)lookup, PastelEnchantments.INERTIA, stack);
        if (inertia > 0) {
            ((InertiaData)player2.getData(InertiaData.ATTACHMENT)).record(state, player2.level().getGameTime(), inertia);
        }
        PastelCriteria.BLOCK_BROKEN.trigger(player2, state);
    }

    private static void tagReload(TagsUpdatedEvent event) {
        if (event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED) {
            PastelColorProviders.resetToggleableProviders();
        }
    }

    private static void leftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Direction direction = event.getFace();
        PlayerInteractEvent.LeftClickBlock.Action action = event.getAction();
        if (!level.isClientSide && !player.isSpectator() && action == PlayerInteractEvent.LeftClickBlock.Action.START) {
            ItemStack mainHandStack = player.getMainHandItem();
            Item item = mainHandStack.getItem();
            if (item instanceof ExchangeStaffItem) {
                ExchangeStaffItem exchangeStaffItem = (ExchangeStaffItem)item;
                BlockState targetBlockState = level.getBlockState(pos);
                if (exchangeStaffItem.canInteractWith(targetBlockState, (BlockGetter)level, pos, player)) {
                    Optional<Block> storedBlock = ExchangeStaffItem.getStoredBlock(player.getMainHandItem());
                    if (storedBlock.isPresent() && storedBlock.get() != targetBlockState.getBlock() && storedBlock.get().asItem() != Items.AIR && ExchangeStaffItem.exchange(level, pos, player, storedBlock.get(), player.getMainHandItem(), true, direction)) {
                        event.setCanceled(true);
                        return;
                    }
                    event.setCanceled(true);
                }
                level.playSound(null, player.blockPosition(), SoundEvents.DISPENSER_FAIL, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                item = mainHandStack.getItem();
                if (item instanceof TuningStampItem) {
                    TuningStampItem tuningStampItem = (TuningStampItem)item;
                    if (((CustomData)mainHandStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).contains("pastel:stamping_data")) {
                        tuningStampItem.clearData(Optional.of(player), mainHandStack);
                    }
                    event.setCanceled(true);
                }
            }
        }
    }

    public static int getFluidLuminance(FluidStack fluid) {
        return fluid.getFluidType().getLightLevel(fluid);
    }
}

