/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import earth.terrarium.pastel.entity.PastelEntityTypes;
import earth.terrarium.pastel.entity.entity.PhantomFrameEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemFrameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;

public class PhantomFrameEntityRenderer<T extends PhantomFrameEntity>
extends ItemFrameRenderer<T> {
    public static final ModelResourceLocation NORMAL_FRAME_MODEL_IDENTIFIER = new ModelResourceLocation(ResourceLocation.withDefaultNamespace((String)"item_frame"), "map=false");
    public static final ModelResourceLocation MAP_FRAME_MODEL_IDENTIFIER = new ModelResourceLocation(ResourceLocation.withDefaultNamespace((String)"item_frame"), "map=true");
    public static final ModelResourceLocation GLOW_FRAME_MODEL_IDENTIFIER = new ModelResourceLocation(ResourceLocation.withDefaultNamespace((String)"glow_item_frame"), "map=false");
    public static final ModelResourceLocation MAP_GLOW_FRAME_MODEL_IDENTIFIER = new ModelResourceLocation(ResourceLocation.withDefaultNamespace((String)"glow_item_frame"), "map=true");
    private final Minecraft client = Minecraft.getInstance();
    private final ItemRenderer itemRenderer;

    public PhantomFrameEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.getItemRenderer();
    }

    protected int getBlockLightLevel(T entity, BlockPos blockPos) {
        return entity.getType() == PastelEntityTypes.GLOW_PHANTOM_FRAME.get() ? Math.max(5, super.getBlockLightLevel(entity, blockPos)) : super.getBlockLightLevel(entity, blockPos);
    }

    public void render(T entity, float yaw, float tickDelta, PoseStack poseStack, MultiBufferSource vertexConsumerProvider, int light) {
        if (this.shouldShowName((ItemFrame)entity)) {
            this.renderNameTag((ItemFrame)entity, entity.getDisplayName(), poseStack, vertexConsumerProvider, light, tickDelta);
        }
        poseStack.pushPose();
        Direction direction = entity.getDirection();
        Vec3 vec3d = this.getRenderOffset((ItemFrame)entity, tickDelta);
        poseStack.translate(-vec3d.x(), -vec3d.y(), -vec3d.z());
        double d = 0.46875;
        poseStack.translate((double)direction.getStepX() * d, (double)direction.getStepY() * d, (double)direction.getStepZ() * d);
        poseStack.mulPose(Axis.XP.rotationDegrees(entity.getXRot()));
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - entity.getYRot()));
        boolean isInvisible = ((PhantomFrameEntity)((Object)entity)).isInvisible();
        ItemStack itemStack = entity.getItem();
        if (!isInvisible) {
            BlockRenderDispatcher blockRenderManager = this.client.getBlockRenderer();
            ModelManager bakedModelManager = blockRenderManager.getBlockModelShaper().getModelManager();
            ModelResourceLocation modelIdentifier = this.getModelId(entity, itemStack);
            poseStack.pushPose();
            poseStack.translate(-0.5, -0.5, -0.5);
            blockRenderManager.getModelRenderer().renderModel(poseStack.last(), vertexConsumerProvider.getBuffer(Sheets.solidBlockSheet()), null, bakedModelManager.getModel(modelIdentifier), 1.0f, 1.0f, 1.0f, light, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
        if (!itemStack.isEmpty()) {
            MapId mapIdComponent = entity.getFramedMapId(itemStack);
            if (isInvisible) {
                poseStack.translate(0.0, 0.0, 0.5);
            } else {
                poseStack.translate(0.0, 0.0, 0.4375);
            }
            int renderLight = ((PhantomFrameEntity)((Object)entity)).shouldRenderAtMaxLight() ? 0xF000F0 : light;
            int j = mapIdComponent != null ? entity.getRotation() % 4 * 2 : entity.getRotation();
            poseStack.mulPose(Axis.ZP.rotationDegrees((float)j * 360.0f / 8.0f));
            if (mapIdComponent != null) {
                poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
                poseStack.scale(0.0078125f, 0.0078125f, 0.0078125f);
                poseStack.translate(-64.0f, -64.0f, 0.0f);
                MapItemSavedData mapState = MapItem.getSavedData((MapId)mapIdComponent, (Level)entity.level());
                poseStack.translate(0.0f, 0.0f, -1.0f);
                if (mapState != null) {
                    int k = this.getLightVal((ItemFrame)entity, 15728850, renderLight);
                    Minecraft.getInstance().gameRenderer.getMapRenderer().render(poseStack, vertexConsumerProvider, mapIdComponent, mapState, true, k);
                }
            } else {
                int l = this.getLightVal((ItemFrame)entity, 0xF000F0, renderLight);
                poseStack.scale(0.5f, 0.5f, 0.5f);
                this.itemRenderer.renderStatic(itemStack, ItemDisplayContext.FIXED, l, OverlayTexture.NO_OVERLAY, poseStack, vertexConsumerProvider, entity.level(), entity.getId());
            }
        }
        poseStack.popPose();
    }

    private ModelResourceLocation getModelId(T entity, ItemStack stack) {
        boolean bl;
        boolean bl2 = bl = entity.getType() == PastelEntityTypes.GLOW_PHANTOM_FRAME.get();
        if (stack.is(Items.FILLED_MAP)) {
            return bl ? MAP_GLOW_FRAME_MODEL_IDENTIFIER : MAP_FRAME_MODEL_IDENTIFIER;
        }
        return bl ? GLOW_FRAME_MODEL_IDENTIFIER : NORMAL_FRAME_MODEL_IDENTIFIER;
    }
}

