/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import earth.terrarium.pastel.entity.entity.LightShardBaseEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class LightSpearEntityRenderer
extends EntityRenderer<LightShardBaseEntity> {
    public LightSpearEntityRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(LightShardBaseEntity shard, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        matrices.pushPose();
        int age = shard.tickCount;
        float alpha = Mth.clamp((float)(1.0f - Mth.lerp((float)tickDelta, (float)shard.getVanishingProgress(age - 1), (float)shard.getVanishingProgress(age))), (float)0.0f, (float)1.0f);
        float scaleFactor = Mth.sin((float)(((float)age + tickDelta) / 8.0f)) / 6.0f + shard.getScaleOffset();
        matrices.mulPose(this.entityRenderDispatcher.cameraOrientation());
        matrices.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)tickDelta, (float)shard.yRotO, (float)shard.getYRot()) - 45.0f));
        matrices.mulPose(Axis.ZP.rotationDegrees(0.0f + Mth.lerp((float)tickDelta, (float)shard.xRotO, (float)shard.getXRot())));
        matrices.scale(scaleFactor, scaleFactor, 1.0f);
        matrices.translate(-0.5f, -0.5f, 0.0f);
        VertexConsumer consumer = vertexConsumers.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)this.getTextureLocation(shard)));
        PoseStack.Pose matrix = matrices.last();
        Matrix4f positions = matrix.pose();
        consumer.addVertex(positions, 0.0f, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrix, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(positions, 1.0f, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrix, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(positions, 1.0f, 1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrix, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(positions, 0.0f, 1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrix, 0.0f, 1.0f, 0.0f);
        matrices.popPose();
        super.render((Entity)shard, yaw, tickDelta, matrices, vertexConsumers, light);
    }

    public ResourceLocation getTextureLocation(LightShardBaseEntity entity) {
        return entity.getTextureLocation();
    }
}

