/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import earth.terrarium.pastel.entity.animation.KindlingAnimations;
import earth.terrarium.pastel.entity.entity.KindlingEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class KindlingEntityModel
extends HierarchicalModel<KindlingEntity> {
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart rightwing;
    private final ModelPart rightwingjoint;
    private final ModelPart leftwing;
    private final ModelPart leftwingjoint;
    private final ModelPart rightforeleg;
    private final ModelPart leftforeleg;
    private final ModelPart rightbackleg;
    private final ModelPart leftbackleg;
    private final ModelPart tail;
    private final ModelPart midtail;
    private final ModelPart fartail;

    public KindlingEntityModel(ModelPart root) {
        this.body = root.getChild("body");
        this.head = this.body.getChild("head");
        this.rightwing = this.body.getChild("rightwing");
        this.leftwing = this.body.getChild("leftwing");
        this.rightwingjoint = this.rightwing.getChild("wingjoint");
        this.leftwingjoint = this.leftwing.getChild("wingjoint2");
        this.rightforeleg = this.body.getChild("rightforeleg");
        this.leftforeleg = this.body.getChild("leftforeleg");
        this.rightbackleg = this.body.getChild("rightbackleg");
        this.leftbackleg = this.body.getChild("leftbackleg");
        this.tail = this.body.getChild("tail");
        this.midtail = this.tail.getChild("midtail");
        this.fartail = this.midtail.getChild("fartail");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition torso = modelPartData.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -3.5f, -7.25f, 7.0f, 7.0f, 13.0f, new CubeDeformation(0.0f)).texOffs(0, 21).addBox(-4.5f, -5.0f, -8.75f, 9.0f, 9.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)15.5f, (float)-0.25f));
        PartDefinition head = torso.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 48).addBox(-3.5f, -7.5f, -6.75f, 7.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(30, 76).addBox(-4.0f, -8.0f, -7.25f, 8.0f, 9.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(29, 21).addBox(-1.5f, -2.51f, -8.75f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)-6.5f));
        head.addOrReplaceChild("middlehorn", CubeListBuilder.create().texOffs(54, 0).addBox(0.0f, -10.5f, -4.0f, 0.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-7.0f, (float)-6.75f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition rightHorns = head.addOrReplaceChild("righthorns", CubeListBuilder.create(), PartPose.offset((float)0.5f, (float)6.5f, (float)6.75f));
        rightHorns.addOrReplaceChild("lowerrighthorn_r1", CubeListBuilder.create().texOffs(46, 0).addBox(-3.0f, 2.5f, -0.5f, 7.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.5f, (float)-13.5f, (float)-9.0f, (float)0.0f, (float)-0.4363f, (float)0.0f));
        rightHorns.addOrReplaceChild("upperrighthorn_r1", CubeListBuilder.create().texOffs(64, 48).addBox(-3.5f, -4.5f, -0.25f, 9.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.5f, (float)-12.5f, (float)-9.0f, (float)-0.0203f, (float)-0.4359f, (float)-0.4318f));
        PartDefinition leftHorns = head.addOrReplaceChild("lefthorns", CubeListBuilder.create(), PartPose.offset((float)-0.5f, (float)6.5f, (float)6.75f));
        leftHorns.addOrReplaceChild("lowerrighthorn_r2", CubeListBuilder.create().texOffs(0, 41).addBox(-4.0f, 2.5f, -0.5f, 7.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.5f, (float)-13.5f, (float)-9.0f, (float)0.0f, (float)0.4363f, (float)0.0f));
        leftHorns.addOrReplaceChild("upperrighthorn_r2", CubeListBuilder.create().texOffs(63, 0).addBox(-5.5f, -4.5f, -0.25f, 9.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.5f, (float)-12.5f, (float)-9.0f, (float)-0.0203f, (float)0.4359f, (float)0.4318f));
        PartDefinition rightWing = torso.addOrReplaceChild("rightwing", CubeListBuilder.create().texOffs(93, 22).addBox(0.0f, -6.0f, -1.5f, 0.0f, 6.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-3.5f, (float)-3.75f, (float)0.0f, (float)0.0f, (float)0.3054f));
        rightWing.addOrReplaceChild("wingjoint", CubeListBuilder.create().texOffs(84, -9).addBox(0.0f, -20.0f, -2.5f, 0.0f, 20.0f, 20.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)-1.0f));
        PartDefinition leftWing = torso.addOrReplaceChild("leftwing", CubeListBuilder.create().texOffs(93, 22).mirror().addBox(0.0f, -6.0f, -1.5f, 0.0f, 6.0f, 9.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)-3.5f, (float)-3.75f, (float)0.0f, (float)0.0f, (float)-0.3054f));
        leftWing.addOrReplaceChild("wingjoint2", CubeListBuilder.create().texOffs(84, -9).mirror().addBox(0.0f, -20.0f, -2.5f, 0.0f, 20.0f, 20.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)-6.0f, (float)-1.0f));
        torso.addOrReplaceChild("rightforeleg", CubeListBuilder.create().texOffs(67, 16).addBox(0.0f, -2.5f, -3.5f, 3.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(69, 28).addBox(3.0f, -2.5f, 1.5f, 0.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(25, 71).addBox(0.0f, 3.5f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)1.0f, (float)-5.0f));
        torso.addOrReplaceChild("leftforeleg", CubeListBuilder.create().texOffs(44, 64).addBox(-3.0f, -2.5f, -3.5f, 3.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(71, 8).addBox(-3.0f, 3.5f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-3.0f, -2.5f, 1.5f, 0.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)1.0f, (float)-5.0f));
        torso.addOrReplaceChild("rightbackleg", CubeListBuilder.create().texOffs(23, 58).addBox(-2.0f, -2.0f, -3.25f, 4.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(14, 70).addBox(2.0f, -2.0f, 2.75f, 0.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(72, 69).addBox(-2.0f, 4.0f, -0.25f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.5f, (float)1.5f, (float)4.5f));
        torso.addOrReplaceChild("leftbackleg", CubeListBuilder.create().texOffs(54, 35).addBox(-4.0f, -2.0f, -3.25f, 4.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(71, 56).addBox(-3.0f, 4.0f, -0.25f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(61, 69).addBox(-4.0f, -2.0f, 2.75f, 0.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.5f, (float)1.5f, (float)4.5f));
        PartDefinition tail = torso.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(28, 0).addBox(-2.5f, -2.48f, 0.0f, 5.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)5.75f));
        PartDefinition midTail = tail.addOrReplaceChild("midtail", CubeListBuilder.create().texOffs(57, 57).addBox(-1.5f, -1.97f, 0.0f, 3.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.5f, (float)7.0f));
        midTail.addOrReplaceChild("fartail", CubeListBuilder.create().texOffs(39, 43).addBox(0.0f, -6.5f, 3.0f, 0.0f, 8.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(0, 64).addBox(-1.0f, -1.5f, 0.0f, 2.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.5f, (float)7.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)128, (int)128);
    }

    public ModelPart root() {
        return this.body;
    }

    public void setupAnim(KindlingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.setHeadAngle(netHeadYaw, headPitch);
        this.animate(entity.standingAnimationState, KindlingAnimations.STANDING, ageInTicks);
        this.animate(entity.walkingAnimationState, KindlingAnimations.WALKING, ageInTicks);
        this.animate(entity.standingAngryAnimationState, KindlingAnimations.STANDING_ANGRY, ageInTicks);
        this.animate(entity.walkingAngryAnimationState, KindlingAnimations.WALKING_ANGRY, ageInTicks);
        this.animate(entity.glidingAnimationState, KindlingAnimations.GLIDING, ageInTicks);
    }

    private void setHeadAngle(float yaw, float pitch) {
        this.head.xRot = pitch * ((float)Math.PI / 180);
        this.head.yRot = yaw * ((float)Math.PI / 180);
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color) {
        if (this.young) {
            matrices.scale(0.7f, 0.7f, 0.7f);
            matrices.translate(0.0, 0.55, 0.0);
        }
        this.body.render(matrices, vertices, light, overlay, color);
    }
}

