/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.models;

import earth.terrarium.pastel.entity.entity.EraserEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class EraserEntityModel
extends HierarchicalModel<EraserEntity> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightMiddleLeg;
    private final ModelPart leftMiddleLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightStrikeLeg;
    private final ModelPart leftStrikeLeg;
    private static final float PI = (float)Math.PI;

    public EraserEntityModel(ModelPart root) {
        this.root = root;
        ModelPart body = root.getChild("body");
        this.head = body.getChild("head");
        ModelPart legs = body.getChild("legs");
        this.rightHindLeg = legs.getChild("right_hind_leg");
        this.leftHindLeg = legs.getChild("left_hind_leg");
        this.rightMiddleLeg = legs.getChild("right_front_leg");
        this.leftMiddleLeg = legs.getChild("left_front_leg");
        this.rightFrontLeg = legs.getChild("rightstrikeleg");
        this.leftFrontLeg = legs.getChild("leftstrikeleg");
        this.rightStrikeLeg = legs.getChild("rightstrikeleg");
        this.leftStrikeLeg = legs.getChild("leftstrikeleg");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition body = modelPartData.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)-2.25f, (float)0.0f));
        head.addOrReplaceChild("nettles", CubeListBuilder.create().texOffs(0, 4).addBox(-1.5f, -4.0f, 0.0f, 3.0f, 5.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)-0.9f, (float)-1.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition legs = body.addOrReplaceChild("legs", CubeListBuilder.create().texOffs(0, 20).addBox(-1.5f, -0.25f, -0.5f, 3.0f, 1.0f, 1.0f), PartPose.offset((float)0.0f, (float)-1.5f, (float)0.0f));
        PartDefinition rightstrikeleg = legs.addOrReplaceChild("rightstrikeleg", CubeListBuilder.create().texOffs(19, 10).addBox(-0.5f, 0.25f, -0.5f, 5.0f, 0.0f, 1.0f), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.0f, (float)-0.7935f, (float)0.8029f, (float)-0.941f));
        rightstrikeleg.addOrReplaceChild("rightstrikeforeleg", CubeListBuilder.create().texOffs(2, 13).addBox(0.0f, 0.0f, -0.5f, 0.0f, 5.0f, 1.0f), PartPose.offsetAndRotation((float)4.5f, (float)0.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition rightfrontleg = legs.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(19, 9).addBox(-0.5f, 0.25f, -0.5f, 5.0f, 0.0f, 1.0f), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.0f, (float)-0.1896f, (float)0.1978f, (float)-0.7436f));
        rightfrontleg.addOrReplaceChild("rightfrontforeleg", CubeListBuilder.create().texOffs(0, 13).addBox(0.0f, 0.0f, -0.5f, 0.0f, 5.0f, 1.0f), PartPose.offsetAndRotation((float)4.5f, (float)0.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition rightmidleg = legs.addOrReplaceChild("rightmidleg", CubeListBuilder.create().texOffs(19, 14).addBox(-0.5f, 0.25f, -0.5f, 4.0f, 0.0f, 1.0f), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.5f, (float)-0.2452f, (float)-0.4063f, (float)-0.8016f));
        PartDefinition rightmidforeleg = rightmidleg.addOrReplaceChild("rightmidforeleg", CubeListBuilder.create().texOffs(0, 21).addBox(0.0f, 0.0f, -0.5f, 0.0f, 3.0f, 1.0f), PartPose.offsetAndRotation((float)3.5f, (float)0.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f));
        rightmidforeleg.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(8, 21).addBox(0.0f, 0.0f, -0.5f, 0.0f, 2.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.9635f));
        PartDefinition rightbackleg = legs.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(19, 13).addBox(-0.5f, 0.25f, -0.5f, 4.0f, 0.0f, 1.0f), PartPose.offsetAndRotation((float)1.0f, (float)-0.25f, (float)0.5f, (float)0.7692f, (float)-0.86f, (float)-0.7762f));
        rightbackleg.addOrReplaceChild("rightbackforeleg", CubeListBuilder.create().texOffs(4, 8).addBox(0.0f, 0.0f, -0.5f, 0.0f, 5.0f, 1.0f), PartPose.offsetAndRotation((float)3.5f, (float)0.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition leftstrikeleg = legs.addOrReplaceChild("leftstrikeleg", CubeListBuilder.create().texOffs(18, 16).addBox(-4.5f, 0.25f, -0.5f, 5.0f, 0.0f, 1.0f), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.7935f, (float)-0.8029f, (float)0.941f));
        leftstrikeleg.addOrReplaceChild("leftstrikeforeleg", CubeListBuilder.create().texOffs(2, 8).addBox(0.0f, 0.0f, -0.5f, 0.0f, 5.0f, 1.0f), PartPose.offsetAndRotation((float)-4.5f, (float)0.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition leftfrontleg = legs.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(18, 15).addBox(-4.5f, 0.25f, -0.5f, 5.0f, 0.0f, 1.0f), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.1896f, (float)-0.1978f, (float)0.7436f));
        leftfrontleg.addOrReplaceChild("leftfrontforeleg", CubeListBuilder.create().texOffs(0, 8).addBox(0.0f, 0.0f, -0.5f, 0.0f, 5.0f, 1.0f), PartPose.offsetAndRotation((float)-4.5f, (float)0.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition leftmidleg = legs.addOrReplaceChild("leftmidleg", CubeListBuilder.create().texOffs(19, 12).addBox(-3.5f, 0.25f, -0.5f, 4.0f, 0.0f, 1.0f), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.5f, (float)-0.2452f, (float)0.4063f, (float)0.8016f));
        PartDefinition leftmidforeleg = leftmidleg.addOrReplaceChild("leftmidforeleg", CubeListBuilder.create().texOffs(14, 19).addBox(0.0f, 0.0f, -0.5f, 0.0f, 3.0f, 1.0f), PartPose.offsetAndRotation((float)-3.5f, (float)0.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        leftmidforeleg.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(2, 21).addBox(0.0f, 0.0f, -0.5f, 0.0f, 2.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.9635f));
        PartDefinition leftbackleg = legs.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(19, 11).addBox(-3.5f, 0.25f, -0.5f, 4.0f, 0.0f, 1.0f), PartPose.offsetAndRotation((float)-1.0f, (float)-0.25f, (float)0.5f, (float)0.7692f, (float)0.86f, (float)0.7762f));
        leftbackleg.addOrReplaceChild("leftbackforeleg", CubeListBuilder.create().texOffs(6, 3).addBox(0.0f, 0.0f, -0.5f, 0.0f, 5.0f, 1.0f), PartPose.offsetAndRotation((float)-3.5f, (float)0.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition rightfang = legs.addOrReplaceChild("rightfang", CubeListBuilder.create().texOffs(7, 21).addBox(-0.5f, 0.25f, -0.5f, 3.0f, 0.0f, 1.0f), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.0f, (float)-1.1989f, (float)1.1409f, (float)-0.6197f));
        rightfang.addOrReplaceChild("rightforefang", CubeListBuilder.create().texOffs(6, 21).addBox(0.0f, 0.0f, -0.5f, 0.0f, 2.0f, 1.0f), PartPose.offsetAndRotation((float)2.5f, (float)0.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition leftfang = legs.addOrReplaceChild("leftfang", CubeListBuilder.create().texOffs(6, 20).addBox(-2.5f, 0.25f, -0.5f, 3.0f, 0.0f, 1.0f), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)-1.1989f, (float)-1.1409f, (float)0.6197f));
        leftfang.addOrReplaceChild("leftforefang", CubeListBuilder.create().texOffs(4, 21).addBox(0.0f, 0.0f, -0.5f, 0.0f, 2.0f, 1.0f), PartPose.offsetAndRotation((float)-2.5f, (float)0.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition torax = body.addOrReplaceChild("torax", CubeListBuilder.create().texOffs(16, 17).addBox(-1.5f, -1.0f, 0.0f, 3.0f, 2.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-2.25f, (float)0.25f, (float)0.4363f, (float)0.0f, (float)0.0f));
        torax.addOrReplaceChild("backnettles_r1", CubeListBuilder.create().texOffs(0, 9).addBox(-3.5f, 1.3505f, 1.125f, 7.0f, 0.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)-0.25f, (float)0.0f, (float)0.48f, (float)0.0f, (float)0.0f));
        torax.addOrReplaceChild("midnettles_r1", CubeListBuilder.create().texOffs(-5, 27).addBox(-3.5f, 0.8505f, 0.125f, 7.0f, 0.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)-0.25f, (float)0.0f, (float)0.6981f, (float)0.0f, (float)0.0f));
        torax.addOrReplaceChild("forenettles_r1", CubeListBuilder.create().texOffs(0, 15).addBox(-3.5f, -0.1495f, -0.625f, 7.0f, 0.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)-0.25f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition stingers = torax.addOrReplaceChild("stingers", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)3.0f));
        stingers.addOrReplaceChild("stingerplane_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, 0.0f, -1.0f, 7.0f, 0.0f, 9.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)32, (int)32);
    }

    public void setupAnim(EraserEntity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.head.yRot = headYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        float i = -(Mth.cos((float)(limbAngle * 0.6662f * 2.0f + 0.0f)) * 0.4f) * limbDistance;
        float j = -(Mth.cos((float)(limbAngle * 0.6662f * 2.0f + (float)Math.PI)) * 0.4f) * limbDistance;
        float k = -(Mth.cos((float)(limbAngle * 0.6662f * 2.0f + 1.5707964f)) * 0.4f) * limbDistance;
        float l = -(Mth.cos((float)(limbAngle * 0.6662f * 2.0f + 4.712389f)) * 0.4f) * limbDistance;
        float m = Math.abs(Mth.sin((float)(limbAngle * 0.6662f + 0.0f)) * 0.4f) * limbDistance;
        float n = Math.abs(Mth.sin((float)(limbAngle * 0.6662f + (float)Math.PI)) * 0.4f) * limbDistance;
        float o = Math.abs(Mth.sin((float)(limbAngle * 0.6662f + 1.5707964f)) * 0.4f) * limbDistance;
        float p = Math.abs(Mth.sin((float)(limbAngle * 0.6662f + 4.712389f)) * 0.4f) * limbDistance;
        this.rightHindLeg.yRot = this.rightHindLeg.getInitialPose().yRot + i;
        this.leftHindLeg.yRot = this.leftHindLeg.getInitialPose().yRot - i;
        this.rightMiddleLeg.yRot = this.rightMiddleLeg.getInitialPose().yRot + j;
        this.leftMiddleLeg.yRot = this.leftMiddleLeg.getInitialPose().yRot - j;
        this.rightFrontLeg.yRot = this.rightFrontLeg.getInitialPose().yRot + k;
        this.leftFrontLeg.yRot = this.leftFrontLeg.getInitialPose().yRot - k;
        this.rightStrikeLeg.yRot = this.rightStrikeLeg.getInitialPose().yRot + l;
        this.leftStrikeLeg.yRot = this.leftStrikeLeg.getInitialPose().yRot - l;
        this.rightHindLeg.zRot = this.rightHindLeg.getInitialPose().zRot + m;
        this.leftHindLeg.zRot = this.leftHindLeg.getInitialPose().zRot - m;
        this.rightMiddleLeg.zRot = this.rightMiddleLeg.getInitialPose().zRot + n;
        this.leftMiddleLeg.zRot = this.leftMiddleLeg.getInitialPose().zRot - n;
        this.rightFrontLeg.zRot = this.rightFrontLeg.getInitialPose().zRot + o;
        this.leftFrontLeg.zRot = this.leftFrontLeg.getInitialPose().zRot - o;
        this.rightStrikeLeg.zRot = this.rightStrikeLeg.getInitialPose().zRot + p;
        this.leftStrikeLeg.zRot = this.leftStrikeLeg.getInitialPose().zRot - p;
    }

    public ModelPart root() {
        return this.root;
    }
}

