/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.entity;

import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.registries.PastelSounds;
import earth.terrarium.pastel.sound.MagicProjectileSoundInstance;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class MagicProjectileEntity
extends Projectile {
    private static final double RAD_TO_DEG_CONSTANT = 57.29577951308232;

    public MagicProjectileEntity(EntityType<? extends MagicProjectileEntity> type, Level world) {
        super(type, world);
    }

    public MagicProjectileEntity(EntityType<? extends MagicProjectileEntity> type, double x, double y, double z, Level world) {
        this(type, world);
        this.moveTo(x, y, z, this.getYRot(), this.getXRot());
        this.reapplyPosition();
    }

    public abstract void spawnImpactParticles();

    public void tick() {
        super.tick();
        if (this.tickCount == 1 && this.level().isClientSide()) {
            MagicProjectileSoundInstance.startSoundInstance(this);
        }
        boolean noClip = this.isNoClip();
        Vec3 thisVelocity = this.getDeltaMovement();
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double d = thisVelocity.horizontalDistance();
            this.setYRot((float)(Mth.atan2((double)thisVelocity.x, (double)thisVelocity.z) * 57.29577951308232));
            this.setXRot((float)(Mth.atan2((double)thisVelocity.y, (double)d) * 57.29577951308232));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
        this.age();
        Vec3 thisPos = this.position();
        Vec3 vec3d2 = thisPos.add(thisVelocity);
        BlockHitResult hitResult = this.level().clip(new ClipContext(thisPos, vec3d2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (hitResult.getType() != HitResult.Type.MISS) {
            vec3d2 = hitResult.getLocation();
        }
        if (!this.isRemoved()) {
            EntityHitResult entityHitResult = this.getEntityCollision(thisPos, vec3d2);
            if (entityHitResult != null) {
                hitResult = entityHitResult;
            }
            if (hitResult.getType() == HitResult.Type.ENTITY) {
                Entity entity = ((EntityHitResult)hitResult).getEntity();
                Entity entity2 = this.getOwner();
                if (entity instanceof Player && entity2 instanceof Player && !((Player)entity2).canHarmPlayer((Player)entity)) {
                    hitResult = null;
                }
            }
            if (hitResult != null && !noClip) {
                this.onHit((HitResult)hitResult);
                this.hasImpulse = true;
            }
        }
        thisVelocity = this.getDeltaMovement();
        double velocityX = thisVelocity.x;
        double velocityY = thisVelocity.y;
        double velocityZ = thisVelocity.z;
        double h = this.getX() + velocityX;
        double j = this.getY() + velocityY;
        double k = this.getZ() + velocityZ;
        double l = thisVelocity.horizontalDistance();
        if (noClip) {
            this.setYRot((float)(Mth.atan2((double)(-velocityX), (double)(-velocityZ)) * 57.29577951308232));
        } else {
            this.setYRot((float)(Mth.atan2((double)velocityX, (double)velocityZ) * 57.29577951308232));
        }
        this.setXRot((float)(Mth.atan2((double)velocityY, (double)l) * 57.29577951308232));
        this.setXRot(MagicProjectileEntity.lerpRotation((float)this.xRotO, (float)this.getXRot()));
        this.setYRot(MagicProjectileEntity.lerpRotation((float)this.yRotO, (float)this.getYRot()));
        if (this.isInWater()) {
            for (int o = 0; o < 4; ++o) {
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, h - velocityX * 0.25, j - velocityY * 0.25, k - velocityZ * 0.25, velocityX, velocityY, velocityZ);
            }
        }
        this.setPos(h, j, k);
        this.checkInsideBlocks();
    }

    protected void age() {
        ++this.tickCount;
        if (this.tickCount >= 200) {
            this.discard();
        }
    }

    public boolean isNoClip() {
        if (!this.level().isClientSide()) {
            return this.noPhysics;
        }
        return true;
    }

    protected SoundEvent getHitSound() {
        return PastelSounds.INK_PROJECTILE_HIT;
    }

    @Nullable
    protected EntityHitResult getEntityCollision(Vec3 currentPosition, Vec3 nextPosition) {
        return ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)currentPosition, (Vec3)nextPosition, (AABB)this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), x$0 -> this.canHitEntity((Entity)x$0));
    }

    public abstract InkColor getInkColor();
}

