/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.entity;

import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.color.InkColorMixes;
import earth.terrarium.pastel.api.energy.color.InkColorTags;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.api.entity.POIMemorized;
import earth.terrarium.pastel.api.entity.PackEntity;
import earth.terrarium.pastel.entity.PastelEntityTypes;
import earth.terrarium.pastel.entity.PastelTrackedDataHandlerRegistry;
import earth.terrarium.pastel.entity.variants.LizardFrillVariant;
import earth.terrarium.pastel.entity.variants.LizardHornVariant;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelPointOfInterestTypeTags;
import earth.terrarium.pastel.registries.PastelRegistries;
import earth.terrarium.pastel.registries.PastelSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OcelotAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LizardEntity
extends TamableAnimal
implements PackEntity<LizardEntity>,
POIMemorized {
    protected static final EntityDataAccessor<LizardFrillVariant> FRILL_VARIANT = SynchedEntityData.defineId(LizardEntity.class, PastelTrackedDataHandlerRegistry.LIZARD_FRILL_VARIANT);
    protected static final EntityDataAccessor<LizardHornVariant> HORN_VARIANT = SynchedEntityData.defineId(LizardEntity.class, PastelTrackedDataHandlerRegistry.LIZARD_HORN_VARIANT);
    protected static final EntityDataAccessor<InkColor> COLOR = SynchedEntityData.defineId(LizardEntity.class, PastelTrackedDataHandlerRegistry.INK_COLOR);
    @Nullable
    protected LizardEntity leader;
    protected int groupSize = 1;
    protected int ticksLeftToFindPOI;
    @Nullable
    protected BlockPos poiPos;

    public LizardEntity(EntityType<? extends LizardEntity> entityType, Level world) {
        super(entityType, world);
        this.xpReward = 4;
    }

    public static AttributeSupplier.Builder createLizardAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 60.0).add(Attributes.ATTACK_DAMAGE, 16.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.ARMOR, 6.0).add(Attributes.ARMOR_TOUGHNESS, 1.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.FOLLOW_RANGE, 12.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new OcelotAttackGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.2));
        this.goalSelector.addGoal(4, new PackEntity.FollowClanLeaderGoal<LizardEntity>(this));
        this.goalSelector.addGoal(5, (Goal)new FindPOIGoal((ResourceKey<PoiType>)PoiTypes.LODESTONE, 32));
        this.goalSelector.addGoal(6, (Goal)new ClanLeaderWanderAroundGoal((PathfinderMob)this, 0.8, 20, 8, 4));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, target -> !this.isOwnedBy((LivingEntity)target)));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, target -> {
            if (target instanceof LizardEntity) {
                LizardEntity other = (LizardEntity)target;
                return this.isDifferentPack(other);
            }
            return !target.isBaby();
        }));
    }

    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    public boolean isOwnedBy(LivingEntity entity) {
        return entity == this.getOwner() || this.leader != null && entity == this.leader.getOwner();
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.tickCount % 1200 == 0) {
            this.heal(1.0f);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COLOR, (Object)InkColors.MAGENTA);
        builder.define(FRILL_VARIANT, (Object)LizardFrillVariant.SIMPLE);
        builder.define(HORN_VARIANT, (Object)LizardHornVariant.HORNY);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        RandomSource random = world.getRandom();
        this.setFrills(PastelRegistries.getRandomTagEntry(PastelRegistries.LIZARD_FRILL_VARIANT, LizardFrillVariant.SIMPLE.getReference(), random, LizardFrillVariant.SIMPLE));
        this.setHorns(PastelRegistries.getRandomTagEntry(PastelRegistries.LIZARD_HORN_VARIANT, LizardHornVariant.HORNY.getReference(), random, LizardHornVariant.HORNY));
        this.setColor(PastelRegistries.getRandomTagEntry(PastelRegistries.INK_COLOR, InkColorTags.ELEMENTAL_COLORS, random, InkColors.MAGENTA));
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putString("color", this.getColor().getID().toString());
        nbt.putString("frills", PastelRegistries.LIZARD_FRILL_VARIANT.getKey((Object)this.getFrills()).toString());
        nbt.putString("horns", PastelRegistries.LIZARD_HORN_VARIANT.getKey((Object)this.getHorns()).toString());
        this.writePOIPosToNbt(nbt);
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        InkColor color = (InkColor)PastelRegistries.INK_COLOR.get(ResourceLocation.tryParse((String)nbt.getString("color")));
        this.setColor(color == null ? PastelRegistries.getRandomTagEntry(PastelRegistries.INK_COLOR, InkColorTags.ELEMENTAL_COLORS, this.random, InkColors.CYAN) : color);
        LizardFrillVariant frills = (LizardFrillVariant)((Object)PastelRegistries.LIZARD_FRILL_VARIANT.get(ResourceLocation.tryParse((String)nbt.getString("frills"))));
        this.setFrills(frills == null ? PastelRegistries.getRandomTagEntry(PastelRegistries.LIZARD_FRILL_VARIANT, LizardFrillVariant.SIMPLE.getReference(), this.random, LizardFrillVariant.SIMPLE) : frills);
        LizardHornVariant horns = (LizardHornVariant)((Object)PastelRegistries.LIZARD_HORN_VARIANT.get(ResourceLocation.tryParse((String)nbt.getString("horns"))));
        this.setHorns(horns == null ? PastelRegistries.getRandomTagEntry(PastelRegistries.LIZARD_HORN_VARIANT, LizardHornVariant.HORNY.getReference(), this.random, LizardHornVariant.HORNY) : horns);
        this.readPOIPosFromNbt(nbt);
    }

    public void aiStep() {
        Level world = this.level();
        super.aiStep();
        if (!world.isClientSide && this.ticksLeftToFindPOI > 0) {
            --this.ticksLeftToFindPOI;
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        Level world = this.level();
        ItemStack itemStack = player.getItemInHand(hand);
        if (this.isFood(itemStack)) {
            int i = this.getAge();
            if (!world.isClientSide && i == 0 && this.canFallInLove() && this.random.nextInt(5) == 0) {
                this.usePlayerItem(player, hand, itemStack);
                this.tame(player);
                this.setInLove(player);
                return InteractionResult.SUCCESS;
            }
            if (this.isBaby()) {
                this.usePlayerItem(player, hand, itemStack);
                this.ageUp(LizardEntity.getSpeedUpSecondsWhenFeeding((int)(-i)), true);
                return InteractionResult.sidedSuccess((boolean)world.isClientSide);
            }
            if (world.isClientSide) {
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean canFallInLove() {
        return super.canFallInLove() || this.getOwner() != null;
    }

    public InkColor getColor() {
        return (InkColor)this.entityData.get(COLOR);
    }

    public void setColor(InkColor color) {
        this.entityData.set(COLOR, (Object)color);
    }

    public LizardFrillVariant getFrills() {
        return (LizardFrillVariant)((Object)this.entityData.get(FRILL_VARIANT));
    }

    public void setFrills(LizardFrillVariant variant) {
        this.entityData.set(FRILL_VARIANT, (Object)variant);
    }

    public LizardHornVariant getHorns() {
        return (LizardHornVariant)((Object)this.entityData.get(HORN_VARIANT));
    }

    public void setHorns(LizardHornVariant variant) {
        this.entityData.set(HORN_VARIANT, (Object)variant);
    }

    protected SoundEvent getAmbientSound() {
        return PastelSounds.ENTITY_LIZARD_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return PastelSounds.ENTITY_LIZARD_HURT;
    }

    protected SoundEvent getDeathSound() {
        return PastelSounds.ENTITY_LIZARD_DEATH;
    }

    public boolean isFood(ItemStack stack) {
        if (stack.is((Item)PastelItems.LIZARD_MEAT.get())) {
            return false;
        }
        return stack.is(ItemTags.MEAT);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        LizardEntity other = (LizardEntity)entity;
        LizardEntity child = (LizardEntity)((EntityType)PastelEntityTypes.LIZARD.get()).create((Level)world);
        if (child != null) {
            child.setColor(this.getChildColor(this, other));
            child.setFrills(this.getChildFrills(this, other));
            child.setHorns(this.getChildHorns(this, other));
        }
        return child;
    }

    private InkColor getChildColor(LizardEntity firstParent, LizardEntity secondParent) {
        Level world = firstParent.level();
        InkColor color1 = firstParent.getColor();
        InkColor color2 = secondParent.getColor();
        return InkColorMixes.getRandomMixedColor(color1, color2, world.random);
    }

    private LizardFrillVariant getChildFrills(LizardEntity firstParent, LizardEntity secondParent) {
        Level world = this.level();
        return world.random.nextBoolean() ? firstParent.getFrills() : secondParent.getFrills();
    }

    private LizardHornVariant getChildHorns(LizardEntity firstParent, LizardEntity secondParent) {
        Level world = this.level();
        return world.random.nextBoolean() ? firstParent.getHorns() : secondParent.getHorns();
    }

    @Override
    public boolean hasOthersInGroup() {
        return this.groupSize > 1;
    }

    @Override
    @Nullable
    public LizardEntity getLeader() {
        return this.leader;
    }

    @Override
    public boolean isCloseEnoughToLeader() {
        return this.distanceToSqr((Entity)this.leader) <= 121.0;
    }

    @Override
    public void leaveGroup() {
        this.leader.decreaseGroupSize();
        this.leader = null;
    }

    @Override
    public void moveTowardLeader() {
        if (this.hasLeader()) {
            this.getNavigation().moveTo((Entity)this.leader, 1.0);
        }
    }

    @Override
    public int getMaxGroupSize() {
        return super.getMaxSpawnClusterSize();
    }

    @Override
    public void joinGroupOf(LizardEntity groupLeader) {
        this.leader = groupLeader;
        groupLeader.increaseGroupSize();
    }

    @Override
    public int getGroupSize() {
        return this.groupSize;
    }

    protected void increaseGroupSize() {
        ++this.groupSize;
    }

    protected void decreaseGroupSize() {
        --this.groupSize;
    }

    @Override
    public TagKey<PoiType> getPOITag() {
        return PastelPointOfInterestTypeTags.LIZARD_DENS;
    }

    @Override
    @Nullable
    public BlockPos getPOIPos() {
        return this.poiPos;
    }

    @Override
    public void setPOIPos(@Nullable BlockPos blockPos) {
        this.poiPos = blockPos;
    }

    private class FindPOIGoal
    extends Goal {
        FindPOIGoal(ResourceKey<PoiType> poiType, int maxDistance) {
        }

        public boolean canUse() {
            return LizardEntity.this.hasOthersInGroup() && LizardEntity.this.ticksLeftToFindPOI == 0 && !LizardEntity.this.isPOIValid((ServerLevel)LizardEntity.this.level());
        }

        public void start() {
            LizardEntity.this.ticksLeftToFindPOI = 200;
            LizardEntity.this.poiPos = LizardEntity.this.findNearestPOI((ServerLevel)LizardEntity.this.level(), LizardEntity.this.blockPosition(), 40);
        }
    }

    protected class ClanLeaderWanderAroundGoal
    extends RandomStrollGoal {
        int chanceToNavigateToPOI;
        int maxDistanceFromPOI;

        public ClanLeaderWanderAroundGoal(PathfinderMob mob, double speed, int chance, int chanceToNavigateToPOI, int maxDistanceFromPOI) {
            super(mob, speed, chance);
            this.chanceToNavigateToPOI = chanceToNavigateToPOI;
            this.maxDistanceFromPOI = maxDistanceFromPOI;
        }

        public boolean canUse() {
            return !LizardEntity.this.hasLeader() && super.canUse();
        }

        @Nullable
        protected Vec3 getPosition() {
            if (LizardEntity.this.random.nextFloat() < (float)this.chanceToNavigateToPOI && LizardEntity.this.isPOIValid((ServerLevel)LizardEntity.this.level()) && !LizardEntity.this.blockPosition().closerThan((Vec3i)LizardEntity.this.poiPos, (double)this.maxDistanceFromPOI)) {
                return Vec3.atCenterOf((Vec3i)LizardEntity.this.poiPos);
            }
            return DefaultRandomPos.getPos((PathfinderMob)LizardEntity.this, (int)8, (int)7);
        }
    }
}

