/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.entity;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.entity.PastelEntityTypes;
import earth.terrarium.pastel.entity.entity.LightShardBaseEntity;
import java.util.function.Predicate;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LightSpearEntity
extends LightShardBaseEntity {
    public LightSpearEntity(EntityType<? extends Projectile> entityType, Level world) {
        super(entityType, world);
    }

    public LightSpearEntity(Level world, LivingEntity owner, float damage, int lifeSpanTicks) {
        super((EntityType<? extends Projectile>)((EntityType)PastelEntityTypes.LIGHT_SPEAR.get()), world, owner, 48.0f, damage, lifeSpanTicks);
    }

    @Override
    public void tick() {
        super.tick();
        this.targetEntity.ifPresent(entity -> this.lookAt(EntityAnchorArgument.Anchor.EYES, entity.position()));
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return PastelCommon.locate("textures/entity/projectile/light_spear.png");
    }

    public static void summonBarrage(Level world, @Nullable LivingEntity user, @Nullable LivingEntity target, Predicate<LivingEntity> targetPredicate, Vec3 position, IntProvider count) {
        LightSpearEntity.summonBarrageInternal(world, user, () -> new LightSpearEntity(world, user, 12.0f, 200), target, targetPredicate, position, count);
    }
}

