/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.entity;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.entity.PastelEntityTypes;
import earth.terrarium.pastel.entity.entity.LightShardBaseEntity;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LightShardEntity
extends LightShardBaseEntity {
    private static final ResourceLocation[] SPRITES = new ResourceLocation[4];
    private final int spriteId;

    public LightShardEntity(EntityType<? extends Projectile> entityType, Level world) {
        super(entityType, world);
        this.scaleOffset /= 1.5f;
        this.spriteId = world.getRandom().nextInt(4);
    }

    public LightShardEntity(Level world, LivingEntity owner, float damageMod, float lifeSpanTicks) {
        super((EntityType<? extends Projectile>)((EntityType)PastelEntityTypes.LIGHT_SHARD.get()), world, owner, 48.0f, damageMod, lifeSpanTicks);
        this.scaleOffset /= 1.5f;
        this.spriteId = world.getRandom().nextInt(4);
    }

    public static void summonBarrage(Level world, @Nullable LivingEntity user, @Nullable LivingEntity target, Predicate<LivingEntity> targetPredicate, Vec3 position, IntProvider count) {
        LightShardEntity.summonBarrage(world, user, position, target, targetPredicate, count, () -> new LightShardEntity(world, user, 0.5f, 200.0f));
    }

    public static void summonBarrage(Level world, @Nullable LivingEntity user, Vec3 position, @Nullable LivingEntity target, Predicate<LivingEntity> targetPredicate, IntProvider count, Supplier<LightShardBaseEntity> supplier) {
        LightShardEntity.summonBarrageInternal(world, user, supplier, target, targetPredicate, position, count);
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return SPRITES[this.spriteId];
    }

    static {
        LightShardEntity.SPRITES[0] = PastelCommon.locate("textures/entity/projectile/light_shard_0.png");
        LightShardEntity.SPRITES[1] = PastelCommon.locate("textures/entity/projectile/light_shard_1.png");
        LightShardEntity.SPRITES[2] = PastelCommon.locate("textures/entity/projectile/light_shard_2.png");
        LightShardEntity.SPRITES[3] = PastelCommon.locate("textures/entity/projectile/light_shard_3.png");
    }
}

