/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.entity;

import de.dafuqs.additionalentityattributes.AdditionalEntityAttributes;
import earth.terrarium.pastel.compat.claims.GenericClaimModsCompat;
import earth.terrarium.pastel.entity.PastelEntityTypes;
import earth.terrarium.pastel.entity.PastelTrackedDataHandlerRegistry;
import earth.terrarium.pastel.entity.entity.KindlingCoughEntity;
import earth.terrarium.pastel.entity.variants.KindlingVariant;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.mixin.accessors.ProjectileAttackGoalAccessor;
import earth.terrarium.pastel.registries.PastelBlockTags;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import earth.terrarium.pastel.registries.PastelItemTags;
import earth.terrarium.pastel.registries.PastelMobEffects;
import earth.terrarium.pastel.registries.PastelRegistries;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AnimalArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class KindlingEntity
extends AbstractHorse
implements RangedAttackMob,
NeutralMob,
Shearable {
    protected static final EntityDataAccessor<KindlingVariant> VARIANT = SynchedEntityData.defineId(KindlingEntity.class, PastelTrackedDataHandlerRegistry.KINDLING_VARIANT);
    protected static final Ingredient FOOD = Ingredient.of(PastelItemTags.KINDLING_FOOD);
    private static final UniformInt ANGER_TIME_RANGE = TimeUtil.rangeOfSeconds((int)30, (int)59);
    private static final EntityDataAccessor<Integer> ANGER = SynchedEntityData.defineId(KindlingEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> CLIPPED = SynchedEntityData.defineId(KindlingEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> CHILL = SynchedEntityData.defineId(KindlingEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> EEPY_SNEEZE = SynchedEntityData.defineId(KindlingEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> PLAYING = SynchedEntityData.defineId(KindlingEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> INCITED = SynchedEntityData.defineId(KindlingEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    @Nullable
    protected UUID angryAt;
    public AnimationState standingAnimationState = new AnimationState();
    public AnimationState walkingAnimationState = new AnimationState();
    public AnimationState standingAngryAnimationState = new AnimationState();
    public AnimationState walkingAngryAnimationState = new AnimationState();
    public AnimationState glidingAnimationState = new AnimationState();
    boolean thornsFlag = false;

    public KindlingEntity(EntityType<? extends KindlingEntity> entityType, Level world) {
        super(entityType, world);
        this.setPathfindingMalus(PathType.WATER, -0.75f);
        this.xpReward = 8;
    }

    public static AttributeSupplier.Builder createKindlingAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 100.0).add(Attributes.ARMOR, 25.0).add(Attributes.ARMOR_TOUGHNESS, 12.0).add(AdditionalEntityAttributes.MAGIC_PROTECTION, 6.0).add(Attributes.MOVEMENT_SPEED, 0.6).add(Attributes.ATTACK_DAMAGE, 25.0).add(Attributes.ATTACK_KNOCKBACK, 1.5).add(Attributes.JUMP_STRENGTH, 2.4);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        this.setPose(Pose.STANDING);
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new RunAroundLikeCrazyGoal((AbstractHorse)this, 1.4));
        this.goalSelector.addGoal(2, (Goal)new LeapAtTargetGoal((Mob)this, 0.5f));
        this.goalSelector.addGoal(3, (Goal)new CancellableProjectileAttackGoal(this, 1.25, 30, 20.0f));
        this.goalSelector.addGoal(3, (Goal)new MeleeChaseGoal(this));
        this.goalSelector.addGoal(5, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new PlayRoughGoal((PathfinderMob)this));
        this.goalSelector.addGoal(7, (Goal)new TemptGoal((PathfinderMob)this, 1.25, (Predicate)FOOD, false));
        this.goalSelector.addGoal(8, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(9, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(11, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new CoughRevengeGoal(this));
        this.targetSelector.addGoal(2, new FindPlayMateGoal<Monster>((Mob)this, 4, 0.25f, Monster.class));
        this.targetSelector.addGoal(3, new FindPlayMateGoal<KindlingEntity>((Mob)this, 10, 1.0f, KindlingEntity.class));
        this.targetSelector.addGoal(4, new FindPlayMateGoal<Player>((Mob)this, 40, 4.0f, Player.class));
        this.targetSelector.addGoal(5, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)KindlingVariant.DEFAULT);
        builder.define(ANGER, (Object)0);
        builder.define(CHILL, (Object)40);
        builder.define(EEPY_SNEEZE, (Object)0);
        builder.define(CLIPPED, (Object)0);
        builder.define(PLAYING, (Object)false);
        builder.define(INCITED, (Object)false);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        if (DATA_POSE.equals(data)) {
            this.standingAnimationState.stop();
            this.walkingAnimationState.stop();
            this.standingAngryAnimationState.stop();
            this.walkingAngryAnimationState.stop();
            this.glidingAnimationState.stop();
            switch (this.getPose()) {
                case STANDING: {
                    this.standingAnimationState.start(this.tickCount);
                    break;
                }
                case SNIFFING: {
                    this.walkingAnimationState.start(this.tickCount);
                    break;
                }
                case ROARING: {
                    this.standingAngryAnimationState.start(this.tickCount);
                    break;
                }
                case EMERGING: {
                    this.walkingAngryAnimationState.start(this.tickCount);
                    break;
                }
                case FALL_FLYING: {
                    this.glidingAnimationState.start(this.tickCount);
                    break;
                }
            }
        }
        super.onSyncedDataUpdated(data);
    }

    public KindlingVariant getKindlingVariant() {
        return (KindlingVariant)((Object)this.entityData.get(VARIANT));
    }

    public void setKindlingVariant(KindlingVariant variant) {
        this.entityData.set(VARIANT, (Object)variant);
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        this.addPersistentAngerSaveData(nbt);
        Optional.ofNullable(PastelRegistries.KINDLING_VARIANT.getKey((Object)this.getKindlingVariant())).ifPresent(id -> nbt.putString("variant", id.toString()));
        nbt.putInt("chillTime", this.getChillTime());
        nbt.putInt("eepyTime", this.getEepyTime());
        nbt.putBoolean("playing", this.isPlaying());
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.readPersistentAngerSaveData(this.level(), nbt);
        KindlingVariant variant = (KindlingVariant)((Object)PastelRegistries.KINDLING_VARIANT.get(ResourceLocation.tryParse((String)nbt.getString("variant"))));
        this.setKindlingVariant(variant == null ? KindlingVariant.DEFAULT : variant);
        this.setChillTime(nbt.getInt("chillTime"));
        this.setEepyTime(nbt.getInt("eepyTime"));
        this.setPlaying(nbt.getBoolean("playing"));
        this.syncSaddleToClients();
    }

    public boolean isFood(ItemStack stack) {
        return FOOD.test(stack);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        KindlingEntity baby = (KindlingEntity)((EntityType)PastelEntityTypes.KINDLING.get()).create((Level)world);
        if (baby != null) {
            baby.setKindlingVariant(this.random.nextBoolean() ? this.getKindlingVariant() : ((KindlingEntity)entity).getKindlingVariant());
        }
        return baby;
    }

    public void containerChanged(Container sender) {
        ItemStack itemStack = this.getBodyArmorItem();
        super.containerChanged(sender);
        ItemStack itemStack2 = this.getBodyArmorItem();
        if (this.tickCount > 20 && this.isBodyArmorItem(itemStack2) && itemStack != itemStack2) {
            this.playSound(SoundEvents.HORSE_ARMOR, 0.5f, 1.0f);
        }
    }

    public boolean canUseSlot(EquipmentSlot slot) {
        return true;
    }

    public boolean isBodyArmorItem(ItemStack item) {
        AnimalArmorItem animalArmorItem;
        Item item2 = item.getItem();
        return item2 instanceof AnimalArmorItem && (animalArmorItem = (AnimalArmorItem)item2).getBodyType() == AnimalArmorItem.BodyType.EQUESTRIAN;
    }

    protected SoundEvent getAmbientSound() {
        return PastelSounds.ENTITY_KINDLING_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return PastelSounds.ENTITY_KINDLING_HURT;
    }

    protected SoundEvent getDeathSound() {
        return PastelSounds.ENTITY_KINDLING_DEATH;
    }

    protected SoundEvent getAngrySound() {
        return PastelSounds.ENTITY_KINDLING_ANGRY;
    }

    protected void playJumpSound() {
        this.playSound(PastelSounds.ENTITY_KINDLING_JUMP, 0.4f, 1.0f);
    }

    public boolean isJumping() {
        return !this.onGround();
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.getEntity() instanceof KindlingEntity) {
            amount = 1.0f;
            if (this.random.nextBoolean()) {
                this.setChillTime(0);
            }
        }
        if (amount > 1.0f) {
            this.setPlaying(false);
        }
        this.thornsFlag = source.is(DamageTypes.THORNS);
        return super.hurt(source, amount);
    }

    public void setLastHurtByMob(@Nullable LivingEntity attacker) {
        if (!this.thornsFlag) {
            super.setLastHurtByMob(attacker);
        }
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        if (!this.level().isClientSide()) {
            int eepy;
            this.updatePersistentAnger((ServerLevel)this.level(), false);
            this.setClipped(this.getClipTime() - 1);
            this.setChillTime(this.getChillTime() - 1);
            if (this.hasEffect(PastelMobEffects.ETERNAL_SLUMBER)) {
                this.ascend(2);
            }
            if (this.hasEffect(PastelMobEffects.FATAL_SLUMBER)) {
                this.ascend(3);
            }
            if (this.hasEffect(PastelMobEffects.SOMNOLENCE) && this.getEepyTime() == 0) {
                this.setEepyTime(100);
            }
            if ((eepy = this.getEepyTime()) > 1) {
                this.setEepyTime(eepy - 1);
            } else if (eepy == 1) {
                this.setEepyTime(0);
                this.ascend(1);
            }
        }
        if (this.tickCount % 600 == 0) {
            this.heal(1.0f);
        }
    }

    public boolean shouldBlockExplode(Explosion explosion, BlockGetter world, BlockPos pos, BlockState state, float explosionPower) {
        return super.shouldBlockExplode(explosion, world, pos, state, explosionPower);
    }

    private void ascend(int blastMod) {
        Level world = this.level();
        world.addParticle((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, this.getX(), this.getY(), this.getZ(), 1.0, 0.0, 0.0);
        world.explode((Entity)this, PastelDamageTypes.incandescence(world), null, this.getX(), this.getY(), this.getZ(), 10.0f * (float)blastMod, true, Level.ExplosionInteraction.MOB);
        this.playSound(SoundEvents.DRAGON_FIREBALL_EXPLODE, 2.0f, 0.5f);
        this.playSound(PastelSounds.DEEP_CRYSTAL_RING, 2.0f, 0.334f);
        this.playSound(SoundEvents.ENDER_DRAGON_AMBIENT, 1.0f, 2.0f);
        ((ServerLevel)world).getPlayers(p -> p.distanceTo((Entity)this) < 64.0f).forEach(p -> Support.grantAdvancementCriterion(p, "ascend_kindling", "he_explarded"));
        for (int i = 0; i < 5; ++i) {
            ((ServerLevel)world).sendParticles((ParticleOptions)ParticleTypes.DRAGON_BREATH, this.getRandomX(1.5), this.getY() + this.random.nextDouble(), this.getRandomZ(1.5), this.random.nextInt(6) + 1, 0.0, (double)(this.random.nextFloat() / 3.0f), 0.0, 0.0);
            ((ServerLevel)world).sendParticles((ParticleOptions)ParticleTypes.END_ROD, this.getRandomX(1.5), this.getY() + this.random.nextDouble(), this.getRandomZ(1.5), this.random.nextInt(6) + 1, 0.0, (double)(this.random.nextFloat() / 3.0f), 0.0, 0.0);
        }
        for (BlockPos transmutePos : BlockPos.withinManhattan((BlockPos)this.blockPosition(), (int)(12 * blastMod), (int)(6 * blastMod), (int)(12 * blastMod))) {
            BlockState candidate;
            double distance = Math.sqrt(transmutePos.distSqr((Vec3i)this.blockPosition()));
            if (!(distance <= (double)(6 * blastMod)) && !((double)this.random.nextFloat() < 1.0 / ((distance - 6.0) / 3.0)) || (candidate = world.getBlockState(transmutePos)).getDestroySpeed((BlockGetter)world, transmutePos) < 0.0f || !GenericClaimModsCompat.canBreak(world, transmutePos, (Entity)this)) continue;
            if (candidate.isAir()) {
                if (!(this.random.nextFloat() < 0.125f)) continue;
                ((ServerLevel)world).sendParticles((ParticleOptions)ParticleTypes.DRAGON_BREATH, (double)transmutePos.getX() + this.random.nextDouble(), (double)transmutePos.getY() + this.random.nextDouble(), (double)transmutePos.getZ() + this.random.nextDouble(), this.random.nextInt(3) + 1, (double)(this.random.nextFloat() / 5.0f) - 0.1, (double)(this.random.nextFloat() / 5.0f) - 0.1, (double)(this.random.nextFloat() / 5.0f) - 0.1, 0.0);
                continue;
            }
            if (!GenericClaimModsCompat.canModify(world, transmutePos, (Entity)this) || candidate.getFluidState().is(FluidTags.WATER)) continue;
            if (this.random.nextFloat() < 0.025f) {
                world.setBlockAndUpdate(transmutePos, Blocks.MAGMA_BLOCK.defaultBlockState());
                continue;
            }
            if (candidate.is(BlockTags.BASE_STONE_OVERWORLD) || candidate.is(BlockTags.BASE_STONE_NETHER)) {
                if (this.random.nextFloat() < 0.05f) {
                    world.setBlockAndUpdate(transmutePos, Blocks.CRYING_OBSIDIAN.defaultBlockState());
                    continue;
                }
                world.setBlockAndUpdate(transmutePos, Blocks.END_STONE.defaultBlockState());
                continue;
            }
            if (candidate.is(PastelBlockTags.BASE_STONE_DEEPER_DOWN)) {
                world.setBlockAndUpdate(transmutePos, ((Block)PastelBlocks.BLACK_MATERIA.get()).defaultBlockState());
                continue;
            }
            if (candidate.is(BlockTags.LOGS)) {
                world.setBlockAndUpdate(transmutePos, Blocks.COAL_BLOCK.defaultBlockState());
                continue;
            }
            if (candidate.is(BlockTags.DIRT)) {
                world.setBlockAndUpdate(transmutePos, Blocks.BROWN_STAINED_GLASS.defaultBlockState());
                continue;
            }
            if (candidate.is(Blocks.CLAY)) {
                world.setBlockAndUpdate(transmutePos, Blocks.TERRACOTTA.defaultBlockState());
                continue;
            }
            if (candidate.is(BlockTags.SAND)) {
                world.setBlockAndUpdate(transmutePos, Blocks.WHITE_STAINED_GLASS.defaultBlockState());
                continue;
            }
            if (!candidate.is(Blocks.OBSIDIAN)) continue;
            world.setBlockAndUpdate(transmutePos, Blocks.CRYING_OBSIDIAN.defaultBlockState());
        }
        this.remove(Entity.RemovalReason.DISCARDED);
        LightningBolt lightning = new LightningBolt(EntityType.LIGHTNING_BOLT, world);
        lightning.setPosRaw(this.getX(), this.getY(), this.getZ());
        world.addFreshEntity((Entity)lightning);
    }

    public void aiStep() {
        super.aiStep();
        Vec3 velocity = this.getDeltaMovement();
        boolean onGround = this.onGround();
        if (!onGround && velocity.y < 0.0) {
            this.setDeltaMovement(velocity.multiply(1.0, 0.6, 1.0));
        }
        if (onGround || (double)this.fallDistance < 0.2) {
            boolean isMoving;
            boolean bl = isMoving = this.getX() - this.xo != 0.0 || this.getZ() - this.zo != 0.0;
            if (this.getRemainingPersistentAngerTime() > 0) {
                this.setPose(isMoving ? Pose.EMERGING : Pose.ROARING);
            } else {
                this.setPose(isMoving ? Pose.SNIFFING : Pose.STANDING);
            }
        } else {
            this.setPose(Pose.FALL_FLYING);
        }
    }

    protected boolean isFlapping() {
        return true;
    }

    protected void onFlap() {
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        boolean bl;
        if (this.getRemainingPersistentAngerTime() > 0) {
            return InteractionResult.FAIL;
        }
        ItemStack handStack = player.getMainHandItem();
        if (this.readyForShearing() && handStack.is(Tags.Items.TOOLS_SHEAR)) {
            if (!this.level().isClientSide()) {
                this.setTarget((LivingEntity)player);
                this.takeRevenge(player.getUUID());
                this.makeMad();
                this.shear(SoundSource.PLAYERS);
                this.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
                if (!this.level().isClientSide) {
                    handStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        boolean bl2 = bl = !this.isBaby() && this.isTamed() && player.isSecondaryUseActive();
        if (!this.isVehicle() && !bl) {
            if (!handStack.isEmpty()) {
                if (this.isFood(handStack)) {
                    return this.fedFood(player, handStack);
                }
                if (!this.isTamed()) {
                    this.makeMad();
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
                }
            }
            if (player.isSecondaryUseActive()) {
                return super.mobInteract(player, hand);
            }
        }
        return super.mobInteract(player, hand);
    }

    public void shear(SoundSource shearedSoundCategory) {
        this.level().playSound(null, (Entity)this, SoundEvents.SHEEP_SHEAR, shearedSoundCategory, 1.0f, 1.0f);
        this.setClipped(4800);
        for (ItemStack clippedStack : this.getClippedStacks((ServerLevel)this.level())) {
            this.spawnAtLocation(clippedStack, 0.3f);
        }
    }

    public boolean readyForShearing() {
        return this.isAlive() && !this.isBaby() && !this.isClipped();
    }

    protected boolean handleEating(Player player, ItemStack item) {
        boolean canEat = false;
        if (this.getHealth() < this.getMaxHealth()) {
            this.heal(2.0f);
            canEat = true;
        }
        if (this.isBaby()) {
            this.level().addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), 0.0, 0.0, 0.0);
            if (!this.level().isClientSide) {
                this.ageUp(20);
            }
            canEat = true;
        } else if (!this.level().isClientSide && !this.isInLove()) {
            this.setInLove(player);
            canEat = true;
        }
        if ((canEat || !this.isTamed()) && this.getTemper() < this.getMaxTemper()) {
            canEat = true;
            if (!this.level().isClientSide) {
                this.modifyTemper(3);
            }
        }
        if (canEat) {
            this.gameEvent((Holder)GameEvent.EAT);
        }
        return canEat;
    }

    public void updatePersistentAnger(ServerLevel world, boolean angerPersistent) {
        LivingEntity livingEntity = this.getTarget();
        UUID uUID = this.getPersistentAngerTarget();
        if ((livingEntity == null || livingEntity.isDeadOrDying()) && uUID != null && world.getEntity(uUID) instanceof Mob) {
            this.stopBeingAngry();
        } else if (!(this.getRemainingPersistentAngerTime() <= 0 || livingEntity != null && livingEntity.getType() == EntityType.PLAYER && angerPersistent)) {
            this.setRemainingPersistentAngerTime(this.getRemainingPersistentAngerTime() - 1);
            if (this.getRemainingPersistentAngerTime() == 0) {
                this.stopBeingAngry();
            }
        }
    }

    public List<ItemStack> getClippedStacks(ServerLevel world) {
        LootTable lootTable = world.getServer().reloadableRegistries().getLootTable(this.getKindlingVariant().getClippingLootTable());
        return lootTable.getRandomItems(new LootParams.Builder(world).withParameter(LootContextParams.THIS_ENTITY, (Object)this).create(LootContextParamSets.PIGLIN_BARTER));
    }

    protected void coughAt(LivingEntity target) {
        KindlingCoughEntity kindlingCoughEntity = new KindlingCoughEntity(this.level(), (LivingEntity)this);
        double d = target.getX() - this.getX();
        double e = target.getY((double)0.33f) - kindlingCoughEntity.getY();
        double f = target.getZ() - this.getZ();
        double g = Math.sqrt(d * d + f * f) * 0.2;
        kindlingCoughEntity.shoot(d, e + g, f, 1.5f, 10.0f);
        if (!this.isSilent()) {
            this.playSound(PastelSounds.ENTITY_KINDLING_SHOOT, 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
        this.level().addFreshEntity((Entity)kindlingCoughEntity);
    }

    public boolean isClipped() {
        return (Integer)this.entityData.get(CLIPPED) > 0;
    }

    public int getClipTime() {
        return (Integer)this.entityData.get(CLIPPED);
    }

    public void setClipped(int clipTime) {
        this.entityData.set(CLIPPED, (Object)clipTime);
    }

    public int getChillTime() {
        return (Integer)this.entityData.get(CHILL);
    }

    public void setChillTime(int chillTime) {
        this.entityData.set(CHILL, (Object)chillTime);
    }

    public void setEepyTime(int eepySneeze) {
        this.entityData.set(EEPY_SNEEZE, (Object)eepySneeze);
    }

    public int getEepyTime() {
        return (Integer)this.entityData.get(EEPY_SNEEZE);
    }

    public void setPlaying(boolean playing) {
        this.entityData.set(PLAYING, (Object)playing);
    }

    public boolean isPlaying() {
        return (Boolean)this.entityData.get(PLAYING);
    }

    public void setIncited(boolean incited) {
        this.entityData.set(INCITED, (Object)incited);
    }

    public boolean isIncited() {
        return (Boolean)this.entityData.get(INCITED);
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(ANGER);
    }

    public void setRemainingPersistentAngerTime(int angerTime) {
        this.entityData.set(ANGER, (Object)angerTime);
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.angryAt;
    }

    public void setPersistentAngerTarget(@Nullable UUID angryAt) {
        this.angryAt = angryAt;
    }

    public void takeRevenge(UUID target) {
        this.setPersistentAngerTarget(target);
        this.setIncited(false);
        this.setPlaying(false);
        this.startPersistentAngerTimer();
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(ANGER_TIME_RANGE.sample(this.random));
    }

    public void performRangedAttack(LivingEntity target, float pullProgress) {
        this.coughAt(target);
    }

    public boolean canEatGrass() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canMate(Animal other) {
        if (other == this) return false;
        if (!(other instanceof KindlingEntity)) return false;
        KindlingEntity otherKindling = (KindlingEntity)other;
        if (!this.canParent()) return false;
        if (!otherKindling.canParent()) return false;
        return true;
    }

    protected class CancellableProjectileAttackGoal
    extends RangedAttackGoal {
        public CancellableProjectileAttackGoal(RangedAttackMob mob, double mobSpeed, int intervalTicks, float maxShootRange) {
            super(mob, mobSpeed, intervalTicks, maxShootRange);
        }

        public boolean canContinueToUse() {
            return KindlingEntity.this.isAngry() && super.canContinueToUse() && KindlingEntity.this.distanceTo((Entity)this.getProjectileTarget()) > 3.0f;
        }

        public boolean canUse() {
            return super.canUse() && !KindlingEntity.this.isPlaying() && KindlingEntity.this.distanceTo((Entity)this.getProjectileTarget()) > 4.0f;
        }

        protected LivingEntity getProjectileTarget() {
            return ((ProjectileAttackGoalAccessor)((Object)this)).getProjectileAttackTarget();
        }
    }

    protected class MeleeChaseGoal
    extends MeleeAttackGoal {
        public MeleeChaseGoal(KindlingEntity kindling) {
            super((PathfinderMob)kindling, (double)0.6f, true);
        }

        public boolean canUse() {
            KindlingEntity kindling = KindlingEntity.this;
            UUID angryAt = kindling.getPersistentAngerTarget();
            if (angryAt == null) {
                return false;
            }
            return super.canUse() && kindling.isAngry() && !KindlingEntity.this.isPlaying() && KindlingEntity.this.distanceTo((Entity)this.mob.getTarget()) < 5.0f;
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse() && KindlingEntity.this.distanceTo((Entity)this.mob.getTarget()) < 9.0f;
        }
    }

    protected class PlayRoughGoal
    extends MeleeAttackGoal {
        public PlayRoughGoal(PathfinderMob mob) {
            super(mob, (double)0.4f, true);
        }

        public boolean canUse() {
            return super.canUse() && !KindlingEntity.this.isAngry() && !KindlingEntity.this.isVehicle() && KindlingEntity.this.isPlaying();
        }

        public boolean canContinueToUse() {
            KindlingEntity playMate;
            if (!super.canContinueToUse()) {
                return false;
            }
            LivingEntity livingEntity = KindlingEntity.this.getTarget();
            if (livingEntity instanceof KindlingEntity && (playMate = (KindlingEntity)livingEntity).isAngry() || KindlingEntity.this.isVehicle()) {
                KindlingEntity.this.setTarget(null);
                KindlingEntity.this.setIncited(false);
                return false;
            }
            return !KindlingEntity.this.isAngry();
        }

        protected void checkAndPerformAttack(LivingEntity target) {
            if (this.canPerformAttack(target)) {
                KindlingEntity playMate;
                this.resetAttackCooldown();
                this.mob.swing(InteractionHand.MAIN_HAND);
                this.mob.doHurtTarget((Entity)target);
                if (target instanceof KindlingEntity && !(playMate = (KindlingEntity)target).isAngry() && KindlingEntity.this.random.nextBoolean()) {
                    playMate.setIncited(true);
                }
                if (!(target instanceof Enemy)) {
                    target.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 200));
                }
                if (KindlingEntity.this.random.nextBoolean()) {
                    this.stop();
                    KindlingEntity.this.setIncited(false);
                    this.mob.setTarget(null);
                    KindlingEntity.this.setChillTime(2400 * (target instanceof Player ? 2 : 1));
                }
            }
        }
    }

    protected class CoughRevengeGoal
    extends HurtByTargetGoal {
        public CoughRevengeGoal(KindlingEntity kindling) {
            super((PathfinderMob)kindling, new Class[]{KindlingEntity.class});
        }

        public boolean canContinueToUse() {
            return KindlingEntity.this.isAngry() && super.canContinueToUse();
        }

        public void start() {
            super.start();
            LivingEntity attacker = KindlingEntity.this.getLastHurtByMob();
            if (attacker != null) {
                KindlingEntity.this.takeRevenge(KindlingEntity.this.getLastHurtByMob().getUUID());
            }
        }

        protected void alertOther(Mob mob, LivingEntity target) {
            if (mob instanceof Bee && this.mob.hasLineOfSight((Entity)target)) {
                mob.setTarget(target);
            }
        }
    }

    protected class FindPlayMateGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        private final float waitModifier;

        public FindPlayMateGoal(Mob mob, int reciprocalChance, float waitModifier, Class<T> targetClass) {
            super(mob, targetClass, reciprocalChance, true, true, null);
            this.waitModifier = waitModifier;
        }

        public boolean canUse() {
            int chill;
            if (KindlingEntity.this.isAngry() || KindlingEntity.this.isVehicle() || KindlingEntity.this.isInLove()) {
                return false;
            }
            if (!KindlingEntity.this.isIncited() && (chill = KindlingEntity.this.getChillTime()) > 0) {
                return false;
            }
            if (KindlingEntity.this.isIncited() || this.randomInterval > 0 && this.mob.getRandom().nextInt(this.randomInterval) != 0) {
                this.findTarget();
                if (this.target != null) {
                    KindlingEntity.this.setChillTime((int)(1200.0f * this.waitModifier));
                    return true;
                }
            }
            return false;
        }

        public void start() {
            super.start();
            KindlingEntity.this.setPlaying(true);
        }
    }
}

