/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.entity;

import earth.terrarium.pastel.api.block.ColorableBlock;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.api.interaction.EntityColorProcessorRegistry;
import earth.terrarium.pastel.compat.claims.GenericClaimModsCompat;
import earth.terrarium.pastel.entity.PastelEntityTypes;
import earth.terrarium.pastel.entity.PastelTrackedDataHandlerRegistry;
import earth.terrarium.pastel.entity.entity.MagicProjectileEntity;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.helpers.level.BlockVariantHelper;
import earth.terrarium.pastel.particle.effect.ColoredCraftingParticleEffect;
import earth.terrarium.pastel.particle.effect.ColoredExplosionParticleEffect;
import earth.terrarium.pastel.progression.PastelCriteria;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import earth.terrarium.pastel.registries.PastelRegistries;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class InkProjectileEntity
extends MagicProjectileEntity {
    private static final int COLOR_SPLAT_RANGE = 2;
    private static final int SPELL_POTENCY = 2;
    private static final float DAMAGE_PER_POTENCY = 0.5f;
    private static final EntityDataAccessor<InkColor> COLOR = SynchedEntityData.defineId(InkProjectileEntity.class, PastelTrackedDataHandlerRegistry.INK_COLOR);

    public InkProjectileEntity(EntityType<InkProjectileEntity> type, Level world) {
        super(type, world);
    }

    public InkProjectileEntity(double x, double y, double z, Level world) {
        this((EntityType<InkProjectileEntity>)((EntityType)PastelEntityTypes.INK_PROJECTILE.get()), world);
        this.moveTo(x, y, z, this.getYRot(), this.getXRot());
        this.reapplyPosition();
    }

    public InkProjectileEntity(Level world, LivingEntity owner) {
        this(owner.getX(), owner.getEyeY() - 0.1, owner.getZ(), world);
        this.setOwner((Entity)owner);
        this.setRot(owner.getYRot(), owner.getXRot());
    }

    public static void shoot(Level world, LivingEntity entity, InkColor color) {
        InkProjectileEntity projectile = new InkProjectileEntity(world, entity);
        projectile.shootFromRotation((Entity)entity, entity.getXRot(), entity.getYRot(), 0.0f, 2.0f, 1.0f);
        projectile.setColor(color);
        world.addFreshEntity((Entity)projectile);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(COLOR, (Object)InkColors.RED);
    }

    @Override
    public InkColor getInkColor() {
        return (InkColor)this.entityData.get(COLOR);
    }

    public void setColor(InkColor inkColor) {
        this.entityData.set(COLOR, (Object)inkColor);
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        ResourceLocation inkColorId = PastelRegistries.INK_COLOR.getKey((Object)this.getInkColor());
        if (inkColorId != null) {
            nbt.putString("ink_color", inkColorId.toString());
        }
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        ResourceLocation inkColorId;
        InkColor inkColor;
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("ink_color", 8) && (inkColor = (InkColor)PastelRegistries.INK_COLOR.get(inkColorId = ResourceLocation.parse((String)nbt.getString("ink_color")))) != null) {
            this.setColor(inkColor);
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.spawnParticles(1);
    }

    private void spawnParticles(int amount) {
        InkColor inkColor = this.getInkColor();
        if (amount > 0) {
            for (int j = 0; j < amount; ++j) {
                this.level().addParticle(ColoredCraftingParticleEffect.of(inkColor.getColorInt()), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        DamageSource damageSource;
        Player player;
        super.onHitEntity(entityHitResult);
        Entity target = entityHitResult.getEntity();
        Entity owner = this.getOwner();
        if (EntityColorProcessorRegistry.colorEntity(target, this.getInkColor().getDyeColor(), owner instanceof Player ? (player = (Player)owner) : null)) {
            target.level().playSound(null, target, SoundEvents.DYE_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        float velocity = (float)this.getDeltaMovement().length();
        int damage = Mth.ceil((double)Mth.clamp((double)((double)velocity * 0.5 * 2.0), (double)0.0, (double)2.147483647E9));
        if (owner == null) {
            damageSource = PastelDamageTypes.inkProjectile(this, (Entity)this);
        } else {
            damageSource = PastelDamageTypes.inkProjectile(this, owner);
            if (owner instanceof LivingEntity) {
                LivingEntity livingOwner = (LivingEntity)owner;
                livingOwner.setLastHurtMob(target);
            }
        }
        if (target.hurt(damageSource, (float)damage)) {
            if (target instanceof LivingEntity) {
                ServerPlayer ownerPlayer;
                LivingEntity livingTarget = (LivingEntity)target;
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverWorld, (Entity)target, (DamageSource)damageSource, null);
                }
                this.onHit(livingTarget);
                if (target != owner && target instanceof Player && owner instanceof ServerPlayer) {
                    ownerPlayer = (ServerPlayer)owner;
                    if (!this.isSilent()) {
                        ownerPlayer.connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.ARROW_HIT_PLAYER, 0.0f));
                    }
                }
                if (owner instanceof ServerPlayer) {
                    ownerPlayer = (ServerPlayer)owner;
                    if (!target.isAlive()) {
                        PastelCriteria.KILLED_BY_INK_PROJECTILE.trigger(ownerPlayer, List.of(target));
                    }
                }
            }
            this.playSound(this.getHitSound(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
            this.discard();
        } else {
            this.setDeltaMovement(this.getDeltaMovement().scale(-0.1));
            this.setYRot(this.getYRot() + 180.0f);
            this.yRotO += 180.0f;
            if (!this.level().isClientSide() && this.getDeltaMovement().lengthSqr() < 1.0E-7) {
                this.discard();
            }
        }
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        Vec3 vec3d = blockHitResult.getLocation().subtract(this.getX(), this.getY(), this.getZ());
        this.setDeltaMovement(vec3d);
        Vec3 vec3d2 = vec3d.normalize().scale(0.05);
        this.setPosRaw(this.getX() - vec3d2.x, this.getY() - vec3d2.y, this.getZ() - vec3d2.z);
        this.playSound(this.getHitSound(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
        InkColor inkColor = this.getInkColor();
        for (BlockPos blockPos : BlockPos.withinManhattan((BlockPos)blockHitResult.getBlockPos(), (int)2, (int)2, (int)2)) {
            BlockState coloredBlockState;
            Optional<DyeColor> dyeColor = inkColor.getDyeColor();
            Block block = this.level().getBlockState(blockPos).getBlock();
            if (block instanceof ColorableBlock) {
                ColorableBlock colorableBlock = (ColorableBlock)block;
                if (!GenericClaimModsCompat.canModify(this.level(), blockPos, this.getOwner())) continue;
                colorableBlock.color(this.level(), blockPos, dyeColor, this.getOwner());
                continue;
            }
            if (!dyeColor.isPresent() || (coloredBlockState = BlockVariantHelper.getCursedBlockColorVariant(this.level(), blockPos, dyeColor.get())).isAir()) continue;
            this.level().setBlockAndUpdate(blockPos, coloredBlockState);
        }
        this.affectEntitiesInRange(this.getOwner());
        this.discard();
    }

    protected void onHit(LivingEntity target) {
        Vec3 vec3d = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale(1.7999999999999998);
        if (vec3d.lengthSqr() > 0.0) {
            target.push(vec3d.x, 0.1, vec3d.z);
        }
        this.affectEntitiesInRange(this.getOwner());
        this.discard();
    }

    public void affectEntitiesInRange(Entity attacker) {
        this.level().gameEvent((Entity)this, (Holder)GameEvent.PROJECTILE_LAND, BlockPos.containing((double)this.position().x, (double)this.position().y, (double)this.position().z));
        double posX = this.position().x;
        double posY = this.position().y;
        double posZ = this.position().z;
        float q = 4.0f;
        double k = Mth.floor((double)(posX - (double)q - 1.0));
        double l = Mth.floor((double)(posX + (double)q + 1.0));
        int r = Mth.floor((double)(posY - (double)q - 1.0));
        int s = Mth.floor((double)(posY + (double)q + 1.0));
        int t = Mth.floor((double)(posZ - (double)q - 1.0));
        int u = Mth.floor((double)(posZ + (double)q + 1.0));
        List list = this.level().getEntities((Entity)this, new AABB(k, (double)r, (double)t, l, (double)s, (double)u));
        Vec3 vec3d = new Vec3(posX, posY, posZ);
        Entity owner = this.getOwner();
        for (Entity entity : list) {
            double z;
            double y;
            double x;
            double aa;
            double w;
            Player player;
            if (!GenericClaimModsCompat.canInteract(this.level(), entity, attacker)) continue;
            if (EntityColorProcessorRegistry.colorEntity(entity, this.getInkColor().getDyeColor(), owner instanceof Player ? (player = (Player)owner) : null)) {
                entity.level().playSound(null, entity, SoundEvents.DYE_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            if (entity.ignoreExplosion(null) || !((w = Math.sqrt(entity.distanceToSqr(vec3d)) / (double)q) <= 1.0) || (aa = Math.sqrt((x = entity.getX() - posX) * x + (y = (entity instanceof PrimedTnt ? entity.getY() : entity.getEyeY()) - posY) * y + (z = entity.getZ() - posZ) * z)) == 0.0) continue;
            x /= aa;
            y /= aa;
            z /= aa;
            double ab = Explosion.getSeenPercent((Vec3)vec3d, (Entity)entity);
            double velocity = (1.0 - w) * ab;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                int i = Ench.getEquipmentLevel((HolderLookup.Provider)this.level().registryAccess(), (ResourceKey<Enchantment>)Enchantments.BLAST_PROTECTION, livingEntity);
                if (i > 0) {
                    velocity *= Mth.clamp((double)(1.0 - (double)i * 0.15), (double)0.0, (double)1.0);
                }
            }
            entity.setDeltaMovement(entity.getDeltaMovement().add(x * velocity, y * velocity, z * velocity));
        }
    }

    @Override
    public void spawnImpactParticles() {
        InkColor inkColor = this.getInkColor();
        Level world = this.level();
        Vec3 targetPos = this.position();
        Vec3 velocity = this.getDeltaMovement();
        world.addParticle(ColoredExplosionParticleEffect.of(inkColor.getColorInt()), targetPos.x, targetPos.y, targetPos.z, 0.0, 0.0, 0.0);
        for (int i = 0; i < 10; ++i) {
            world.addParticle(ColoredCraftingParticleEffect.of(inkColor.getColorInt()), targetPos.x, targetPos.y, targetPos.z, -velocity.x * 3.0, -velocity.y * 3.0, -velocity.z * 3.0);
        }
    }
}

