/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.entity;

import earth.terrarium.pastel.blocks.gravity.FloatBlock;
import earth.terrarium.pastel.entity.PastelEntityTypes;
import earth.terrarium.pastel.recipe.anvil_crushing.AnvilCrusher;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import java.util.function.Predicate;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FloatBlockEntity
extends Entity {
    private static final float MAX_DAMAGE = 8.0f;
    private static final float DAMAGE_PER_FALLEN_BLOCK = 0.5f;
    private static final EntityDataAccessor<BlockPos> ORIGIN = SynchedEntityData.defineId(FloatBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private static final EntityDataAccessor<Long> LAUNCH_TIME = SynchedEntityData.defineId(FloatBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.LONG);
    private static final EntityDataAccessor<Float> GRAVITY_MODIFIER = SynchedEntityData.defineId(FloatBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public int moveTime = 0;
    protected CompoundTag blockEntityData;
    protected BlockState blockState = Blocks.STONE.defaultBlockState();
    protected boolean canSetBlock = true;
    protected boolean collides;

    public FloatBlockEntity(EntityType<? extends FloatBlockEntity> entityType, Level world) {
        super(entityType, world);
    }

    public FloatBlockEntity(EntityType<? extends FloatBlockEntity> entityType, Level world, double x, double y, double z, BlockState blockState) {
        this(entityType, world);
        this.blockState = blockState;
        this.blocksBuilding = true;
        this.setPos(x, y, z);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.setOrigin(BlockPos.containing((Position)this.position()));
        this.setLaunchTime(this.level().getGameTime());
        Block block = blockState.getBlock();
        if (block instanceof FloatBlock) {
            FloatBlock floatBlock = (FloatBlock)block;
            this.setGravity(floatBlock.getGravityMod());
        }
    }

    public FloatBlockEntity(Level world, BlockPos pos, BlockState blockState) {
        this((EntityType<? extends FloatBlockEntity>)((EntityType)PastelEntityTypes.FLOAT_BLOCK.get()), world, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, blockState);
    }

    protected AABB makeBoundingBox() {
        if (this.entityData == null || this.blockState == null) {
            return super.makeBoundingBox();
        }
        BlockPos origin = (BlockPos)this.entityData.get(ORIGIN);
        VoxelShape shape = this.blockState.getCollisionShape((BlockGetter)this.level(), origin);
        if (shape.isEmpty()) {
            this.collides = false;
            shape = this.blockState.getShape((BlockGetter)this.level(), origin);
            if (shape.isEmpty()) {
                return super.makeBoundingBox();
            }
        } else {
            this.collides = true;
        }
        AABB box = shape.bounds();
        return box.move(this.position().subtract(new Vec3(0.5, 0.0, 0.5)));
    }

    public void tick() {
        if (this.getBlockState().isAir()) {
            this.discard();
            return;
        }
        if (this.moveTime++ == 0) {
            BlockPos blockPos = this.blockPosition();
            Block block = this.blockState.getBlock();
            if (this.level().getBlockState(blockPos).is(block)) {
                this.level().removeBlock(blockPos, false);
            }
        }
        if (!this.isNoGravity()) {
            this.moveDist = (float)this.position().y() - (float)this.getOrigin().getY();
            long launchTime = this.level().getGameTime() - this.getLaunchTime();
            double additionalYVelocity = launchTime > 100L ? this.getDefaultGravity() / 10.0 : Math.min(Math.sin(Math.PI * (double)launchTime / 100.0), 1.0) * (this.getDefaultGravity() / 10.0);
            this.push(0.0, additionalYVelocity, 0.0);
            this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
            if (!this.level().isClientSide) {
                this.dealDamage();
            }
        }
        this.moveEntities();
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (!this.level().isClientSide) {
            if (this.verticalCollision) {
                this.trySetBlock();
            } else if (this.tickCount > 100 && this.level().isOutsideBuildHeight(this.blockPosition())) {
                this.dropAsItem();
                this.discard();
            }
        }
    }

    public void move(MoverType movementType, Vec3 movement) {
        super.move(movementType, movement);
        if (movementType != MoverType.SELF) {
            this.setDeltaMovement(movement);
        }
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (player.isShiftKeyDown()) {
            if (this.level().isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            Item item = this.blockState.getBlock().asItem();
            if (item != null) {
                player.getInventory().placeItemBackInInventory(item.getDefaultInstance());
            }
            this.discard();
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public ItemStack getPickResult() {
        return this.blockState.getBlock().asItem().getDefaultInstance();
    }

    public void onEntityCollision(Entity entity) {
        if (!(entity instanceof FloatBlockEntity)) {
            this.blockState.entityInside(this.level(), this.blockPosition(), entity);
        }
    }

    public void dealDamage() {
        int damage;
        int traveledDistance = Mth.ceil((float)(this.fallDistance - 1.0f));
        if (traveledDistance > 0 && (damage = (int)Math.min((float)Mth.floor((float)((float)traveledDistance * 0.5f)), 8.0f)) > 0) {
            Predicate<Entity> predicate = EntitySelector.NO_CREATIVE_OR_SPECTATOR.and(entity -> entity.isAlive() && (entity instanceof LivingEntity || entity instanceof ItemEntity));
            this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.5), predicate).forEach(entity -> {
                if (entity instanceof ItemEntity) {
                    ItemEntity itemEntity = (ItemEntity)entity;
                    AnvilCrusher.crush(itemEntity, damage);
                } else {
                    entity.hurt(PastelDamageTypes.floatblock(entity.level()), (float)damage);
                }
            });
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.put("BlockState", (Tag)NbtUtils.writeBlockState((BlockState)this.blockState));
        compound.putInt("Time", this.moveTime);
        if (this.blockEntityData != null) {
            compound.put("BlockEntityData", (Tag)this.blockEntityData);
        }
        compound.putFloat("GravityModifier", (float)this.getDefaultGravity());
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.blockState = NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)compound.getCompound("BlockState"));
        this.moveTime = compound.getInt("Time");
        if (compound.contains("BlockEntityData", 10)) {
            this.blockEntityData = compound.getCompound("BlockEntityData");
        }
        if (this.blockState.isAir()) {
            this.blockState = Blocks.STONE.defaultBlockState();
        }
        if (compound.contains("GravityModifier", 5)) {
            this.setGravity(compound.getFloat("GravityModifier"));
        }
    }

    public boolean displayFireAnimation() {
        return false;
    }

    public void fillCrashReportCategory(CrashReportCategory section) {
        super.fillCrashReportCategory(section);
        section.setDetail("Imitating BlockState", (Object)this.blockState.toString());
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public void trySetBlock() {
        BlockPos blockPos = this.blockPosition();
        BlockState blockState = this.level().getBlockState(blockPos);
        boolean canReplace = blockState.canBeReplaced((BlockPlaceContext)new DirectionalPlaceContext(this.level(), blockPos, Direction.UP, ItemStack.EMPTY, Direction.DOWN));
        boolean canPlace = this.blockState.canSurvive((LevelReader)this.level(), blockPos);
        if (!(this.canSetBlock && canPlace && canReplace)) {
            return;
        }
        if (this.blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && this.level().getFluidState(blockPos).getType() == Fluids.WATER) {
            this.blockState = (BlockState)this.blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        if (this.level().setBlock(blockPos, this.blockState, 3)) {
            BlockEntity blockEntity;
            this.discard();
            if (this.blockEntityData != null && this.blockState.hasBlockEntity() && (blockEntity = this.level().getBlockEntity(blockPos)) != null) {
                RegistryAccess registryLookup = this.level().registryAccess();
                CompoundTag compoundTag = blockEntity.saveWithoutMetadata((HolderLookup.Provider)registryLookup);
                for (String keyName : this.blockEntityData.getAllKeys()) {
                    Tag tag = this.blockEntityData.get(keyName);
                    if (tag == null || "x".equals(keyName) || "y".equals(keyName) || "z".equals(keyName)) continue;
                    compoundTag.put(keyName, tag.copy());
                }
                blockEntity.loadWithComponents(compoundTag, (HolderLookup.Provider)registryLookup);
                blockEntity.setChanged();
            }
        }
    }

    public void moveEntities() {
        if (FallingBlock.isFree((BlockState)this.blockState)) {
            return;
        }
        Level world = this.level();
        AABB collissionBox = this.getBoundingBox().inflate(0.0, 2.0, 0.0);
        for (Entity entity : world.getEntities((Entity)this, collissionBox)) {
            FloatBlockEntity other;
            if (entity instanceof FloatBlockEntity && this.isPaltaeriaStratineCollision(other = (FloatBlockEntity)entity)) {
                world.explode((Entity)this, this.getX(), this.getY(), this.getZ(), 1.0f, Level.ExplosionInteraction.NONE);
                ItemStack collisionStack = ((Block)PastelBlocks.HOVER_BLOCK.get()).asItem().getDefaultInstance();
                ItemEntity itemEntity = new ItemEntity(world, this.getX(), this.getY(), this.getZ(), collisionStack);
                itemEntity.push(0.1 - (double)world.random.nextFloat() * 0.2, 0.1 - (double)world.random.nextFloat() * 0.2, 0.1 - (double)world.random.nextFloat() * 0.2);
                world.addFreshEntity((Entity)itemEntity);
                this.discard();
                other.discard();
                continue;
            }
            if (!entity.isPushable() || entity.getPistonPushReaction() == PushReaction.IGNORE || !entity.getBoundingBox().intersects(collissionBox)) continue;
            entity.move(MoverType.SHULKER_BOX, this.getDeltaMovement());
            entity.setOnGround(true);
            entity.fallDistance = 0.0f;
            this.onEntityCollision(entity);
        }
    }

    public boolean isPaltaeriaStratineCollision(FloatBlockEntity other) {
        Block thisBlock = this.blockState.getBlock();
        Block otherBlock = other.getBlockState().getBlock();
        return thisBlock == PastelBlocks.PALTAERIA_FLOATBLOCK.get() && otherBlock == PastelBlocks.STRATINE_FLOATBLOCK.get() || thisBlock == PastelBlocks.STRATINE_FLOATBLOCK.get() && otherBlock == PastelBlocks.PALTAERIA_FLOATBLOCK.get();
    }

    public void dropAsItem() {
        if (this.isRemoved()) {
            return;
        }
        this.discard();
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            Block.dropResources((BlockState)this.blockState, (Level)this.level(), (BlockPos)this.blockPosition());
        }
        this.level().levelEvent(null, 2001, this.blockPosition(), Block.getId((BlockState)this.blockState));
    }

    public boolean onlyOpCanSetNbt() {
        return true;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entityTrackerEntry) {
        return new ClientboundAddEntityPacket((Entity)this, entityTrackerEntry, Block.getId((BlockState)this.getBlockState()));
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        this.blockState = Block.stateById((int)packet.getData());
        this.blocksBuilding = true;
        double d = packet.getX();
        double e = packet.getY();
        double f = packet.getZ();
        this.setPos(d, e + (double)((1.0f - this.getBbHeight()) / 2.0f), f);
        this.setOrigin(this.blockPosition());
    }

    public boolean isAttackable() {
        return false;
    }

    public BlockPos getOrigin() {
        return (BlockPos)this.entityData.get(ORIGIN);
    }

    public void setOrigin(BlockPos origin) {
        this.entityData.set(ORIGIN, (Object)origin);
        this.setPos(this.getX(), this.getY(), this.getZ());
    }

    public Long getLaunchTime() {
        return (Long)this.entityData.get(LAUNCH_TIME);
    }

    public void setLaunchTime(long spawnTime) {
        this.entityData.set(LAUNCH_TIME, (Object)spawnTime);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ORIGIN, (Object)BlockPos.ZERO);
        builder.define(GRAVITY_MODIFIER, (Object)Float.valueOf(0.0f));
        builder.define(LAUNCH_TIME, (Object)0L);
    }

    public boolean canBeCollidedWith() {
        return this.collides;
    }

    public double getDefaultGravity() {
        return ((Float)this.entityData.get(GRAVITY_MODIFIER)).floatValue();
    }

    protected void setGravity(float modifier) {
        this.entityData.set(GRAVITY_MODIFIER, (Object)Float.valueOf(modifier));
    }

    public boolean isNoGravity() {
        return this.getDefaultGravity() == 0.0 || super.isNoGravity();
    }
}

