/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.entity;

import com.cmdpro.databank.misc.ColorGradient;
import earth.terrarium.pastel.api.item.SlotReservingItem;
import earth.terrarium.pastel.entity.PastelEntityTypes;
import earth.terrarium.pastel.entity.entity.BidentBaseEntity;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.items.tools.DragonTalonItem;
import earth.terrarium.pastel.mixin.accessors.PersistentProjectileEntityAccessor;
import earth.terrarium.pastel.mixin.accessors.TridentEntityAccessor;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import earth.terrarium.pastel.registries.PastelEnchantments;
import earth.terrarium.pastel.registries.PastelMobEffects;
import earth.terrarium.pastel.registries.PastelSounds;
import java.awt.Color;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.jetbrains.annotations.Nullable;

public class DragonTalonEntity
extends BidentBaseEntity {
    private static final EntityDataAccessor<Boolean> HIT = SynchedEntityData.defineId(DragonTalonEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public DragonTalonEntity(Level world) {
        this((EntityType<? extends ThrownTrident>)((EntityType)PastelEntityTypes.DRAGON_TALON.get()), world);
    }

    public DragonTalonEntity(EntityType<? extends ThrownTrident> entityType, Level world) {
        super(entityType, world);
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        BlockPos pos = blockHitResult.getBlockPos();
        BlockState state = this.level().getBlockState(pos);
        if (state.is(Blocks.SLIME_BLOCK) && this.getDeltaMovement().lengthSqr() > 1.0) {
            switch (blockHitResult.getDirection().getAxis()) {
                case X: {
                    this.setDeltaMovement(this.getDeltaMovement().multiply(-1.0, 1.0, 1.0));
                    break;
                }
                case Y: {
                    this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, -1.0, 1.0));
                    break;
                }
                case Z: {
                    this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 1.0, -1.0));
                }
            }
            this.playSound(PastelSounds.METAL_HIT, 1.0f, 1.5f);
            return;
        }
        super.onHitBlock(blockHitResult);
        if (((Boolean)this.entityData.get(HIT)).booleanValue() || this.isNoPhysics()) {
            return;
        }
        this.entityData.set(HIT, (Object)true);
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        ServerLevel serverWorld;
        ItemStack stack = this.getTrackedStack();
        Entity attacked = entityHitResult.getEntity();
        if (attacked.getType() == EntityType.ENDERMAN) {
            return;
        }
        Entity owner = this.getOwner();
        float damage = 2.0f;
        DamageSource damageSource = PastelDamageTypes.impaling(this.level(), (Entity)this, owner);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            serverWorld = (ServerLevel)level;
            damage *= EnchantmentHelper.modifyDamage((ServerLevel)serverWorld, (ItemStack)stack, (Entity)attacked, (DamageSource)damageSource, (float)this.getDamage(stack));
        }
        if (attacked.hurt(damageSource, damage)) {
            level = this.level();
            if (level instanceof ServerLevel) {
                serverWorld = (ServerLevel)level;
                EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverWorld, (Entity)attacked, (DamageSource)damageSource, (ItemStack)stack);
            }
            if (attacked instanceof LivingEntity) {
                LivingEntity livingAttacked = (LivingEntity)attacked;
                this.doPostHurtEffects(livingAttacked);
            }
        }
        ((TridentEntityAccessor)((Object)this)).setDealtDamage(true);
        this.recall();
        this.setDeltaMovement(this.getDeltaMovement().multiply(-0.01, -0.1, -0.01));
        float g = 1.0f;
        this.playSound(PastelSounds.IMPALING_HIT, g, 1.0f);
    }

    private float getDamage(ItemStack stack) {
        MutableDouble damage = new MutableDouble(0.0);
        ResourceKey key = Attributes.ATTACK_DAMAGE.unwrapKey().orElse(null);
        double base = ((Attribute)Attributes.ATTACK_DAMAGE.value()).getDefaultValue();
        ItemAttributeModifiers modifiers = (ItemAttributeModifiers)stack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        modifiers.forEach(EquipmentSlot.MAINHAND, (attribute, modifier) -> {
            if (attribute.is(key)) {
                double value = modifier.amount();
                damage.addAndGet(switch (modifier.operation()) {
                    default -> throw new MatchException(null, null);
                    case AttributeModifier.Operation.ADD_VALUE -> value;
                    case AttributeModifier.Operation.ADD_MULTIPLIED_BASE -> value * base;
                    case AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> value * damage.getValue();
                });
            }
        });
        return damage.getValue().floatValue();
    }

    protected void doPostHurtEffects(LivingEntity target) {
        if (this.getOwner() == null) {
            return;
        }
        Entity owner = this.getOwner();
        float difMod = 4.0f;
        boolean airborne = !owner.onGround();
        boolean sneaking = owner.isShiftKeyDown();
        int inertia = Ench.getLevel((HolderLookup.Provider)owner.level().registryAccess(), PastelEnchantments.INERTIA, this.getTrackedStack());
        if (sneaking) {
            difMod *= 3.0f;
        }
        if (airborne) {
            difMod /= 2.0f;
        }
        if (inertia > 0) {
            difMod *= (float)inertia * 1.5f + 1.0f;
        }
        float sizeDif = this.getVolumeDif(target, difMod);
        this.yoink((Entity)target, this.getOwner().position(), 0.25 * (double)sizeDif, 0.175);
        if (airborne) {
            this.yoink(owner, target.position(), 0.125 / (double)sizeDif, 0.16);
        }
    }

    private float getVolumeDif(LivingEntity target, float pullMod) {
        if (this.getOwner() == null) {
            return 0.0f;
        }
        AABB ownerBox = this.getOwner().getBoundingBox();
        AABB targetBox = target.getBoundingBox();
        float ownerVolume = (float)(ownerBox.getXsize() * ownerBox.getYsize() * ownerBox.getZsize());
        float targetVolume = (float)(targetBox.getXsize() * targetBox.getYsize() * targetBox.getZsize());
        return Math.max(Math.min(ownerVolume / (targetVolume / pullMod), 0.8f), 0.5f);
    }

    public void recall() {
        Entity owner = this.getOwner();
        if (((Boolean)this.entityData.get(HIT)).booleanValue() && !this.isNoPhysics()) {
            this.yoink(owner, this.position(), 0.125, 0.165);
        }
        if (Ench.hasEnchantment((HolderLookup.Provider)this.level().registryAccess(), (ResourceKey<Enchantment>)Enchantments.CHANNELING, this.getTrackedStack()) && owner != null) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel world = (ServerLevel)level;
                for (int i = 0; i < 10; ++i) {
                    world.sendParticles((ParticleOptions)ParticleTypes.GLOW, this.getRandomX(1.0), this.getY() + (double)(this.getBbHeight() * this.random.nextFloat()), this.getRandomZ(1.0), 1 + this.random.nextInt(2), 0.0, (double)(this.random.nextFloat() + 0.25f), 0.0, 0.0);
                }
                world.playSeededSound(null, this.position().x, this.position().y, this.position().z, PastelSounds.ELECTRIC_DISCHARGE, SoundSource.AMBIENT, 1.0f, 0.6f + this.random.nextFloat() * 0.2f, 0L);
            }
            this.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        this.getEntityData().set(TridentEntityAccessor.getLoyalty(), (Object)4);
        this.setNoPhysics(true);
    }

    public void yoink(@Nullable Entity yoinked, Vec3 target, double xMod, double yMod) {
        if (yoinked == null) {
            return;
        }
        Vec3 yoinkPos = yoinked.position();
        double heightDif = Math.abs(yoinkPos.y - target.y);
        Vec3 velocity = target.subtract(yoinkPos);
        boolean sneaking = yoinked.isShiftKeyDown();
        float bonusMod = 1.0f;
        if (yoinked instanceof LivingEntity) {
            LivingEntity livingYoink = (LivingEntity)yoinked;
            bonusMod /= (float)Optional.ofNullable(livingYoink.getEffect(PastelMobEffects.DENSITY)).map(effect -> effect.getAmplifier() + 2).orElse(1).intValue();
            bonusMod *= Optional.ofNullable(livingYoink.getEffect(PastelMobEffects.LIGHTWEIGHT)).map(effect -> Float.valueOf((float)(effect.getAmplifier() + 2) / 1.5f)).orElse(Float.valueOf(1.0f)).floatValue();
        }
        if (!yoinked.onGround()) {
            yMod += 0.05;
            xMod -= 0.015;
        }
        yMod = Math.max(0.0725, yMod * (1.0 - heightDif * 0.024));
        xMod *= (double)bonusMod;
        yMod *= (double)bonusMod;
        if (yoinked == this.getOwner() && yoinkPos.y > target.y && !sneaking) {
            yMod = 0.0;
        }
        yoinked.setDeltaMovement(velocity.multiply(xMod, yMod, xMod).add(0.0, sneaking ? 0.0 : 0.25, 0.0));
        yoinked.fallDistance = 0.0f;
        yoinked.hurtMarked = true;
        yoinked.hasImpulse = true;
    }

    public void tickDespawn() {
        if (!this.getRootStack().isEmpty()) {
            return;
        }
        int life = ((PersistentProjectileEntityAccessor)((Object)this)).getLife() + 1;
        ((PersistentProjectileEntityAccessor)((Object)this)).setLife(life);
        if (life >= 1200) {
            this.discard();
        }
    }

    public void remove(Entity.RemovalReason reason) {
        ItemStack rootStack = this.getRootStack();
        if (!rootStack.isEmpty()) {
            SlotReservingItem.free(rootStack);
        }
        super.remove(reason);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HIT, (Object)false);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.entityData.set(HIT, (Object)nbt.getBoolean("hit"));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean("hit", ((Boolean)this.entityData.get(HIT)).booleanValue());
    }

    private ItemStack getRootStack() {
        Entity entity = this.getOwner();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return DragonTalonItem.findThrownStack(player, this.uuid);
        }
        return ItemStack.EMPTY;
    }

    protected boolean tryPickup(Player player) {
        ItemStack rootStack = DragonTalonItem.findThrownStack(player, this.uuid);
        if (!rootStack.isEmpty()) {
            SlotReservingItem.free(rootStack);
            return true;
        }
        if (player == this.getOwner()) {
            this.discard();
        }
        return false;
    }

    @Nullable
    public ItemEntity spawnAtLocation(ItemStack stack) {
        return null;
    }

    @Nullable
    public ItemEntity spawnAtLocation(ItemStack stack, float yOffset) {
        return null;
    }

    @Override
    public ColorGradient getGradient() {
        return new ColorGradient(new Color(255, 158, 60), new Color(255, 77, 38)).fadeAlpha(1.0f, 0.0f).fadeAlpha(0.0f, 0.0f, 1.0f, 0.05f);
    }
}

