/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.entity;

import com.cmdpro.databank.misc.ColorGradient;
import earth.terrarium.pastel.api.item.SlotReservingItem;
import earth.terrarium.pastel.entity.PastelEntityTypes;
import earth.terrarium.pastel.entity.entity.BidentBaseEntity;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.helpers.enchantments.ImprovedCriticalHelper;
import earth.terrarium.pastel.items.tools.DraconicTwinswordItem;
import earth.terrarium.pastel.mixin.accessors.TridentEntityAccessor;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import earth.terrarium.pastel.registries.PastelEnchantments;
import earth.terrarium.pastel.registries.PastelSounds;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.jetbrains.annotations.Nullable;

public class DraconicTwinswordEntity
extends BidentBaseEntity {
    private static final EntityDataAccessor<Boolean> HIT = SynchedEntityData.defineId(DraconicTwinswordEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> PROPELLED = SynchedEntityData.defineId(DraconicTwinswordEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> REBOUND = SynchedEntityData.defineId(DraconicTwinswordEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> MAX_PIERCE = SynchedEntityData.defineId(DraconicTwinswordEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDimensions initialSize = EntityDimensions.scalable((float)1.5f, (float)1.5f);
    private static final EntityDimensions shortSize = EntityDimensions.scalable((float)1.0f, (float)1.0f);
    private static final EntityDimensions tallSize = EntityDimensions.scalable((float)1.0f, (float)1.8f);
    private final Set<Entity> piercedEntities = new HashSet<Entity>();
    private int travelingTicks = 0;
    private int jiggleTicks = 20;
    private int jiggleIntensity = 8;
    private float damageMult = 1.0f;
    private float velMult = 1.0f;

    public DraconicTwinswordEntity(Level world) {
        this((EntityType<? extends ThrownTrident>)((EntityType)PastelEntityTypes.DRACONIC_TWINSWORD.get()), world);
    }

    public DraconicTwinswordEntity(EntityType<? extends ThrownTrident> entityType, Level world) {
        super(entityType, world);
    }

    public boolean isPickable() {
        return true;
    }

    public void tick() {
        block4: {
            block3: {
                if (!this.isPropelled() || this.isRebounding()) break block3;
                if (this.travelingTicks >= 12) break block4;
                ++this.travelingTicks;
                if (this.travelingTicks <= 6 || !(this.getDeltaMovement().lengthSqr() > 2.0)) break block4;
                this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
                this.hasImpulse = true;
                this.hurtMarked = true;
                break block4;
            }
            if (this.inGround) {
                this.damageMult = 1.0f;
                this.velMult = 1.0f;
                if (this.jiggleTicks < 15) {
                    ++this.jiggleTicks;
                    float intensity = 1.0f - (float)this.jiggleTicks / 15.0f;
                    this.xRotO = this.getXRot();
                    this.setXRot(this.xRotO + (float)this.jiggleIntensity * intensity / 2.0f * (float)(this.random.nextInt(3) - 1));
                    this.yRotO = this.getYRot();
                    this.setYRot(this.yRotO + (float)this.jiggleIntensity * intensity * (float)(this.random.nextInt(3) - 1));
                }
                for (Entity thornCandidate : this.level().getEntities((Entity)this, this.makeBoundingBox(), x$0 -> this.canHitEntity((Entity)x$0))) {
                    if (!((Boolean)this.entityData.get(HIT)).booleanValue() || thornCandidate instanceof ItemEntity || !thornCandidate.hurt(this.damageSources().thorns((Entity)this), 4.0f)) continue;
                    this.playSound(SoundEvents.THORNS_HIT, 1.0f, 0.9f + this.random.nextFloat() * 0.2f);
                }
            }
        }
        super.tick();
    }

    @Override
    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.TRIDENT_HIT_GROUND;
    }

    public boolean hurt(DamageSource source, float amount) {
        Entity striker = source.getEntity();
        if (striker == null) {
            return false;
        }
        if (!((Boolean)this.entityData.get(HIT)).booleanValue()) {
            if (this.isPropelled()) {
                this.applyInertiaEffects(this.getTrackedStack());
            }
            this.travelingTicks = 0;
            this.setVelocity(striker.getXRot(), striker.getYRot(), 0.0f, 3.0f * this.velMult);
            this.setXRot(striker.getXRot());
            this.setYRot(striker.getYRot());
            this.xRotO = this.getXRot();
            this.yRotO = this.getYRot();
            this.setPropelled(true);
            this.setRebounding(false);
            ((TridentEntityAccessor)((Object)this)).setDealtDamage(false);
            this.playSound(PastelSounds.METAL_HIT, 0.8f, 0.8f + this.random.nextFloat() * 0.4f);
        } else {
            this.jiggleTicks = 0;
            this.jiggleIntensity = 8;
            this.playSound(SoundEvents.TRIDENT_HIT_GROUND, 1.0f, 1.0f);
        }
        return false;
    }

    public boolean isAttackable() {
        return true;
    }

    @Override
    public AABB makeBoundingBox() {
        if (this.isPropelled()) {
            return super.makeBoundingBox();
        }
        if (this.isRebounding()) {
            return shortSize.makeBoundingBox(this.position());
        }
        if (this.inGround) {
            float absPitch = Math.abs(this.getXRot());
            if (absPitch > 55.0f) {
                return tallSize.makeBoundingBox(this.position());
            }
            return shortSize.makeBoundingBox(this.position());
        }
        return initialSize.makeBoundingBox(this.position());
    }

    public void setVelocity(float pitch, float yaw, float roll, float speed) {
        float f = -Mth.sin((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)));
        float g = -Mth.sin((float)((pitch + roll) * ((float)Math.PI / 180)));
        float h = Mth.cos((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)));
        this.setDeltaMovement(new Vec3((double)f, (double)g, (double)h).scale((double)speed));
        this.hasImpulse = true;
        this.hurtMarked = true;
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        ServerLevel serverWorld;
        Entity attacked = entityHitResult.getEntity();
        if (attacked.getType() == EntityType.ENDERMAN) {
            return;
        }
        boolean propelled = this.isPropelled();
        ItemStack stack = this.getTrackedStack();
        int channeling = Ench.getLevel((HolderLookup.Provider)this.level().registryAccess(), (ResourceKey<Enchantment>)Enchantments.CHANNELING, stack);
        Entity owner = this.getOwner();
        if (this.piercedEntities.contains(attacked)) {
            return;
        }
        float damage = propelled ? 2.0f : 1.0f;
        damage = this.adjustDamage(damage, channeling);
        boolean crit = false;
        DamageSource damageSource = PastelDamageTypes.impaling(this.level(), (Entity)this, owner);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            serverWorld = (ServerLevel)level;
            damage *= EnchantmentHelper.modifyDamage((ServerLevel)serverWorld, (ItemStack)stack, (Entity)attacked, (DamageSource)damageSource, (float)this.getDamage(stack));
        }
        if (!attacked.onGround() && propelled) {
            damage *= 3.0f + ImprovedCriticalHelper.getAddtionalCritDamageMultiplier((HolderLookup.Provider)this.level().registryAccess(), stack);
            crit = true;
        }
        if (attacked.hurt(damageSource, damage)) {
            if (attacked.getType() == EntityType.ENDERMAN) {
                return;
            }
            level = this.level();
            if (level instanceof ServerLevel) {
                serverWorld = (ServerLevel)level;
                EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverWorld, (Entity)attacked, (DamageSource)damageSource, (ItemStack)stack);
            }
            if (attacked instanceof LivingEntity) {
                LivingEntity livingAttacked = (LivingEntity)attacked;
                this.doKnockback(livingAttacked, damageSource);
                this.doPostHurtEffects(livingAttacked);
            }
        }
        if (crit) {
            this.playSound(PastelSounds.CRITICAL_CRUNCH, 1.0f, 1.0f);
            this.playSound(PastelSounds.IMPACT_BASE, 1.8f, 0.5f);
        } else {
            this.playSound(PastelSounds.IMPALING_HIT, 1.0f, 0.9f + this.random.nextFloat() * 0.2f);
        }
        if (this.getMaxPierce() > 0) {
            this.damageMult *= 0.8f;
            this.piercedEntities.add(attacked);
            this.setMaxPierce(this.getMaxPierce() - 1);
            return;
        }
        ((TridentEntityAccessor)((Object)this)).setDealtDamage(true);
        this.applyChannelingAOE(channeling, damage, attacked, damageSource);
        this.applyInertiaEffects(stack);
        this.setDeltaMovement(this.getDeltaMovement().multiply(-1.0, -1.0, -1.0));
        this.travelingTicks = 0;
        this.setPropelled(false);
        if (owner != null) {
            this.rebound(owner.position(), 0.105, 0.15);
        }
    }

    private void applyInertiaEffects(ItemStack stack) {
        int inertia = Ench.getLevel((HolderLookup.Provider)this.level().registryAccess(), PastelEnchantments.INERTIA, stack);
        if (inertia > 0) {
            this.damageMult += (float)inertia * 0.1675f;
            if (this.velMult < 2.0f) {
                this.velMult += 0.1f;
            }
        }
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        double boost;
        BlockPos pos = blockHitResult.getBlockPos();
        BlockState state = this.level().getBlockState(pos);
        ItemStack stack = this.getTrackedStack();
        int channeling = Ench.getLevel((HolderLookup.Provider)this.level().registryAccess(), (ResourceKey<Enchantment>)Enchantments.CHANNELING, stack);
        float damage = this.adjustDamage(this.getDamage(stack), channeling);
        DamageSource damageSource = PastelDamageTypes.impaling(this.level(), (Entity)this, this.getOwner());
        boolean slime = state.is(Blocks.SLIME_BLOCK);
        boolean bounce = (state.is(Blocks.SLIME_BLOCK) || state.getDestroySpeed((BlockGetter)this.level(), pos) >= 25.0f) && !state.is(BlockTags.PLANKS) && !state.is(BlockTags.DIRT);
        double d = boost = this.getDeltaMovement().length() < 1.0 || slime ? 1.4 : 0.9;
        if (this.isPropelled() && bounce && this.getDeltaMovement().lengthSqr() > 1.0) {
            switch (blockHitResult.getDirection().getAxis()) {
                case X: {
                    this.setDeltaMovement(this.getDeltaMovement().multiply(-boost, boost, boost));
                    break;
                }
                case Y: {
                    this.setDeltaMovement(this.getDeltaMovement().multiply(boost, -boost, boost));
                    break;
                }
                case Z: {
                    this.setDeltaMovement(this.getDeltaMovement().multiply(boost, boost, -boost));
                }
            }
            this.playSound(PastelSounds.METAL_TAP, 1.0f, 1.5f);
            this.applyChannelingAOE(channeling, damage, null, damageSource);
            this.travelingTicks = 0;
            return;
        }
        if (!this.isRebounding() && !this.isPropelled() && bounce && this.getOwner() != null) {
            this.travelingTicks = 0;
            this.rebound(this.getOwner().position(), 0.105, 0.15);
            this.playSound(PastelSounds.METAL_TAP, 1.0f, 1.5f);
            return;
        }
        super.onHitBlock(blockHitResult);
        if (((Boolean)this.entityData.get(HIT)).booleanValue() || this.isNoPhysics()) {
            return;
        }
        if (this.isPropelled()) {
            this.applyChannelingAOE(channeling, damage * 2.0f, null, damageSource);
        }
        this.setRebounding(false);
        this.setPropelled(false);
        this.entityData.set(HIT, (Object)true);
        this.jiggleTicks = 0;
        this.jiggleIntensity = 4;
    }

    private float adjustDamage(float damage, int channeling) {
        return damage *= this.damageMult * (channeling > 0 ? 0.75f : 1.0f);
    }

    private void applyChannelingAOE(int channeling, float damage, @Nullable Entity except, DamageSource damageSource) {
        if (channeling > 0 && !this.level().isClientSide()) {
            ServerLevel world = (ServerLevel)this.level();
            AABB hitbox = this.makeBoundingBox().inflate(2.5 + (double)channeling * 1.5);
            List entities = this.level().getEntities((Entity)this, hitbox);
            float spreadingDamage = damage * (1.0f - 1.0f / ((float)channeling + 2.0f));
            boolean anyHit = false;
            for (Entity entity : entities) {
                LivingEntity living;
                if (!(entity instanceof LivingEntity) || (living = (LivingEntity)entity) == except || living == this.getOwner() || !living.hurt(damageSource, spreadingDamage / Math.max(entity.distanceTo((Entity)this) / 2.0f, 1.0f))) continue;
                for (int i = 0; i < 8; ++i) {
                    world.sendParticles((ParticleOptions)ParticleTypes.ENCHANTED_HIT, living.getRandomX(1.25), living.getY() + (double)(living.getBbHeight() * this.random.nextFloat()), living.getRandomZ(1.25), 1 + this.random.nextInt(2), 0.0, (double)(this.random.nextFloat() / 6.0f), 0.0, 0.0);
                }
                anyHit = true;
            }
            if (anyHit) {
                for (int i = 0; i < 10 * channeling; ++i) {
                    world.sendParticles((ParticleOptions)ParticleTypes.GLOW, this.getRandomX(1.0), this.getY() + (double)(this.getBbHeight() * this.random.nextFloat()), this.getRandomZ(1.0), 1 + this.random.nextInt(2), 0.0, (double)(this.random.nextFloat() + 0.25f), 0.0, 0.0);
                }
                world.playSeededSound(null, this.position().x, this.position().y, this.position().z, PastelSounds.ELECTRIC_DISCHARGE, SoundSource.PLAYERS, 1.0f, 0.6f + this.random.nextFloat() * 0.2f, 0L);
            }
        }
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 currentPosition, Vec3 nextPosition) {
        return ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)currentPosition, (Vec3)nextPosition, (AABB)this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), x$0 -> this.canHitEntity((Entity)x$0));
    }

    private float getDamage(ItemStack stack) {
        MutableDouble damage = new MutableDouble(0.0);
        ResourceKey key = Attributes.ATTACK_DAMAGE.unwrapKey().orElse(null);
        double base = ((Attribute)Attributes.ATTACK_DAMAGE.value()).getDefaultValue();
        ItemAttributeModifiers modifiers = (ItemAttributeModifiers)stack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        modifiers.forEach(EquipmentSlot.MAINHAND, (attribute, modifier) -> {
            if (attribute.is(key)) {
                double value = modifier.amount();
                damage.addAndGet(switch (modifier.operation()) {
                    default -> throw new MatchException(null, null);
                    case AttributeModifier.Operation.ADD_VALUE -> value;
                    case AttributeModifier.Operation.ADD_MULTIPLIED_BASE -> value * base;
                    case AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> value * damage.getValue();
                });
            }
        });
        return damage.getValue().floatValue();
    }

    public void tickDespawn() {
    }

    public boolean isPropelled() {
        return (Boolean)this.entityData.get(PROPELLED);
    }

    public boolean isRebounding() {
        return (Boolean)this.entityData.get(REBOUND);
    }

    public void setPropelled(boolean propelled) {
        this.entityData.set(PROPELLED, (Object)propelled);
    }

    public void setRebounding(boolean rebounding) {
        this.entityData.set(REBOUND, (Object)rebounding);
    }

    public void rebound(Vec3 target, double xMod, double yMod) {
        this.setRebounding(true);
        Vec3 yPos = this.position();
        double heightDif = Math.abs(yPos.y - target.y);
        Vec3 velocity = target.subtract(yPos);
        float finalMult = (this.velMult - 1.0f) / 2.0f + 1.0f;
        yMod = Math.max(0.0725, yMod * (1.0 - heightDif * 0.024));
        this.setDeltaMovement(velocity.multiply(xMod, yMod, xMod).scale((double)finalMult).add(0.0, 0.3, 0.0));
        this.setYRot(-this.getYRot());
        this.setXRot(-this.getXRot());
        this.hurtMarked = true;
        this.hasImpulse = true;
    }

    public void remove(Entity.RemovalReason reason) {
        ItemStack rootStack = this.getRootStack();
        if (!rootStack.isEmpty()) {
            SlotReservingItem.free(rootStack);
        }
        super.remove(reason);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HIT, (Object)false);
        builder.define(PROPELLED, (Object)false);
        builder.define(REBOUND, (Object)false);
        builder.define(MAX_PIERCE, (Object)0);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.entityData.set(HIT, (Object)nbt.getBoolean("hit"));
        this.setPropelled(nbt.getBoolean("propelled"));
        this.setRebounding(nbt.getBoolean("rebounding"));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean("hit", ((Boolean)this.entityData.get(HIT)).booleanValue());
        nbt.putBoolean("propelled", this.isPropelled());
        nbt.putBoolean("rebounding", this.isRebounding());
    }

    public void setMaxPierce(int pierce) {
        this.entityData.set(MAX_PIERCE, (Object)pierce);
    }

    public int getMaxPierce() {
        return (Integer)this.entityData.get(MAX_PIERCE);
    }

    private ItemStack getRootStack() {
        Entity entity = this.getOwner();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return DraconicTwinswordItem.findThrownStack(player, this.uuid);
        }
        return ItemStack.EMPTY;
    }

    public void playerTouch(Player player) {
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        return this.tryPickup(player) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    protected boolean tryPickup(Player player) {
        if (player != this.getOwner()) {
            player.hurt(this.damageSources().thorns((Entity)this), 20.0f);
            this.playSound(SoundEvents.THORNS_HIT, 1.0f, 0.9f + this.random.nextFloat() * 0.2f);
            return false;
        }
        ItemStack rootStack = DraconicTwinswordItem.findThrownStack(player, this.uuid);
        if (!rootStack.isEmpty()) {
            if (this.level().isClientSide()) {
                return true;
            }
            SlotReservingItem.free(rootStack);
            player.take((Entity)this, 1);
            player.playSound(SoundEvents.ITEM_PICKUP, 1.0f, 1.0f);
            this.discard();
            return true;
        }
        this.discard();
        return false;
    }

    @Nullable
    public ItemEntity spawnAtLocation(ItemStack stack) {
        return null;
    }

    @Nullable
    public ItemEntity spawnAtLocation(ItemStack stack, float yOffset) {
        return null;
    }

    @Override
    public ColorGradient getGradient() {
        return new ColorGradient(new Color(-1184512), new Color(16736284)).fadeAlpha(1.0f, 0.0f).fadeAlpha(0.0f, 0.0f, 1.0f, 0.05f);
    }
}

