/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.entity;

import com.cmdpro.databank.misc.ColorGradient;
import earth.terrarium.pastel.entity.PastelEntityTypes;
import earth.terrarium.pastel.entity.entity.BidentBaseEntity;
import earth.terrarium.pastel.entity.entity.LightShardEntity;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.registries.PastelSounds;
import java.awt.Color;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.Nullable;

public class BidentMirrorImageEntity
extends BidentBaseEntity {
    public BidentMirrorImageEntity(Level world) {
        this((EntityType<? extends ThrownTrident>)((EntityType)PastelEntityTypes.BIDENT_MIRROR_IMAGE.get()), world);
    }

    public BidentMirrorImageEntity(EntityType<? extends ThrownTrident> entityType, Level world) {
        super(entityType, world);
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.level().addParticle((ParticleOptions)PastelParticleTypes.MIRROR_IMAGE, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
        }
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        Level world = this.level();
        world.playSound(null, entityHitResult.getEntity().blockPosition(), PastelSounds.MEDIUM_CRYSTAL_RING, SoundSource.PLAYERS, 1.334f, 0.9f + this.random.nextFloat() * 0.334f);
        world.playSound(null, entityHitResult.getEntity().blockPosition(), PastelSounds.SHATTER_HEAVY, SoundSource.PLAYERS, 0.75f, 1.0f + this.random.nextFloat() * 0.2f);
        if (!world.isClientSide) {
            this.processHit(entityHitResult.getEntity(), 1.0f);
        }
        this.discard();
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        Level world = this.level();
        world.playSound(null, blockHitResult.getBlockPos(), PastelSounds.SHATTER_HEAVY, SoundSource.PLAYERS, 0.75f, 1.0f);
        if (!world.isClientSide) {
            this.processHit(null, 0.667f);
        }
        this.discard();
    }

    private void processHit(@Nullable Entity target, float effectMult) {
        LivingEntity lv;
        LivingEntity livingOwner;
        RegistryAccess drm = this.level().registryAccess();
        ItemStack stack = this.getTrackedStack();
        float power = (float)Ench.getLevel((HolderLookup.Provider)drm, (ResourceKey<Enchantment>)Enchantments.POWER, stack) * 0.3f + 1.0f;
        int efficiency = Ench.getLevel((HolderLookup.Provider)drm, (ResourceKey<Enchantment>)Enchantments.EFFICIENCY, stack);
        Level world = this.level();
        Entity entity = this.getOwner();
        LivingEntity user = entity instanceof LivingEntity ? (livingOwner = (LivingEntity)entity) : null;
        LightShardEntity.summonBarrage(world, user, this.position(), target instanceof LivingEntity ? (lv = (LivingEntity)target) : null, le -> le.getType().getCategory() == MobCategory.MONSTER, (IntProvider)UniformInt.of((int)5, (int)(8 + 2 * efficiency)), () -> new LightShardEntity(world, user, effectMult * power, 200.0f + (float)(40 * efficiency) / effectMult));
    }

    @Override
    public ColorGradient getGradient() {
        return new ColorGradient(new Color(14934271), new Color(-8377404)).fadeAlpha(0.8f, 0.0f).fadeAlpha(0.0f, 0.0f, 1.0f, 0.05f);
    }
}

