/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.data_loaders;

import com.cmdpro.databank.DatabankUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import earth.terrarium.pastel.PastelCommon;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class ParticleSpawnerParticlesDataLoader
extends SimpleJsonResourceReloadListener {
    public static final String ID = "particle_spawner_particle";
    public static final ParticleSpawnerParticlesDataLoader INSTANCE = new ParticleSpawnerParticlesDataLoader();
    protected static final List<ParticleSpawnerEntry> PARTICLES = new ArrayList<ParticleSpawnerEntry>();

    private ParticleSpawnerParticlesDataLoader() {
        super(new Gson(), ID);
    }

    protected void apply(Map<ResourceLocation, JsonElement> prepared, ResourceManager manager, ProfilerFiller profiler) {
        PARTICLES.clear();
        prepared.forEach((identifier, jsonElement) -> {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            String particleTypeString = jsonObject.get("particle_type").getAsString();
            ParticleType particleType = (ParticleType)BuiltInRegistries.PARTICLE_TYPE.get(ResourceLocation.tryParse((String)particleTypeString));
            ResourceLocation guiTexture = ResourceLocation.tryParse((String)jsonObject.get("gui_texture").getAsString());
            ResourceLocation unlockIdentifier = jsonObject.has("unlock_identifier") ? ResourceLocation.tryParse((String)jsonObject.get("unlock_identifier").getAsString()) : null;
            boolean supportsColoring = GsonHelper.getAsBoolean((JsonObject)jsonObject, (String)"supports_coloring", (boolean)false);
            if (particleType == null) {
                PastelCommon.logError("Particle Spawner Particle '" + particleTypeString + "' not found. Will be ignored.");
                return;
            }
            PARTICLES.add(new ParticleSpawnerEntry(particleType, guiTexture, supportsColoring, unlockIdentifier));
        });
    }

    public static List<ParticleSpawnerEntry> getAllUnlocked(Player player) {
        ArrayList<ParticleSpawnerEntry> list = new ArrayList<ParticleSpawnerEntry>();
        for (ParticleSpawnerEntry entry : PARTICLES) {
            if (!DatabankUtils.hasAdvancement((Player)player, (ResourceLocation)entry.unlockIdentifier())) continue;
            list.add(entry);
        }
        return list;
    }

    public record ParticleSpawnerEntry(ParticleType<?> particleType, ResourceLocation textureIdentifier, boolean supportsColoring, @Nullable ResourceLocation unlockIdentifier) {
    }
}

