/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.data_loaders;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.conditions.ConditionalOps;

public class CrystalApothecarySimulationsDataLoader
extends SimpleJsonResourceReloadListener {
    public static final String ID = "crystal_apothecary_simulation";
    public static final CrystalApothecarySimulationsDataLoader INSTANCE = new CrystalApothecarySimulationsDataLoader();
    public static final HashMap<Block, SimulatedBlockGrowthEntry> COMPENSATIONS = new HashMap();

    private CrystalApothecarySimulationsDataLoader() {
        super(new Gson(), ID);
    }

    protected void apply(Map<ResourceLocation, JsonElement> prepared, ResourceManager manager, ProfilerFiller profiler) {
        COMPENSATIONS.clear();
        ConditionalOps registryops = this.makeConditionalOps();
        prepared.forEach((arg_0, arg_1) -> CrystalApothecarySimulationsDataLoader.lambda$apply$0((RegistryOps)registryops, arg_0, arg_1));
    }

    private static /* synthetic */ void lambda$apply$0(RegistryOps registryops, ResourceLocation identifier, JsonElement jsonElement) {
        JsonObject object = jsonElement.getAsJsonObject();
        DataResult entry = SimulatedBlockGrowthEntry.CONDITIONAL_CODEC.parse((DynamicOps)registryops, (Object)object);
        if (entry.error().isPresent() || entry.result().isEmpty()) {
            PastelCommon.logError("Crystal Apothecary Simulation error for " + String.valueOf(identifier) + ": " + String.valueOf(entry.error().get()) + ". Ignoring that one.");
            return;
        }
        if (((Optional)entry.result().get()).isEmpty()) {
            return;
        }
        DataResult buddingBlock = BuiltInRegistries.BLOCK.byNameCodec().decode((DynamicOps)JsonOps.INSTANCE, (Object)object.get("budding_block")).map(Pair::getFirst);
        if (buddingBlock.error().isPresent() || buddingBlock.result().isEmpty()) {
            PastelCommon.logError("Crystal apothecary simulation error for " + String.valueOf(identifier) + ": " + String.valueOf(buddingBlock.error().get()) + ". Ignoring that one.");
            return;
        }
        COMPENSATIONS.put((Block)buddingBlock.result().get(), (SimulatedBlockGrowthEntry)((Optional)entry.result().get()).get());
    }

    public record SimulatedBlockGrowthEntry(Collection<Block> validNeighbors, int ticksForCompensationLootPerValidNeighbor, ItemStack compensatedStack) {
        public static final Codec<SimulatedBlockGrowthEntry> CODEC = RecordCodecBuilder.create(i -> i.group((App)BuiltInRegistries.BLOCK.byNameCodec().listOf().xmap(list -> list, set -> set.stream().toList()).fieldOf("valid_neighbor_blocks").forGetter(c -> c.validNeighbors), (App)Codec.INT.optionalFieldOf("ticks_for_compensation_loot_per_valid_neighbor", (Object)10000).forGetter(c -> c.ticksForCompensationLootPerValidNeighbor), (App)ItemStack.CODEC.fieldOf("compensated_loot").forGetter(c -> c.compensatedStack)).apply((Applicative)i, SimulatedBlockGrowthEntry::new));
        public static final Codec<Optional<SimulatedBlockGrowthEntry>> CONDITIONAL_CODEC = ConditionalOps.createConditionalCodec(CODEC);
    }
}

