/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.progression.PastelCriteria;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public record PairedFoodComponent(Holder<Item> item, boolean consumeAndApplyRequiredStack, FoodProperties bonusFoodComponent) {
    public static final Codec<PairedFoodComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ITEM.holderByNameCodec().fieldOf("item").forGetter(PairedFoodComponent::item), (App)Codec.BOOL.optionalFieldOf("consume_and_apply_required_stack", (Object)true).forGetter(PairedFoodComponent::consumeAndApplyRequiredStack), (App)FoodProperties.DIRECT_CODEC.optionalFieldOf("bonus_food_component", (Object)new FoodProperties.Builder().build()).forGetter(PairedFoodComponent::bonusFoodComponent)).apply((Applicative)instance, PairedFoodComponent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PairedFoodComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ITEM), PairedFoodComponent::item, (StreamCodec)ByteBufCodecs.BOOL, PairedFoodComponent::consumeAndApplyRequiredStack, (StreamCodec)FoodProperties.DIRECT_STREAM_CODEC, PairedFoodComponent::bonusFoodComponent, PairedFoodComponent::new);

    public void tryEatFood(Level world, LivingEntity livingEntity, ItemStack eatenStack) {
        FoodProperties component;
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        int requiredSlotStack = -1;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            if (!player.getInventory().getItem(i).is(this.item)) continue;
            requiredSlotStack = i;
            break;
        }
        if (requiredSlotStack == -1) {
            return;
        }
        ItemStack foundRequiredStack = player.getInventory().getItem(requiredSlotStack);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PastelCriteria.CONDITIONAL_FOOD_EATEN.trigger(serverPlayer, eatenStack, foundRequiredStack);
        }
        if (this.consumeAndApplyRequiredStack && (component = (FoodProperties)foundRequiredStack.get(DataComponents.FOOD)) != null) {
            player.eat(world, foundRequiredStack, component);
        }
    }
}

