/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.travelersbackpack;

import com.tiviacz.travelersbackpack.api.fluids.EffectFluid;
import com.tiviacz.travelersbackpack.fluids.EffectFluidRegistry;
import earth.terrarium.pastel.blocks.fluid.PastelFluid;
import earth.terrarium.pastel.compat.PastelIntegrationPacks;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import earth.terrarium.pastel.registries.PastelFluids;
import earth.terrarium.pastel.registries.PastelMobEffects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;

public class TravelersBackpackCompat
extends PastelIntegrationPacks.ModIntegrationPack {
    @Override
    public void register() {
        EffectFluidRegistry.registerFluidEffect((EffectFluid)new PastelEffectFluid(this, "pastel:humus", ((PastelFluid)((Object)PastelFluids.HUMUS.get())).getSource()){

            public void affectDrinker(FluidStack fluidVariantWrapper, Level world, Entity entity) {
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200));
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 400, 2));
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 600, 3));
                }
            }
        });
        EffectFluidRegistry.registerFluidEffect((EffectFluid)new PastelEffectFluid(this, "pastel:liquid_crystal", ((PastelFluid)((Object)PastelFluids.LIQUID_CRYSTAL.get())).getSource()){

            public void affectDrinker(FluidStack fluidStack, Level world, Entity entity) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 400, 1));
                }
            }
        });
        EffectFluidRegistry.registerFluidEffect((EffectFluid)new PastelEffectFluid(this, "pastel:midnight_solution", ((PastelFluid)((Object)PastelFluids.MIDNIGHT_SOLUTION.get())).getSource()){

            public void affectDrinker(FluidStack fluidStack, Level world, Entity entity) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.giveExperiencePoints(-20);
                    ArrayList equipment = new ArrayList();
                    player.getAllSlots().forEach(equipment::add);
                    Collections.shuffle(equipment);
                    for (ItemStack equip : equipment) {
                        ItemEnchantments enchants = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)equip);
                        if (enchants.isEmpty()) continue;
                        Set enchantments = enchants.keySet();
                        Holder enchantment = (Holder)enchantments.stream().toList().get(new Random().nextInt(enchantments.size()));
                        Ench.removeEnchantments(equip, enchantment);
                    }
                }
            }
        });
        EffectFluidRegistry.registerFluidEffect((EffectFluid)new PastelEffectFluid(this, "pastel:dragonrot", ((PastelFluid)((Object)PastelFluids.DRAGONROT.get())).getSource()){

            public void affectDrinker(FluidStack fluidStack, Level world, Entity entity) {
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    livingEntity.addEffect(new MobEffectInstance(PastelMobEffects.LIFE_DRAIN, 600, 3));
                    livingEntity.hurt(PastelDamageTypes.dragonrot(world), 1000.0f);
                }
            }
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerClient() {
    }

    public static abstract class PastelEffectFluid
    extends EffectFluid {
        public PastelEffectFluid(String id, Fluid fluid) {
            super(id, fluid, 81000);
        }

        public boolean canExecuteEffect(FluidStack stack, Level world, Entity entity) {
            return stack.getAmount() >= this.amountRequired;
        }
    }
}

