/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.modonomicon.unlock_conditions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionContext;
import earth.terrarium.pastel.api.recipe.GatedRecipe;
import earth.terrarium.pastel.compat.modonomicon.ModonomiconCompat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;

public class RecipesLoadedAndUnlockedCondition
extends BookCondition {
    protected static final String TOOLTIP = "book.condition.tooltip.pastel.recipes_loaded_and_unlocked";
    protected List<ResourceLocation> recipeIDs;

    public RecipesLoadedAndUnlockedCondition(Component tooltip, List<ResourceLocation> recipeIDs) {
        super(tooltip);
        this.recipeIDs = recipeIDs;
    }

    public static RecipesLoadedAndUnlockedCondition fromJson(ResourceLocation conditionParentId, JsonObject json, HolderLookup.Provider provider) {
        ArrayList<ResourceLocation> recipeIDs = new ArrayList<ResourceLocation>();
        JsonArray array = GsonHelper.getAsJsonArray((JsonObject)json, (String)"recipe_ids");
        for (JsonElement element : array) {
            recipeIDs.add(ResourceLocation.parse((String)element.getAsString()));
        }
        MutableComponent tooltip = RecipesLoadedAndUnlockedCondition.tooltipFromJson((JsonObject)json, (HolderLookup.Provider)provider);
        return new RecipesLoadedAndUnlockedCondition((Component)tooltip, recipeIDs);
    }

    public static RecipesLoadedAndUnlockedCondition fromNetwork(RegistryFriendlyByteBuf buffer) {
        Component tooltip = buffer.readBoolean() ? (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buffer) : null;
        int recipeCount = buffer.readInt();
        ArrayList<ResourceLocation> recipeIDs = new ArrayList<ResourceLocation>();
        for (int i = 0; i < recipeCount; ++i) {
            recipeIDs.add(buffer.readResourceLocation());
        }
        return new RecipesLoadedAndUnlockedCondition(tooltip, recipeIDs);
    }

    public ResourceLocation getType() {
        return ModonomiconCompat.RECIPE_LOADED_AND_UNLOCKED;
    }

    public void toNetwork(RegistryFriendlyByteBuf buffer) {
        buffer.writeBoolean(this.tooltip != null);
        if (this.tooltip != null) {
            ComponentSerialization.STREAM_CODEC.encode((Object)buffer, (Object)this.tooltip);
        }
        buffer.writeInt(this.recipeIDs.size());
        for (ResourceLocation identifier : this.recipeIDs) {
            buffer.writeResourceLocation(identifier);
        }
    }

    public boolean test(BookConditionContext context, Player player) {
        for (ResourceLocation recipeID : this.recipeIDs) {
            Optional optionalRecipe = player.level().getRecipeManager().byKey(recipeID);
            if (!optionalRecipe.isPresent()) continue;
            Recipe recipe = ((RecipeHolder)optionalRecipe.get()).value();
            if (recipe instanceof GatedRecipe) {
                GatedRecipe gatedRecipe = (GatedRecipe)recipe;
                if (!gatedRecipe.canPlayerCraft(player)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public List<Component> getTooltip(Player player, BookConditionContext context) {
        if (this.tooltip == null) {
            this.tooltip = Component.translatable((String)TOOLTIP, (Object[])new Object[]{this.recipeIDs});
        }
        return super.getTooltip(player, context);
    }
}

