/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.modonomicon.unlock_conditions;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionContext;
import earth.terrarium.pastel.compat.modonomicon.ModonomiconCompat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;

public class NotCondition
extends BookCondition {
    protected BookCondition child;
    protected List<Component> tooltips;

    public NotCondition(Component component, BookCondition child) {
        super(component);
        if (child == null) {
            throw new IllegalArgumentException("NotCondition must have exactly one child.");
        }
        this.child = child;
    }

    public static NotCondition fromJson(ResourceLocation conditionParentId, JsonObject json, HolderLookup.Provider provider) {
        JsonObject j = GsonHelper.getAsJsonObject((JsonObject)json, (String)"child");
        if (!j.isJsonObject()) {
            throw new JsonSyntaxException("Condition children must be an array of JsonObjects.");
        }
        BookCondition child = BookCondition.fromJson((ResourceLocation)conditionParentId, (JsonObject)j.getAsJsonObject(), (HolderLookup.Provider)provider);
        MutableComponent tooltip = NotCondition.tooltipFromJson((JsonObject)json, (HolderLookup.Provider)provider);
        return new NotCondition((Component)tooltip, child);
    }

    public static NotCondition fromNetwork(RegistryFriendlyByteBuf buffer) {
        Component tooltip = buffer.readBoolean() ? (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buffer) : null;
        return new NotCondition(tooltip, BookCondition.fromNetwork((RegistryFriendlyByteBuf)buffer));
    }

    public ResourceLocation getType() {
        return ModonomiconCompat.NOT;
    }

    public boolean requiresMultiPassUnlockTest() {
        return this.child.requiresMultiPassUnlockTest();
    }

    public BookCondition child() {
        return this.child;
    }

    public void toNetwork(RegistryFriendlyByteBuf buffer) {
        buffer.writeBoolean(this.tooltip != null);
        if (this.tooltip != null) {
            ComponentSerialization.STREAM_CODEC.encode((Object)buffer, (Object)this.tooltip);
        }
        BookCondition.toNetwork((BookCondition)this.child, (RegistryFriendlyByteBuf)buffer);
    }

    public boolean test(BookConditionContext context, Player player) {
        return !this.child.test(context, player);
    }

    public boolean testOnLoad() {
        return this.child.testOnLoad();
    }

    public List<Component> getTooltip(Player player, BookConditionContext context) {
        if (this.tooltips == null) {
            this.tooltips = new ArrayList<Component>();
            if (this.tooltip != null) {
                this.tooltips.add(this.tooltip);
            }
            this.tooltips.addAll(this.child.getTooltip(player, context));
        }
        return this.tooltips != null ? this.tooltips : List.of();
    }
}

