/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.compat.modonomicon.unlock_conditions;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionContext;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionEntryContext;
import earth.terrarium.pastel.compat.modonomicon.ModonomiconCompat;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;

public class EnchantmentRegisteredCondition
extends BookCondition {
    protected static final String TOOLTIP = "book.condition.tooltip.pastel.enchantment_registered";
    protected ResourceKey<Enchantment> enchantmentKey;

    public EnchantmentRegisteredCondition(Component tooltip, ResourceKey<Enchantment> enchantmentKey) {
        super(tooltip);
        this.enchantmentKey = enchantmentKey;
    }

    public static EnchantmentRegisteredCondition fromJson(ResourceLocation conditionParentId, JsonObject json, HolderLookup.Provider provider) {
        ResourceLocation enchantmentID = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)json, (String)"enchantment_id"));
        MutableComponent tooltip = EnchantmentRegisteredCondition.tooltipFromJson((JsonObject)json, (HolderLookup.Provider)provider);
        return new EnchantmentRegisteredCondition((Component)tooltip, (ResourceKey<Enchantment>)ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)enchantmentID));
    }

    public static EnchantmentRegisteredCondition fromNetwork(RegistryFriendlyByteBuf buffer) {
        Component tooltip = buffer.readBoolean() ? (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buffer) : null;
        ResourceLocation entryId = buffer.readResourceLocation();
        return new EnchantmentRegisteredCondition(tooltip, (ResourceKey<Enchantment>)ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)entryId));
    }

    public ResourceLocation getType() {
        return ModonomiconCompat.ENCHANTMENT_REGISTERED;
    }

    public void toNetwork(RegistryFriendlyByteBuf buffer) {
        buffer.writeBoolean(this.tooltip != null);
        if (this.tooltip != null) {
            ComponentSerialization.STREAM_CODEC.encode((Object)buffer, (Object)this.tooltip);
        }
        buffer.writeResourceLocation(this.enchantmentKey.location());
    }

    public boolean test(BookConditionContext context, Player player) {
        return Ench.getEntry((HolderLookup.Provider)player.level().registryAccess(), this.enchantmentKey).isPresent();
    }

    public List<Component> getTooltip(Player player, BookConditionContext context) {
        if (this.tooltip == null && context instanceof BookConditionEntryContext) {
            BookConditionEntryContext entryContext = (BookConditionEntryContext)context;
            this.tooltip = Component.translatable((String)TOOLTIP, (Object[])new Object[]{Component.translatable((String)entryContext.getBook().getEntry(this.enchantmentKey.location()).getName())});
        }
        return super.getTooltip(player, context);
    }
}

